/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.lang.reflect.Array;

public final class DynamicArray {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T[] append(T[] oldArr, T newObj) {
        Object[] newArr;
        if (oldArr == null) {
            if (newObj == null) throw new IllegalArgumentException("Cannot add null item to null array.");
            newArr = (Object[])Array.newInstance(newObj.getClass(), 1);
            newArr[0] = newObj;
            return newArr;
        } else {
            newArr = (Object[])Array.newInstance(DynamicArray.getArrayClass(oldArr), oldArr.length + 1);
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            newArr[newArr.length - 1] = newObj;
        }
        return newArr;
    }

    public static <T> T[] append(T[] oldArr, T newObj, Class<? extends T> arrayClass) {
        Object[] localArr = oldArr == null && arrayClass != null ? (Object[])Array.newInstance(arrayClass, 0) : oldArr;
        return DynamicArray.append(localArr, newObj);
    }

    public static <T> T[] join(T[] array1, T[] array2) {
        if (array1 == null) {
            return array2;
        }
        if (array2 == null) {
            return array1;
        }
        Class<?> type = array1.getClass().getComponentType();
        int size = array1.length + array2.length;
        Object[] newArray = (Object[])Array.newInstance(type, size);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T[] insert(T[] oldArr, T newObj, int location) {
        Object[] newArr;
        if (oldArr == null) {
            if (newObj == null) throw new IllegalArgumentException("Cannot add null item to null array.");
            newArr = (Object[])Array.newInstance(newObj.getClass(), 1);
            newArr[0] = newObj;
            return newArr;
        } else {
            if (location > oldArr.length) {
                throw new IllegalArgumentException("Index location too large (" + location + ").");
            }
            newArr = (Object[])Array.newInstance(DynamicArray.getArrayClass(oldArr), oldArr.length + 1);
            if (location == 0) {
                newArr[0] = newObj;
                System.arraycopy(oldArr, 0, newArr, 1, oldArr.length);
                return newArr;
            } else {
                System.arraycopy(oldArr, 0, newArr, 0, location);
                newArr[location] = newObj;
                System.arraycopy(oldArr, location, newArr, location + 1, oldArr.length - location);
            }
        }
        return newArr;
    }

    public static <T> T[] remove(T[] oldArr, int index) {
        Object[] newArr;
        if (oldArr == null) {
            throw new IllegalArgumentException("Cannot remove from null array.");
        }
        if (index > oldArr.length - 1 || index < 0) {
            throw new IllegalArgumentException("Index to remove from array is invalid (too small/large).");
        }
        if (index == 0) {
            newArr = (Object[])Array.newInstance(DynamicArray.getArrayClass(oldArr), oldArr.length - 1);
            System.arraycopy(oldArr, 1, newArr, 0, oldArr.length - 1);
        } else if (index == oldArr.length - 1) {
            newArr = (Object[])Array.newInstance(DynamicArray.getArrayClass(oldArr), oldArr.length - 1);
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length - 1);
        } else {
            newArr = (Object[])Array.newInstance(DynamicArray.getArrayClass(oldArr), oldArr.length - 1);
            System.arraycopy(oldArr, 0, newArr, 0, index);
            System.arraycopy(oldArr, index + 1, newArr, index, oldArr.length - index - 1);
        }
        return newArr;
    }

    public static <T> T[] remove(T[] oldArr, T victim) {
        int location;
        Object[] newArr = oldArr == null ? oldArr : ((location = DynamicArray.find(oldArr, victim)) != -1 ? (Object[])DynamicArray.remove(oldArr, location) : oldArr);
        return newArr;
    }

    public static <T> int find(T[] arr, T target) {
        int index = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != target) continue;
            index = i;
            break;
        }
        return index;
    }

    protected static Class<?> getArrayClass(Object[] arr) {
        if (arr != null) {
            return arr.getClass().getComponentType();
        }
        return null;
    }
}

