/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool.jthelp;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class HelpSet {
    private HashMap<String, URL> localMap;
    private HashMap<String, URL> combinedMap;
    private String helpTitle = "HelpSet Title";
    private ArrayList<HelpSet> helpSets = new ArrayList();

    public HelpSet() {
    }

    public String getTitle() {
        return this.helpTitle;
    }

    public HelpSet(ClassLoader loader, URL url) {
        this(loader, url, "");
    }

    public HelpSet(ClassLoader loader, URL url, String prefix) {
        XMLStreamReader reader = HelpSet.getXMLReader(url);
        try {
            while (reader != null && reader.hasNext()) {
                int Event2 = reader.next();
                switch (Event2) {
                    case 1: {
                        if ("title".equals(reader.getLocalName())) {
                            this.helpTitle = reader.getElementText();
                        }
                        if (!"mapref".equals(reader.getLocalName())) break;
                        this.localMap = new HashMap();
                        String mapLocation = reader.getAttributeValue(0);
                        URL u = HelpSet.findHelpSet(loader, prefix + mapLocation);
                        if (u == null) {
                            prefix = prefix + "moreInfo/";
                            u = HelpSet.findHelpSet(loader, prefix + mapLocation);
                        }
                        prefix = prefix + mapLocation.substring(0, mapLocation.lastIndexOf("/") + 1);
                        this.localMap = this.parseMap(loader, u, prefix);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public void add(HelpSet hs) {
        this.helpSets.add(hs);
    }

    public boolean remove(HelpSet hs) {
        return this.helpSets.remove(hs);
    }

    public ArrayList<HelpSet> getHelpSets() {
        return this.helpSets;
    }

    public HashMap<String, URL> getCombinedMap() {
        if (this.combinedMap == null) {
            this.combinedMap = new HashMap();
            if (this.localMap != null) {
                this.combinedMap.putAll(this.localMap);
            }
            for (HelpSet hs : this.helpSets) {
                this.combinedMap.putAll(hs.getCombinedMap());
            }
        }
        return this.combinedMap;
    }

    private HashMap<String, URL> parseMap(ClassLoader loader, URL url, String prefix) {
        HashMap<String, URL> result = new HashMap<String, URL>();
        HashMap<String, String> helpMap = HelpSet.readHelpMap(url);
        for (String key : helpMap.keySet()) {
            URL u = HelpSet.findHelpSet(loader, prefix + helpMap.get(key));
            if (u == null) {
                u = HelpSet.findHelpSet(loader, helpMap.get(key));
            }
            result.put(key, u);
        }
        return result;
    }

    public static HashMap<String, String> readHelpMap(URL url) {
        HashMap<String, String> result = new HashMap<String, String>();
        XMLStreamReader reader = HelpSet.getXMLReader(url);
        try {
            while (reader != null && reader.hasNext()) {
                int Event2 = reader.next();
                switch (Event2) {
                    case 1: {
                        if (!"mapID".equals(reader.getLocalName())) break;
                        String target = reader.getAttributeValue(0);
                        String htmlurl = reader.getAttributeValue(1);
                        if (htmlurl.contains("#")) {
                            htmlurl = htmlurl.substring(0, htmlurl.indexOf("#"));
                        }
                        result.put(target, htmlurl);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, URL> getLocalMap() {
        return this.localMap;
    }

    private static XMLStreamReader getXMLReader(URL url) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        URLConnection urlc = null;
        try {
            urlc = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLStreamReader reader = null;
        try {
            if (urlc != null) {
                reader = factory.createXMLStreamReader(urlc.getInputStream());
            }
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        return reader;
    }

    public static URL findHelpSet(ClassLoader loader, String name) {
        if (loader == null) {
            return ClassLoader.getSystemClassLoader().getResource(name);
        }
        URL result = loader.getResource(name);
        if (result == null) {
            result = loader.getResource("com/sun/javatest/help/" + name);
        }
        if (result == null && !name.endsWith(".hs")) {
            result = HelpSet.findHelpSet(loader, name + ".hs");
        }
        return result;
    }
}

