/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.util.PrefixMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class TabDeskView
extends DeskView {
    private JFrame mainFrame;
    private JTabbedPane contents;
    private Tool selectedTool;
    private Listener listener = new Listener();
    private Action closeAction = new CloseAction();

    TabDeskView(Desktop desktop) {
        this(desktop, TabDeskView.getDefaultBounds());
    }

    TabDeskView(DeskView other) {
        this(other.getDesktop(), other.getBounds());
        Tool[] tools = other.getTools();
        Arrays.sort(tools, new Comparator<Tool>(){

            @Override
            public int compare(Tool o1, Tool o2) {
                Long l1 = new Long(o1.getCreationTime());
                Long l2 = new Long(o2.getCreationTime());
                return l1.compareTo(l2);
            }
        });
        for (int i = 0; i < tools.length; ++i) {
            this.addTool(tools[i]);
        }
        this.setVisible(other.isVisible());
    }

    private TabDeskView(Desktop desktop, Rectangle bounds) {
        super(desktop);
        this.initMainFrame(bounds);
        this.uif.setDialogParent(this.mainFrame);
        JDialog.setDefaultLookAndFeelDecorated(false);
    }

    @Override
    public void dispose() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        super.dispose();
    }

    @Override
    public boolean isVisible() {
        return this.mainFrame.isVisible();
    }

    @Override
    public void setVisible(boolean v) {
        Window[] ww;
        if (v == this.mainFrame.isVisible()) {
            return;
        }
        this.mainFrame.setVisible(v);
        if (v && (ww = this.mainFrame.getOwnedWindows()) != null) {
            for (int i = 0; i < ww.length; ++i) {
                ww[i].toFront();
            }
        }
    }

    @Override
    public void addTool(Tool t) {
        DeskView view = t.getDeskView();
        if (view == this) {
            return;
        }
        ToolDialog[] tds = t.getToolDialogs();
        boolean[] vis = new boolean[tds.length];
        for (int i = 0; i < tds.length; ++i) {
            vis[i] = tds[i].isVisible();
        }
        if (view != null) {
            view.removeTool(t);
        }
        String tabTitle = this.getUniqueTabTitle(t.getShortTitle(), null);
        String tabToolTip = t.getTitle();
        this.contents.addTab(tabTitle, null, t, tabToolTip);
        t.addObserver(this.listener);
        this.closeAction.setEnabled(true);
        t.setDeskView(this);
        for (int i = 0; i < tds.length; ++i) {
            tds[i].initDialog(this, vis[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.contents.getComponentCount() == 0;
    }

    @Override
    public Tool[] getTools() {
        Tool[] tools = new Tool[this.contents.getComponentCount()];
        for (int i = 0; i < tools.length; ++i) {
            tools[i] = (Tool)this.contents.getComponentAt(i);
        }
        return tools;
    }

    @Override
    public void removeTool(Tool t) {
        t.removeObserver(this.listener);
        this.contents.removeChangeListener(this.listener);
        this.contents.remove(t);
        t.setDeskView(null);
        if (t == this.selectedTool) {
            this.setSelectedTool((Tool)this.contents.getSelectedComponent());
        } else {
            this.contents.setSelectedComponent(this.selectedTool);
        }
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component fo = fm.getPermanentFocusOwner();
        if (fo == null || !fo.isShowing()) {
            Container target = this.contents.getTabCount() > 0 ? this.contents : this.mainFrame;
            Container fcr = target.isFocusCycleRoot() ? target : target.getFocusCycleRootAncestor();
            FocusTraversalPolicy ftp = fcr.getFocusTraversalPolicy();
            Container c = target.isFocusable() ? target : ftp.getComponentAfter(fcr, target);
            c.requestFocusInWindow();
        }
        this.contents.addChangeListener(this.listener);
        this.closeAction.setEnabled(this.contents.getTabCount() > 0);
    }

    @Override
    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    @Override
    public void setSelectedTool(Tool t) {
        if (t == this.selectedTool) {
            return;
        }
        if (this.selectedTool != null) {
            this.removeToolMenuItemsFromFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.removeObserver(this.listener);
        }
        this.selectedTool = t;
        if (this.selectedTool == null) {
            this.mainFrame.setTitle(this.uif.getI18NString("dt.title.txt"));
            ContextHelpManager.setHelpIDString(this.contents, null);
        } else {
            this.addToolMenuItemsToFrameMenuBar(this.mainFrame, this.selectedTool);
            this.selectedTool.addObserver(this.listener);
            this.mainFrame.setTitle(this.uif.getI18NString("dt.title.tool.txt", this.selectedTool.getTitle()));
            ContextHelpManager.setHelpIDString(this.contents, ContextHelpManager.getHelpIDString(this.selectedTool));
            this.contents.setSelectedComponent(this.selectedTool);
        }
    }

    @Override
    public int getStyle() {
        return 0;
    }

    @Override
    public JFrame[] getFrames() {
        return new JFrame[]{this.mainFrame};
    }

    @Override
    public Rectangle getBounds() {
        return this.mainFrame.getBounds();
    }

    @Override
    public boolean isToolOwnerForDialog(Tool tool, Container dialog) {
        for (ToolDialog td : tool.getToolDialogs()) {
            if (td.getDialogParent() != dialog) continue;
            return true;
        }
        return dialog != null && dialog.getParent() == this.mainFrame;
    }

    @Override
    public Window createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds, int type) {
        UIFactory uif = tool.uif;
        if ((type & 1) != 0) {
            JFrame d = uif.createFrame(uiKey, title, body);
            if (menuBar != null) {
                d.setJMenuBar(menuBar);
            }
            this.setBounds(d, bounds);
            return d;
        }
        JFrame owner = this.mainFrame;
        if ((type & 0x10) != 0) {
            owner = null;
        }
        JDialog d = uif.createDialog(uiKey, owner, title, body);
        if ((type & 0x100) != 0) {
            if ((type & 0x11100) == 69888) {
                d.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
            } else if ((type & 0x1100) == 4352) {
                d.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            } else if ((type & 0x10100) == 65792) {
                d.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            } else {
                d.setModal(true);
            }
        }
        if (menuBar != null) {
            d.setJMenuBar(menuBar);
        }
        this.setBounds(d, bounds);
        return d;
    }

    private void setBounds(Window d, Rectangle bounds) {
        if (bounds == null) {
            d.pack();
            d.pack();
            d.setLocationRelativeTo(this.mainFrame);
        } else {
            d.setBounds(bounds);
        }
    }

    public Container createDialog(Tool tool, String uiKey, String title, JMenuBar menuBar, Container body, Rectangle bounds) {
        UIFactory uif = tool.uif;
        JDialog d = uif.createDialog(uiKey, this.mainFrame, title, body);
        if (menuBar != null) {
            d.setJMenuBar(menuBar);
        }
        this.setBounds(d, bounds);
        return d;
    }

    @Override
    protected void saveDesktop(Map<String, String> m) {
        TabDeskView.saveBounds(this.mainFrame, new PrefixMap<String>(m, "dt"));
        this.saveTools(m);
        int sel = this.contents.getSelectedIndex();
        if (sel >= 0) {
            m.put("dt.selected", String.valueOf(sel));
        }
    }

    @Override
    protected void restoreDesktop(Map<String, String> m) {
        TabDeskView.restoreBounds(this.mainFrame, new PrefixMap<String>(m, "dt"));
        if (this.getDesktop().getRestoreOnStart()) {
            this.restoreTools(m);
            try {
                int sel;
                String s = m.get("dt.selected");
                if (s != null && 0 <= (sel = Integer.parseInt(s)) && sel < this.contents.getTabCount()) {
                    this.contents.setSelectedIndex(sel);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void initMainFrame(Rectangle bounds) {
        this.mainFrame = this.createFrame(this.listener, this.closeAction, "tdi.main");
        this.contents = this.uif.createTabbedPane("tdi.desk");
        this.contents.setOpaque(true);
        this.contents.setPreferredSize(new Dimension(bounds.width, bounds.height));
        this.contents.setTabPlacement(3);
        this.contents.addChangeListener(this.listener);
        this.contents.addAncestorListener(this.listener);
        this.mainFrame.setContentPane(this.contents);
        this.mainFrame.setBounds(bounds);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TabDeskView.this.getDesktop().checkToolsAndExitIfOK(TabDeskView.this.mainFrame);
            }
        });
    }

    private String getUniqueTabTitle(String base, Component ignoreable) {
        int i;
        HashSet<String> s = new HashSet<String>();
        for (i = 0; i < this.contents.getTabCount(); ++i) {
            if (this.contents.getComponentAt(i) == ignoreable) continue;
            s.add(this.contents.getTitleAt(i));
        }
        if (s.contains(base)) {
            for (i = 0; i <= s.size(); ++i) {
                String v = base + " [" + (i + 2) + "]";
                if (s.contains(v)) continue;
                return v;
            }
        }
        return base;
    }

    private class Listener
    implements ActionListener,
    AncestorListener,
    ChangeListener,
    MenuListener,
    Tool.Observer {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            Object o = mi.getClientProperty(this);
            if (o instanceof Window) {
                ((Window)o).toFront();
            } else if (o instanceof Tool) {
                TabDeskView.this.setSelectedTool((Tool)o);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            Tool t = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (t != null) {
                TabDeskView.this.addToolMenuItemsToFrameMenuBar(TabDeskView.this.mainFrame, t);
                t.addObserver(this);
                TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.tool.txt", t.getTitle()));
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            Tool t = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (t != null) {
                t.removeObserver(this);
            }
            TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.txt"));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TabDeskView.this.setSelectedTool((Tool)TabDeskView.this.contents.getSelectedComponent());
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Tool[] tools = TabDeskView.this.getTools();
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
            if (tools.length == 0) {
                JMenuItem mi = new JMenuItem(TabDeskView.this.uif.getI18NString("dt.windows.noWindows.mit"));
                mi.setEnabled(false);
                m.add(mi);
            } else {
                int n = 0;
                for (int i = 0; i < tools.length; ++i) {
                    Tool tool = tools[i];
                    this.addMenuItem(m, n++, tool.getTitle(), tool);
                }
                Window[] ownedWindows = TabDeskView.this.mainFrame.getOwnedWindows();
                for (int i = 0; i < ownedWindows.length; ++i) {
                    Window w = ownedWindows[i];
                    if (!w.isVisible()) continue;
                    if (w instanceof JDialog) {
                        this.addMenuItem(m, n++, ((JDialog)w).getTitle(), w);
                    }
                    if (!(w instanceof JFrame)) continue;
                    this.addMenuItem(m, n++, ((JFrame)w).getTitle(), w);
                }
            }
        }

        private void addMenuItem(JMenu m, int n, String s, Object o) {
            JMenuItem mi = new JMenuItem(TabDeskView.this.uif.getI18NString("dt.windows.toolX.mit", new Object[]{new Integer(n), s}));
            if (n < 10) {
                mi.setMnemonic(Character.forDigit(n, 10));
            }
            mi.addActionListener(this);
            mi.putClientProperty(this, o);
            m.add(mi);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            m.removeAll();
        }

        @Override
        public void shortTitleChanged(Tool src, String newValue) {
            for (int i = 0; i < TabDeskView.this.contents.getTabCount(); ++i) {
                if (TabDeskView.this.contents.getComponentAt(i) != src) continue;
                String tabTitle = TabDeskView.this.getUniqueTabTitle(newValue, src);
                TabDeskView.this.contents.setTitleAt(i, tabTitle);
                break;
            }
        }

        @Override
        public void titleChanged(Tool src, String newValue) {
            if (src == TabDeskView.this.contents.getSelectedComponent()) {
                TabDeskView.this.mainFrame.setTitle(TabDeskView.this.uif.getI18NString("dt.title.tool.txt", newValue));
            }
            for (int i = 0; i < TabDeskView.this.contents.getTabCount(); ++i) {
                if (TabDeskView.this.contents.getComponentAt(i) != src) continue;
                TabDeskView.this.contents.setToolTipTextAt(i, newValue);
                break;
            }
        }

        @Override
        public void toolDisposed(Tool src) {
        }
    }

    private class CloseAction
    extends ToolAction {
        CloseAction() {
            super(TabDeskView.this.uif, "tdi.file.close");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tool t = (Tool)TabDeskView.this.contents.getSelectedComponent();
            if (t != null && TabDeskView.this.getDesktop().isOKToClose(t, TabDeskView.this.mainFrame)) {
                TabDeskView.this.removeTool(t);
                t.dispose();
            }
        }
    }
}

