/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ResourceLoader;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

class ManagerLoader {
    private Class<?> managerClass;
    private Constructor<?> constr;
    private Class<?>[] constrArgTypes;
    private Object[] constrArgs;
    private PrintStream log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ManagerLoader.class);

    ManagerLoader(Class<?> managerClass, PrintStream log) {
        this.setManagerClass(managerClass);
        this.setLog(log);
    }

    void setManagerClass(Class<?> managerClass) {
        this.managerClass = managerClass;
    }

    void setManagerConstructorArgs(Class<?>[] argTypes, Object[] args) {
        this.constrArgTypes = argTypes;
        this.constrArgs = args;
    }

    void setLog(PrintStream log) {
        this.log = log;
    }

    Set<Object> loadManagers(String resourceName) throws IOException {
        Enumeration<URL> e = ResourceLoader.getResources(resourceName, this.getClass());
        HashSet<Object> mgrs = new HashSet<Object>();
        URLClassLoader altLoader = null;
        while (e.hasMoreElements()) {
            URL entry = e.nextElement();
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(entry.openStream()));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    if (line.startsWith("#")) {
                        if (!(line = line.substring(1).trim()).startsWith("classpath=")) continue;
                        line = line.substring(10).trim();
                        altLoader = this.getSecondaryLoader(line);
                        continue;
                    }
                    try {
                        Object mgr = this.newInstance(this.getClass().getClassLoader(), line, entry);
                        if (mgr == null && altLoader != null) {
                            mgr = this.newInstance(altLoader, line, entry);
                        }
                        if (mgr != null) {
                            mgrs.add(mgr);
                            continue;
                        }
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindClass", new Object[]{line, entry});
                    }
                    catch (IllegalAccessException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantAccessClass", new Object[]{line, entry});
                    }
                    catch (InstantiationException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantCreateClass", new Object[]{line, entry});
                    }
                    catch (NoSuchMethodException ex) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindConstr", new Object[]{line, entry});
                    }
                }
                in.close();
            }
            catch (IOException ex) {
                if (this.log == null) continue;
                this.writeI18N("ml.cantRead", new Object[]{entry, ex});
            }
        }
        return mgrs;
    }

    private Object newInstance(ClassLoader cl, String className, URL specfile) throws InstantiationException, NoSuchMethodException, IllegalAccessException {
        if (cl == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(className, true, cl);
            Object mgr = this.newInstance(c);
            if (this.managerClass.isInstance(mgr)) {
                return mgr;
            }
            if (this.log != null) {
                this.writeI18N("ml.notSubtype", new Object[]{className, this.managerClass.getName(), specfile});
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private Object newInstance(Class<?> c) throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        if (this.constrArgTypes == null || this.constrArgTypes.length == 0) {
            return c.newInstance();
        }
        try {
            Constructor<?> constr = c.getConstructor(this.constrArgTypes);
            return constr.newInstance(this.constrArgs);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(e);
        }
    }

    private URLClassLoader getSecondaryLoader(String paths) {
        String[] cps = StringArray.splitList(paths, ":");
        if (cps == null || cps.length == 0) {
            return null;
        }
        URL[] urls = new URL[]{};
        boolean someCPok = false;
        for (String s : cps) {
            URL u = ResourceLoader.getExtUrl(new File(s));
            if (u == null) continue;
            urls = DynamicArray.append(urls, u);
            someCPok = true;
        }
        if (!someCPok || urls == null || urls.length == 0) {
            if (this.log != null) {
                this.log.println("Unable to create valid paths from any of the custom tool classpath items.");
            }
            return null;
        }
        try {
            URLClassLoader cl = new URLClassLoader(urls);
            return cl;
        }
        catch (SecurityException e) {
            if (this.log != null) {
                this.log.println("Unable to create custom class loader to load tool managers:");
                e.printStackTrace(this.log);
            }
            return null;
        }
    }

    private void writeI18N(String key, Object[] args) {
        this.log.println(i18n.getString(key, args));
    }
}

