/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ListIterator;

public class LogManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(LogManager.class);

    @Override
    public HelpTree.Node getHelp() {
        HelpTree.Node[] cmdNodes = new HelpTree.Node[]{this.getCommandHelp(LogCommand.getName()), VerboseCommand.getHelp()};
        return new HelpTree.Node(i18n, "logm.help", cmdNodes);
    }

    private HelpTree.Node getCommandHelp(String name) {
        return new HelpTree.Node(i18n, "logm.help." + name);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (LogManager.isPrefixMatch(cmd, VerboseCommand.getName())) {
            ctx.addCommand(new VerboseCommand(cmd));
            return true;
        }
        if (LogManager.isMatch(cmd, LogCommand.getName())) {
            ctx.addCommand(new LogCommand(argIter));
            return true;
        }
        return false;
    }

    static class LogCommand
    extends Command {
        private File file;

        static String getName() {
            return "log";
        }

        LogCommand(ListIterator<String> argIter) throws Command.Fault {
            super(LogCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(i18n, "logm.log.missingArg");
            }
            this.file = new File(this.nextArg(argIter));
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            PrintWriter newLog;
            try {
                newLog = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw (Command)this.new Command.Fault(i18n, "logm.log.cantOpenFile", e);
            }
            PrintWriter oldLog = ctx.getLogWriter();
            oldLog.close();
            ctx.setLogWriter(newLog);
        }
    }
}

