/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.ProductInfo;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.text.DateFormat;
import java.util.Date;
import java.util.ListIterator;

public class HttpManager
extends CommandManager {
    private boolean httpFlag;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ConfigManager.class);

    @Override
    public HelpTree.Node getHelp() {
        String[] cmds = new String[]{HttpCommand.getName()};
        return new HelpTree.Node(i18n, "http", cmds);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (HttpManager.isMatch(cmd, HttpCommand.getName())) {
            if (!this.httpFlag) {
                ctx.addCommand(new HttpCommand());
                this.httpFlag = true;
            }
            return true;
        }
        return false;
    }

    private static class HttpCommand
    extends Command {
        static String getName() {
            return "startHttp";
        }

        HttpCommand() {
            super(HttpCommand.getName());
        }

        @Override
        public void run(CommandContext ctx) {
            HttpdServer server = new HttpdServer();
            Thread thr = new Thread(server);
            Date date = ProductInfo.getBuildDate();
            DateFormat df = DateFormat.getDateInstance(1);
            PageGenerator.setSWName(ProductInfo.getName());
            PageGenerator.setSWBuildDate(df.format(date));
            PageGenerator.setSWVersion(ProductInfo.getVersion());
            thr.start();
        }
    }
}

