/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableList
extends JComponent
implements Accessible {
    protected final UIFactory uif;
    private static UIFactory defaultUIF;
    protected DefaultListModel<Object> listModel;
    private JList<Object> list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private Listener listener = new Listener();
    private Renderer renderer = new Renderer();
    private boolean duplicatesAllowed;

    public EditableList() {
        this(new UIFactory(EditableList.class, null), "list");
    }

    private static UIFactory getDefaultUIF() {
        if (defaultUIF == null) {
            defaultUIF = new UIFactory(EditableList.class, null);
        }
        return defaultUIF;
    }

    public EditableList(UIFactory uif, String uiKey) {
        this.uif = uif;
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.listModel.addListDataListener(this.listener);
        this.list = uif.createList(uiKey, this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.renderer);
        this.list.addListSelectionListener(this.listener);
        this.add((Component)new JScrollPane(this.list), "Center");
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        this.addBtn = this.createButton(uiKey + ".add");
        bar.add(this.addBtn);
        this.removeBtn = this.createButton(uiKey + ".remove");
        bar.add(this.removeBtn);
        this.upBtn = this.createButton(uiKey + ".up");
        bar.add(this.upBtn);
        this.downBtn = this.createButton(uiKey + ".down");
        bar.add(this.downBtn);
        this.add((Component)bar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.list.setEnabled(b);
        this.updateButtons();
    }

    public void setItems(Object[] items) {
        this.listModel.clear();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                this.listModel.addElement(items[i]);
            }
        }
    }

    public void clear() {
        this.listModel.clear();
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class<?> c) {
        Object[] items = (Object[])Array.newInstance(c, this.listModel.size());
        this.listModel.copyInto(items);
        return items;
    }

    @Override
    public String getToolTipText() {
        return this.list.getToolTipText();
    }

    @Override
    public void setToolTipText(String tip) {
        this.list.setToolTipText(tip);
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public void setDuplicatesAllowed(boolean b) {
        this.duplicatesAllowed = b;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    protected Object getDisplayValue(Object item) {
        return item;
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)this.uif.getI18NString("list.add.txt"));
    }

    protected Object getNewItem(Object oldItem) {
        return JOptionPane.showInputDialog(this, this.uif.getI18NString("list.change.txt"), oldItem);
    }

    private JButton createButton(String uiKey) {
        JButton b = this.uif.createButton(uiKey);
        b.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        b.addActionListener(this.listener);
        b.setMnemonic(this.uif.getI18NString(uiKey + ".mne").charAt(0));
        return b;
    }

    private void insertItem() {
        Object newItem = this.getNewItem();
        if (!this.duplicatesAllowed && this.listModel.contains(newItem)) {
            this.showDuplicateError(newItem);
            return;
        }
        if (newItem != null) {
            if (this.list.isSelectionEmpty()) {
                this.listModel.addElement(newItem);
            } else {
                this.listModel.add(1 + this.list.getSelectedIndex(), newItem);
            }
            this.list.setSelectedValue(newItem, true);
        }
    }

    private void removeSelectedItem() {
        if (!this.list.isSelectionEmpty()) {
            this.listModel.remove(this.list.getSelectedIndex());
        }
    }

    private void moveSelectedItemUp() {
        int i;
        if (!this.list.isSelectionEmpty() && (i = this.list.getSelectedIndex()) > 0) {
            this.swap(i, i - 1);
            this.list.setSelectedIndex(i - 1);
        }
    }

    private void moveSelectedItemDown() {
        int i;
        if (!this.list.isSelectionEmpty() && (i = this.list.getSelectedIndex()) + 1 < this.listModel.size()) {
            this.swap(i, i + 1);
            this.list.setSelectedIndex(i + 1);
        }
    }

    private void editItem(int index) {
        Object newItem = this.getNewItem(this.listModel.getElementAt(index));
        if (!this.duplicatesAllowed && this.listModel.contains(newItem)) {
            this.showDuplicateError(newItem);
            return;
        }
        if (newItem != null) {
            this.listModel.set(index, newItem);
        }
    }

    private void showDuplicateError(Object item) {
        String text = this.uif.getI18NString("list.duplicate.text", new Object[]{this.getDisplayValue(item)});
        String title = this.uif.getI18NString("list.duplicate.title");
        JOptionPane.showMessageDialog(this, text, title, 1);
    }

    private void updateButtons() {
        boolean enabled = this.isEnabled();
        this.addBtn.setEnabled(enabled);
        if (this.list.isSelectionEmpty() || !enabled) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int i = this.list.getSelectedIndex();
            this.upBtn.setEnabled(i > 0);
            this.downBtn.setEnabled(i + 1 < this.listModel.size());
        }
    }

    private void swap(int i1, int i2) {
        Object o1 = this.listModel.elementAt(i1);
        Object o2 = this.listModel.elementAt(i2);
        this.listModel.set(i1, o2);
        this.listModel.set(i2, o1);
    }

    private class Listener
    implements ActionListener,
    ListDataListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == EditableList.this.addBtn) {
                EditableList.this.insertItem();
            } else if (src == EditableList.this.removeBtn) {
                EditableList.this.removeSelectedItem();
            } else if (src == EditableList.this.upBtn) {
                EditableList.this.moveSelectedItemUp();
            } else if (src == EditableList.this.downBtn) {
                EditableList.this.moveSelectedItemDown();
            }
            EditableList.this.updateButtons();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            EditableList.this.updateButtons();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && (index = EditableList.this.list.locationToIndex(e.getPoint())) != -1) {
                EditableList.this.editItem(index);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ListDataEvent e2 = null;
            Object[] listeners = EditableList.this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(EditableList.this, e.getType(), e.getIndex0(), e.getIndex1());
                }
                ((ListDataListener)listeners[i + 1]).contentsChanged(e2);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            ListDataEvent e2 = null;
            Object[] listeners = EditableList.this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(EditableList.this, e.getType(), e.getIndex0(), e.getIndex1());
                }
                ((ListDataListener)listeners[i + 1]).intervalAdded(e2);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListDataEvent e2 = null;
            Object[] listeners = EditableList.this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ListDataListener.class) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(EditableList.this, e.getType(), e.getIndex0(), e.getIndex1());
                }
                ((ListDataListener)listeners[i + 1]).intervalRemoved(e2);
            }
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent(list, EditableList.this.getDisplayValue(value), index, isSelected, cellHasFocus);
        }
    }
}

