/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.util.I18NResourceBundle;
import java.net.URL;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public abstract class Command {
    public static final int DEFAULT_DTMODE = 0;
    public static final int DESKTOP_NOT_REQUIRED_DTMODE = 1;
    public static final int DESKTOP_REQUIRED_DTMODE = 2;
    private Vector<String> args = new Vector();

    protected Command(String name) {
        this.args.add(name);
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }

    protected String nextArg(Iterator<String> argIter) {
        String s = argIter.next();
        this.addArg(s);
        return s;
    }

    protected void putbackArg(ListIterator<String> argIter) {
        argIter.previous();
        this.args.remove(this.args.size() - 1);
    }

    public String[] getArgs() {
        Object[] a = new String[this.args.size()];
        this.args.copyInto(a);
        return a;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.args.size(); ++i) {
            boolean hasEscape;
            String arg;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            boolean hasSpace = (arg = this.args.elementAt(i)).indexOf(32) != -1;
            boolean hasQuote = arg.indexOf(34) != -1;
            boolean bl = hasEscape = arg.indexOf(92) != -1;
            if (hasSpace) {
                sb.append('\"');
            }
            if (hasQuote || hasEscape) {
                for (int ci = 0; ci < arg.length(); ++ci) {
                    char c = arg.charAt(ci);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
            } else {
                sb.append(arg);
            }
            if (!hasSpace) continue;
            sb.append('\"');
        }
        return sb.toString();
    }

    public int getDesktopMode() {
        return this.isActionCommand() ? 1 : 0;
    }

    public URL getCustomSplash() {
        return null;
    }

    ClassLoader getCustomHelpLoader() {
        return null;
    }

    public boolean isActionCommand() {
        return false;
    }

    public abstract void run(CommandContext var1) throws Fault;

    protected InterviewParameters getConfig(CommandContext ctx) throws Fault {
        try {
            return ctx.getConfig();
        }
        catch (CommandContext.Fault e) {
            throw new Fault(e);
        }
    }

    public class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        public Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }

        public Fault(CommandContext.Fault e) {
            super(e.getMessage(), e);
        }

        public Command getCommand() {
            return Command.this;
        }
    }
}

