/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportModel;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.BackupUtil;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Vector;

public class Report
implements ReportModel {
    private InterviewParameters params;
    private TestFilter[] paramFilters;
    private File reportDir;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Report.class);
    public static final String MARKER_FILE_NAME = "reportdir.dat";
    public static final String INDEX_FILE_NAME = "index.html";
    private List<StartGenListener> startGenListeners;

    public Report() {
    }

    public Report(InterviewParameters params, File dir) {
        this.params = params;
        this.reportDir = dir.getAbsoluteFile();
    }

    public Report(InterviewParameters params, File dir, TestFilter tf) {
        this(params, dir);
        this.paramFilters = new TestFilter[]{tf};
    }

    @Deprecated
    public void writeReport(Settings s, File dir) throws IOException {
        this.writeReports(s.getSettings(), dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeReports(ReportSettings s, File dir) throws IOException {
        this.reportDir = dir.getAbsoluteFile();
        s.getInterview().getWorkDirectory().getTestResultTable().waitUntilReady();
        this.backupReports(this.reportDir, s);
        s.setupSortedResults();
        s.setupKfl();
        ArrayList<ReportFormat.ReportLink> links = new ArrayList<ReportFormat.ReportLink>();
        try {
            ServiceLoader<ReportFormat> reportLoader = ServiceLoader.load(ReportFormat.class);
            for (ReportFormat rf : reportLoader) {
                boolean wasInterrapted = this.doReport(rf, s, links);
                if (!wasInterrapted) continue;
                return;
            }
            Report.writePrefs(s);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
        }
        finally {
            s.cleanup();
        }
        this.updateStaffFiles(this.reportDir, s, links);
    }

    private boolean doReport(ReportFormat rf, ReportSettings s, ArrayList<ReportFormat.ReportLink> links) throws RuntimeException, IOException {
        if (rf.acceptSettings(s)) {
            try {
                links.add(this.writeReport(s, rf));
            }
            catch (RuntimeException t) {
                t.printStackTrace();
                throw t;
            }
            if (Thread.currentThread().isInterrupted()) {
                return true;
            }
        }
        for (ReportFormat sub : rf.getSubReports()) {
            boolean wasInterrapted = this.doReport(sub, s, links);
            if (!wasInterrapted) continue;
            return true;
        }
        return false;
    }

    public void writeReport(String ... types) throws IOException {
        ReportSettings settings = Report.getSettingsPrefs();
        settings.setInterview(this.params);
        String[] typesToGen = types == null ? new String[]{"html", "txt"} : Arrays.copyOf(types, types.length);
        if (this.paramFilters != null) {
            settings.filter = this.paramFilters.length == 1 ? this.paramFilters[0] : new CompositeFilter(this.paramFilters);
        }
        this.params.getWorkDirectory().getTestResultTable().waitUntilReady();
        this.backupReports(this.reportDir, settings);
        settings.setupSortedResults();
        settings.setupKfl();
        ServiceLoader<ReportFormat> reportLoader = ServiceLoader.load(ReportFormat.class);
        ArrayList<ReportFormat.ReportLink> links = new ArrayList<ReportFormat.ReportLink>();
        for (ReportFormat rf : reportLoader) {
            this.doCLReport(rf, settings, typesToGen, links);
        }
        if (links.isEmpty()) {
            throw new IllegalArgumentException("Unknown report types: " + Arrays.toString(types));
        }
        if (links.size() != typesToGen.length) {
            throw new IllegalArgumentException("Not all report types are known: " + Arrays.toString(types));
        }
        this.updateStaffFiles(this.reportDir, settings, links);
    }

    private void doCLReport(ReportFormat rf, ReportSettings settings, String[] types, ArrayList<ReportFormat.ReportLink> links) throws IOException {
        String id = rf.getTypeName();
        for (String t : types) {
            if (!t.toLowerCase().equals(id)) continue;
            links.add(this.writeReport(settings, rf));
        }
        for (ReportFormat sub : rf.getSubReports()) {
            this.doCLReport(sub, settings, types, links);
        }
    }

    public static boolean isReportDirectory(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(MARKER_FILE_NAME)) continue;
            return true;
        }
        return false;
    }

    private void backupReports(File dir, ReportSettings s) {
        if (s.isBackupsEnabled()) {
            BackupUtil.backupAllSubdirs(dir, s.backups);
            this.backupIndexFile(dir, s.backups);
        }
    }

    private void backupIndexFile(File dir, int maxBackups) {
        int nbackups = BackupUtil.backupFile(new File(dir, INDEX_FILE_NAME), maxBackups);
        for (int i = 1; i <= nbackups; ++i) {
            this.updateIndexLinks(new File(dir, "index.html~" + Integer.toString(i) + "~"), i);
        }
    }

    private void updateIndexLinks(File index, int backupNumb) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(index), StandardCharsets.UTF_8));){
            String line;
            while ((line = r2.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException r2) {
            // empty catch block
        }
        String oldId = backupNumb == 1 ? "" : "~" + (backupNumb - 1) + "~";
        String newId = "~" + backupNumb + "~";
        File reportDir = index.getParentFile();
        File[] files = reportDir.listFiles();
        ArrayList<File> subdirs = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory() || files[i].getName().lastIndexOf(newId) == -1) continue;
            subdirs.add(files[i]);
        }
        LinkFinder finder = new LinkFinder(index);
        Vector<String> links = finder.getLinks();
        block24: for (int i = 0; i < links.size(); ++i) {
            String link = links.get(i);
            for (int j = 0; j < subdirs.size(); ++j) {
                String newName = ((File)subdirs.get(j)).getName();
                String oldName = newName.replaceAll(newId, oldId);
                if (link.lastIndexOf(oldName) == -1) continue;
                StringBuilder newLink = new StringBuilder(link);
                int link_start = newLink.indexOf(oldName);
                newLink.replace(link_start, link_start + oldName.length(), newName);
                int start = sb.indexOf(link);
                sb.replace(start, start + link.length(), newLink.toString());
                continue block24;
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(index), StandardCharsets.UTF_8));){
            writer.write(sb.toString());
            ((Writer)writer).flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateStaffFiles(File dir, ReportSettings s, List<ReportFormat.ReportLink> links) {
        this.updateMarkerFile(dir);
        this.updateIndexFile(dir, s, links);
    }

    private void updateMarkerFile(File dir) {
        File f = new File(dir, MARKER_FILE_NAME);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                return;
            }
        }
    }

    private void updateIndexFile(File dir, ReportSettings s, List<ReportFormat.ReportLink> links) {
        File f = new File(dir, INDEX_FILE_NAME);
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
            this.fillIndexFile(f, s, links);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fillIndexFile(File index, ReportSettings s, List<ReportFormat.ReportLink> links) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(index), StandardCharsets.UTF_8));){
            String[] predefinedFormats;
            HTMLWriterEx out = new HTMLWriterEx(writer);
            out.setI18NResourceBundle(i18n);
            out.startTag("html");
            out.startTag("head");
            out.writeContentMeta();
            out.startTag("title");
            out.writeI18N("index.title");
            out.endTag("title");
            out.endTag("head");
            out.startTag("body");
            out.startTag("h1");
            out.write(s.getInterview().getTestSuite().getName());
            out.endTag("h1");
            out.newLine();
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(i18n.getString("index.dateFormat"));
            out.write(i18n.getString("index.date.txt", format.format(date)));
            out.newLine();
            for (String f : predefinedFormats = new String[]{"html", "text", "xml", "cof"}) {
                this.putLink(f, links, out);
            }
            this.putCustomLink(predefinedFormats, links, out);
            out.endTag("body");
            out.endTag("html");
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void putCustomLink(String[] predefinedFormats, List<ReportFormat.ReportLink> links, HTMLWriterEx out) throws IOException {
        for (ReportFormat.ReportLink ln : links) {
            if (Arrays.asList(predefinedFormats).contains(ln.linkID)) continue;
            this.writeReportLink(out, ln);
        }
    }

    private void putLink(String type, List<ReportFormat.ReportLink> links, HTMLWriterEx out) throws IOException {
        for (ReportFormat.ReportLink ln : links) {
            if (!type.equalsIgnoreCase(ln.linkID)) continue;
            this.writeReportLink(out, ln);
        }
    }

    private void writeReportLink(HTMLWriterEx out, ReportFormat.ReportLink ln) throws IOException {
        out.startTag("p");
        out.writeLink(ln.linkFile, ln.linkText);
        out.startTag("br");
        out.write(ln.linkDesk);
        out.endTag("p");
    }

    @Override
    public File getReportDir() {
        return this.reportDir;
    }

    public static String[] getHtmlReportFilenames() {
        return HTMLReport.getReportFilenames();
    }

    private ReportFormat.ReportLink writeReport(ReportSettings settings, ReportFormat rf) throws IOException {
        File out = new File(this.reportDir, rf.getBaseDirName());
        out.mkdir();
        this.notifyStartGenListeners(settings, rf.getReportID());
        return rf.write(settings, out);
    }

    private void notifyStartGenListeners(ReportSettings s, String reportID) {
        if (this.startGenListeners != null) {
            for (int i = 0; i < this.startGenListeners.size(); ++i) {
                StartGenListener sgl = this.startGenListeners.get(i);
                sgl.startReportGeneration(s, reportID);
            }
        }
    }

    public static void writePrefs(ReportSettings s) {
        Preferences prefs = Preferences.access();
        s.write(prefs);
    }

    public static ReportSettings getSettingsPrefs() {
        Preferences prefs = Preferences.access();
        return ReportSettings.create(prefs);
    }

    public void addStartGenListener(StartGenListener l) {
        if (this.startGenListeners == null) {
            this.startGenListeners = new ArrayList<StartGenListener>();
        }
        this.startGenListeners.add(l);
    }

    public void removeStartGeneratingListener(StartGenListener l) {
        if (this.startGenListeners != null) {
            this.startGenListeners.remove(l);
        }
    }

    public static interface StartGenListener {
        public void startReportGeneration(ReportSettings var1, String var2);
    }

    public static interface CustomReportManager {
        public CustomReport[] getCustomReports();
    }

    private class LinkFinder {
        private File index;

        public LinkFinder(File index) {
            this.index = index;
        }

        public Vector<String> getLinks() {
            Vector<String> links = new Vector<String>();
            StringBuilder content = new StringBuilder();
            try (BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.index), StandardCharsets.UTF_8));){
                String line;
                while ((line = r2.readLine()) != null) {
                    content.append(line);
                    content.append("\n");
                }
            }
            catch (IOException r2) {
                // empty catch block
            }
            int i = 0;
            while (i < content.length() - 1) {
                if (content.charAt(i) == '<' && content.charAt(i + 1) == 'a') {
                    StringBuilder link = new StringBuilder();
                    link.append(content.charAt(i));
                    link.append(content.charAt(++i));
                    ++i;
                    boolean end = false;
                    while (!end && i < content.length() - 1) {
                        if (content.charAt(i) == '/' && content.charAt(i + 1) == 'a') {
                            link.append(content.charAt(i));
                            link.append(content.charAt(++i));
                            link.append(content.charAt(++i));
                            ++i;
                            end = true;
                            continue;
                        }
                        link.append(content.charAt(i));
                        ++i;
                    }
                    links.add(link.toString());
                    continue;
                }
                ++i;
            }
            return links;
        }
    }

    @Deprecated
    public static class Settings {
        ReportSettings sett;

        @Deprecated
        public Settings(InterviewParameters params) {
            this.sett = new ReportSettings(params);
        }

        @Deprecated
        public void setEnableHtmlReport(boolean state) {
            this.sett.setEnableHtmlReport(state);
        }

        @Deprecated
        public void setHtmlMainReport(boolean reportHtml, boolean indexHtml) {
            this.sett.setHtmlMainReport(reportHtml, indexHtml);
        }

        @Deprecated
        public void setEnablePlainReport(boolean state) {
            this.sett.setEnablePlainReport(state);
        }

        @Deprecated
        public void setEnableXmlReport(boolean state) {
            this.sett.setEnableXmlReport(state);
        }

        @Deprecated
        public void setFilter(CompositeFilter compositeFilter) {
            this.sett.setFilter(compositeFilter);
        }

        @Deprecated
        public void setEnableBackups(boolean state) {
            this.sett.setEnableBackups(state);
        }

        @Deprecated
        public void setBackupLevels(int levels) {
            this.sett.setBackupLevels(levels);
        }

        @Deprecated
        public boolean isPlainEnabled() {
            return this.sett.isPlainEnabled();
        }

        ReportSettings getSettings() {
            return this.sett;
        }
    }
}

