/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.TestSuite;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportFormat;
import com.sun.javatest.report.ReportSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CustomReportFormat
implements ReportFormat {
    private CustomReport theCustomReport;
    private ArrayList<ReportFormat> subreports = new ArrayList();
    private static final List<CustomReport> NO_REPORTS = Collections.emptyList();

    public CustomReportFormat() {
    }

    private CustomReportFormat(CustomReport r) {
        this.theCustomReport = r;
    }

    @Override
    public ReportFormat.ReportLink write(ReportSettings s, File dir) throws IOException {
        if (this.theCustomReport != null) {
            File f = this.theCustomReport.createReport(dir);
            return new ReportFormat.ReportLink(this.theCustomReport.getName(), this.theCustomReport.getReportId(), this.theCustomReport.getDescription(), f);
        }
        throw new IllegalStateException();
    }

    @Override
    public String getReportID() {
        if (this.theCustomReport != null) {
            return this.theCustomReport.getReportId();
        }
        return null;
    }

    @Override
    public String getBaseDirName() {
        if (this.theCustomReport != null) {
            return this.theCustomReport.getReportId();
        }
        return null;
    }

    @Override
    public String getTypeName() {
        if (this.theCustomReport != null) {
            return this.theCustomReport.getReportId();
        }
        return null;
    }

    @Override
    public boolean acceptSettings(ReportSettings s) {
        if (this.theCustomReport == null) {
            this.subreports.clear();
            for (CustomReport cr : s.getCustomReports()) {
                this.subreports.add(new CustomReportFormat(cr));
            }
            return false;
        }
        return true;
    }

    @Override
    public List<ReportFormat> getSubReports() {
        return this.subreports;
    }

    private List<CustomReport> getCustomReports(ReportSettings settings) {
        TestSuite ts = settings.getInterview().getTestSuite();
        if (settings.getInterview() == null || settings.getInterview().getTestSuite() == null) {
            return NO_REPORTS;
        }
        return this.getCustomReports(ts);
    }

    private List<CustomReport> getCustomReports(TestSuite testSuite) {
        Report.CustomReportManager cm;
        String cls = testSuite.getTestSuiteInfo("tmcontext");
        try {
            cm = cls == null ? (Report.CustomReportManager)Class.forName("com.sun.javatest.exec.ContextManager").newInstance() : (Report.CustomReportManager)Class.forName(cls, true, testSuite.getClassLoader()).newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return NO_REPORTS;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return NO_REPORTS;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return NO_REPORTS;
        }
        CustomReport[] customReports = cm.getCustomReports();
        if (customReports == null || customReports.length == 0) {
            return NO_REPORTS;
        }
        return Arrays.asList(customReports);
    }
}

