/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.XMLReport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JPanel;
import org.xml.sax.SAXException;

public abstract class CustomReport {
    private ReportSettings env;

    public boolean needsXmlReport() {
        return false;
    }

    public final InputStream getXmlReport() throws IOException, SAXException {
        if (this.needsXmlReport()) {
            File xmlSrc = null;
            if (this.env.xmlReportFile != null) {
                xmlSrc = this.env.xmlReportFile;
            } else if (this.env.tmpXmlReportFile != null) {
                xmlSrc = this.env.tmpXmlReportFile;
            } else {
                this.env.tmpXmlReportFile = File.createTempFile("jtrep", "tmp");
                try (FileOutputStream fos = new FileOutputStream(this.env.tmpXmlReportFile);
                     BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));){
                    XMLReport xr = new XMLReport();
                    xr.write(fw, this.env);
                }
                xmlSrc = this.env.tmpXmlReportFile;
            }
            return new FileInputStream(xmlSrc);
        }
        return null;
    }

    public abstract File createReport(File var1) throws ReportException;

    public abstract File createReport(String var1, File var2, InterviewParameters var3, TestFilter var4) throws ReportException;

    public abstract String getReportId();

    public abstract String getName();

    public abstract String getDescription();

    public ReportSettings getReportEnviroment() {
        return this.env;
    }

    public ReportConfigPanel[] getOptionPanes() {
        return null;
    }

    public abstract String validateOptions();

    public void dispose() {
        this.env = null;
    }

    public void setEnviroment(ReportSettings envir) {
        this.env = envir;
    }

    public static abstract class ReportConfigPanel
    extends JPanel {
        public ReportConfigPanel() {
            this.setFocusable(false);
        }

        public abstract String getPanelName();
    }

    public class ReportException
    extends IOException {
        public ReportException(String message) {
            super(message);
        }
    }
}

