/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.ResourceLoader;
import com.sun.javatest.mrep.TestResultDescr;
import com.sun.javatest.mrep.XMLReportWriter;
import com.sun.javatest.report.Report;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class XMLReportReader {
    private static final String JAXP_SCHEMA_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    XMLReportReader() {
    }

    Map<Object, Object> readIDs(File file) throws SAXException, IOException, ParserConfigurationException {
        XMLReader reader = XMLReportReader.createXMLReader(true);
        IDHandler handler = new IDHandler();
        reader.setContentHandler(handler);
        reader.parse(new InputSource(file.getAbsolutePath()));
        return handler.getMap();
    }

    static XMLReader createXMLReader(boolean validating) throws SAXException, ParserConfigurationException {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setValidating(validating);
        fact.setNamespaceAware(true);
        fact.setFeature(JAXP_SCHEMA_VALIDATION, true);
        SAXParser parser = fact.newSAXParser();
        parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        InputStream sc = ResourceLoader.getResourceAsStream("test_run_report.xsd", Report.class);
        parser.setProperty(JAXP_SCHEMA_SOURCE, sc);
        XMLReader reader = parser.getXMLReader();
        reader.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return reader;
    }

    private static class IDHandler
    extends DefaultHandler {
        private Map<Object, Object> map = new HashMap<Object, Object>();
        private long time = 0L;

        private IDHandler() {
        }

        @Override
        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            if (qualifiedName.equals("TestResult")) {
                String url = attributes.getValue("url");
                int id = Integer.parseInt(attributes.getValue("workDirID"));
                String status = attributes.getValue("status");
                this.map.put(url, new TestResultDescr(status, id, this.time));
            }
            if (qualifiedName.equals("WorkDirectory")) {
                Integer id = Integer.valueOf(attributes.getValue("id"));
                this.map.put(id, id);
            }
            if (qualifiedName.equals("Report")) {
                String dateStr = attributes.getValue("generatedTime");
                try {
                    this.time = XMLReportWriter.ISO8601toDate(dateStr).getTime();
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            }
        }

        public Map<Object, Object> getMap() {
            return this.map;
        }
    }
}

