/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.mrep.BrowserPane;
import com.sun.javatest.mrep.ConflictResolutionDialog;
import com.sun.javatest.mrep.ConflictResolver;
import com.sun.javatest.mrep.Merger;
import com.sun.javatest.mrep.OptionsDialog;
import com.sun.javatest.mrep.TestResultDescr;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.HTMLWriterEx;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class ReportTool
extends Tool {
    private Desktop desktop;
    private JMenuBar menuBar;
    private BrowserPane browserPane;
    private JDialog waitDialog;
    private WaitDialogController waitDialogController;
    private static final int WAIT_DIALOG_DELAY = 3000;
    private File[] in;
    private File out;
    private boolean resolveByRecent;
    private boolean isXmlReport;
    private CustomReport[] customReports;
    private String xmlreportFileName = "report.xml";
    private boolean autoShowOptions = true;
    private Thread worker;
    private URL currURL;
    private HTMLEditorKit htmlKit;
    private JEditorPane textArea;
    private static final String NEW = "new";
    private static final String OPEN = "open";
    private OptionsDialog optionsDialog;
    private Listener listener = new Listener();
    private final String textShowing;
    private final String textHidden;

    protected ReportTool(ToolManager m, Desktop d) {
        super(m, "report", "mergeReports.window.csh");
        this.setI18NTitle("tool.title");
        this.setShortTitle(this.uif.getI18NString("tool.shortTitle"));
        this.desktop = d;
        this.initGUI();
        I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ReportTool.class);
        this.textShowing = i18n.getString("tool.helptext.showing");
        this.textHidden = i18n.getString("tool.helptext.hidden");
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    protected void restore(Map<String, String> map) {
    }

    @Override
    protected void save(Map<String, String> m) {
    }

    private void initGUI() {
        int dpi = this.uif.getDotsPerInch();
        this.setPreferredSize(new Dimension(6 * dpi, 4 * dpi));
        this.setLayout(new BorderLayout());
        this.htmlKit = new HTMLEditorKit();
        this.addHierarchyListener(this.listener);
        this.menuBar = this.uif.createMenuBar("tool");
        String[] reportMenuEntries = new String[]{NEW, OPEN};
        JMenu reportMenu = this.uif.createMenu("tool.report", reportMenuEntries, new Listener());
        this.menuBar.add(reportMenu);
        this.menuBar.add(this.uif.createHorizontalGlue("tool.pad"));
        JPanel head = this.uif.createPanel("head", false);
        head.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        head.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 2;
        c.gridheight = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.browserPane = new BrowserPane(this.uif);
        head.add((Component)this.browserPane, c);
        this.add(head);
        this.updateGUI();
    }

    void updateGUI() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReportTool.this.updateGUI();
                }
            });
            return;
        }
        if (this.browserPane.isEmpty()) {
            if (this.optionsDialog == null || !this.optionsDialog.isVisible()) {
                this.browserPane.setPlainText(this.textHidden);
            } else {
                this.browserPane.setPlainText(this.textShowing);
            }
        } else if (this.optionsDialog == null || !this.optionsDialog.isVisible()) {
            this.browserPane.setPlainTextHomePage(this.textHidden);
        } else {
            this.browserPane.setPlainTextHomePage(this.textShowing);
        }
    }

    private synchronized void showOptions() {
        if (this.worker != null) {
            this.uif.showError("tool.reportInProgress");
            return;
        }
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog(this, new OkListener(), this.uif, this.desktop);
        }
        this.optionsDialog.updateCustomReports();
        this.optionsDialog.setVisible(true);
    }

    private boolean setOptions() {
        if (!this.optionsDialog.checkInput()) {
            return false;
        }
        this.out = new File(this.optionsDialog.getResultPath());
        this.in = new File[this.optionsDialog.getXmlFiles().length];
        for (int i = 0; i < this.optionsDialog.getXmlFiles().length; ++i) {
            this.in[i] = new File(this.optionsDialog.getXmlFiles()[i]);
        }
        this.resolveByRecent = this.optionsDialog.resolveByRecent();
        this.customReports = this.optionsDialog.getCustomReports();
        this.isXmlReport = this.optionsDialog.isXmlReport();
        if (!(this.isXmlReport || this.customReports != null && this.customReports.length != 0)) {
            this.uif.showError("tool.no_report_types");
            return false;
        }
        File outXML = new File(this.out, this.xmlreportFileName);
        for (int i = 0; i < this.in.length; ++i) {
            String path = outXML.getAbsolutePath();
            if (!this.in[i].getAbsolutePath().equals(path)) continue;
            this.uif.showError("tool.outinput", path);
            return false;
        }
        try {
            this.optionsDialog.setVisible(false);
            this.startMerge();
            return true;
        }
        catch (Exception e) {
            this.uif.showError("tool.execpt", e.getMessage());
            return false;
        }
    }

    private synchronized void startMerge() {
        if (this.worker != null) {
            this.uif.showError("tool.reportInProgress");
            return;
        }
        this.waitDialog = this.uif.createWaitDialog("tool.wait", this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets.bottom = 10;
        gbc.insets.top = 10;
        gbc.gridy = 2;
        gbc.gridx = 0;
        JButton cancelBtn = this.uif.createButton("tool.cancel");
        this.waitDialog.getContentPane().add((Component)cancelBtn, gbc);
        this.waitDialog.pack();
        this.waitDialogController = new WaitDialogController(this.waitDialog);
        final String cancelling = this.uif.getI18NString("tool.cancelling");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton butt = (JButton)e.getSource();
                butt.setEnabled(false);
                Component[] cmp = ReportTool.this.waitDialog.getContentPane().getComponents();
                if (ReportTool.this.worker != null && ReportTool.this.worker.isAlive()) {
                    ReportTool.this.worker.interrupt();
                }
                for (int i = 0; i < cmp.length; ++i) {
                    if (!"tool.wait".equals(cmp[i].getName())) continue;
                    if (!(cmp[i] instanceof JTextComponent)) break;
                    ((JTextComponent)cmp[i]).setText(cancelling);
                    break;
                }
            }
        });
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Merger merger = new Merger();
                    ConflictResolver resolver = !ReportTool.this.resolveByRecent ? new ManualConfilctResolver(ReportTool.this.waitDialogController) : new MostRecentConfilctResolver();
                    ReportTool.this.out.mkdir();
                    File xmlOut = new File(ReportTool.this.out, ReportTool.this.xmlreportFileName);
                    if (merger.merge(ReportTool.this.in, xmlOut, resolver)) {
                        for (int i = 0; i < ReportTool.this.customReports.length; ++i) {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            CustomReport cr = ReportTool.this.customReports[i];
                            ReportSettings re = cr.getReportEnviroment();
                            re.setMergingFiles(ReportTool.this.in);
                            re.setXMLReportFile(xmlOut);
                            cr.createReport(new File(ReportTool.this.out, cr.getReportId()));
                        }
                        ReportTool.this.waitDialogController.finish();
                        if (!ReportTool.this.isXmlReport) {
                            xmlOut.delete();
                        }
                        ReportTool.this.showReportDialog(ReportTool.this.out);
                    }
                }
                catch (Exception e) {
                    ReportTool.this.showError("tool.exceptionInProgress", e.getMessage(), ReportTool.this.waitDialog, ReportTool.this.waitDialogController);
                }
                finally {
                    if (!ReportTool.this.waitDialogController.wasFinished) {
                        ReportTool.this.waitDialogController.finish();
                    }
                    ReportTool reportTool = ReportTool.this;
                    synchronized (reportTool) {
                        ReportTool.this.worker = null;
                    }
                    ReportTool.this.updateGUI();
                }
            }
        };
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ReportTool.this.worker != null && ReportTool.this.worker.isAlive()) {
                    ReportTool.this.waitDialogController.show();
                }
            }
        };
        Timer timer = new Timer(3000, al);
        timer.setRepeats(false);
        timer.start();
        this.worker.start();
        this.updateGUI();
    }

    private void showError(final String uiKey, final String msg, JDialog waitDialog, WaitDialogController waitDialogController) {
        if (!waitDialogController.wasFinished) {
            waitDialogController.finish();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportTool.this.uif.showError(uiKey, msg);
            }
        });
    }

    private String listLocalDirectory(File dir) {
        if (!dir.isAbsolute()) {
            dir = dir.getAbsoluteFile();
        }
        String displayPath = dir.getPath();
        String[] filelist = dir.list();
        StringWriter sw = new StringWriter();
        try {
            HTMLWriterEx out = new HTMLWriterEx((Writer)sw, this.uif.getI18NResourceBundle());
            out.startTag("html");
            out.startTag("head");
            out.writeContentMeta();
            out.startTag("title");
            out.write(displayPath);
            out.endTag("title");
            out.endTag("head");
            out.startTag("body");
            out.writeStyleAttr("font-family: SansSerif; font-size: 12pt");
            out.startTag("h3");
            out.writeI18N("fp.head", displayPath);
            out.endTag("h3");
            out.startTag("ul");
            out.writeStyleAttr("margin-left:0");
            File parent = dir.getParentFile();
            if (parent != null) {
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", "up");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.startTag("a");
                    out.writeAttr("href", parent.toURL().toString());
                    out.writeI18N("fp.parent");
                    out.endTag("a");
                }
                catch (MalformedURLException e) {
                    out.writeI18N("fp.parent");
                }
            }
            for (int i = 0; i < filelist.length; ++i) {
                File file = new File(dir, filelist[i]);
                out.startTag("li");
                out.startTag("object");
                out.writeAttr("classid", "com.sun.javatest.tool.IconLabel");
                out.writeParam("type", file.isDirectory() ? "folder" : "file");
                out.endTag("object");
                out.writeEntity("&nbsp;");
                try {
                    out.writeLink(file.toURL(), file.getName());
                    continue;
                }
                catch (MalformedURLException e) {
                    out.write(file.getName());
                }
            }
            out.endTag("ul");
            out.endTag("body");
            out.endTag("html");
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    private void loadPage(URL url) {
        if (this.currURL != null && url.toString().equals(this.currURL.toString())) {
            return;
        }
        this.currURL = url;
        String protocol = url.getProtocol();
        File file = new File(url.getFile());
        if (protocol.equals("file") && file.isDirectory()) {
            String list = this.listLocalDirectory(file);
            HTMLDocument htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
            this.textArea.setDocument(htmlDoc);
            htmlDoc.setBase(url);
            this.textArea.setContentType("text/html");
            this.textArea.setText(list);
        } else if (protocol.equals("file") && !url.getFile().endsWith(".htm") && !url.getFile().endsWith(".html")) {
            this.textArea.setContentType("text/plain");
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                this.textArea.read(r, (Object)url);
                ((Reader)r).close();
            }
            catch (IOException e) {
                this.uif.showError("fp.load.error", new Object[]{url, e});
            }
        } else {
            try {
                URL loaded = this.textArea.getPage();
                if (loaded == null || !loaded.sameFile(url)) {
                    HTMLDocument htmlDoc = (HTMLDocument)this.htmlKit.createDefaultDocument();
                    this.textArea.setDocument(htmlDoc);
                }
                this.textArea.setPage(url);
            }
            catch (IOException e) {
                this.uif.showError("fp.load.error", new Object[]{url, e});
            }
        }
    }

    private void showReportBrowser(File reportDir) {
        String[] names = Report.getHtmlReportFilenames();
        File target = reportDir;
        long newestTime = 0L;
        for (int i = 0; i < names.length; ++i) {
            File f = new File(reportDir, names[i]);
            if (!f.exists() || f.lastModified() <= newestTime) continue;
            target = f;
            newestTime = f.lastModified();
        }
        try {
            this.browserPane.setFile(target.toURL());
        }
        catch (MalformedURLException e) {
            this.uif.showError("tool.report.browser", e.getMessage());
        }
    }

    void showReportDialog(File init) {
        JFileChooser rdc = new JFileChooser(init);
        int option = rdc.showDialog(this, this.uif.getI18NString("tool.report.open"));
        if (option != 0) {
            return;
        }
        File f = rdc.getSelectedFile();
        this.showReportBrowser(f);
    }

    private class HTMLListener
    implements HyperlinkListener,
    ItemListener {
        private HTMLListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            HyperlinkEvent.EventType et = e.getEventType();
            if (et == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLDocument doc = (HTMLDocument)((JEditorPane)e.getSource()).getDocument();
                    doc.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                } else {
                    ReportTool.this.loadPage(e.getURL());
                }
            } else if (et == HyperlinkEvent.EventType.ENTERED) {
                URL u = e.getURL();
                if (u != null) {
                    ReportTool.this.textArea.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (et == HyperlinkEvent.EventType.EXITED) {
                ReportTool.this.textArea.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                URL url = (URL)e.getItem();
                ReportTool.this.loadPage(url);
            }
        }
    }

    private class Listener
    implements ActionListener,
    HierarchyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(ReportTool.NEW)) {
                ReportTool.this.showOptions();
            } else if (cmd.equals(ReportTool.OPEN)) {
                ReportTool.this.showReportDialog(ReportTool.this.out);
            }
            ReportTool.this.updateGUI();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (ReportTool.this.isShowing() && ReportTool.this.autoShowOptions) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReportTool.this.showOptions();
                        ReportTool.this.updateGUI();
                    }
                });
                ReportTool.this.autoShowOptions = false;
            }
        }
    }

    class OkListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReportTool.this.setOptions()) {
                ReportTool.this.optionsDialog.cleanUp();
            }
            ReportTool.this.updateGUI();
        }
    }

    class ManualConfilctResolver
    implements ConflictResolver {
        private File preffered = null;
        private ConflictResolutionDialog conflictResolutionDialog;
        private WaitDialogController wdc;

        public ManualConfilctResolver(WaitDialogController wdc) {
            this.wdc = wdc;
        }

        @Override
        public int resolve(String testUrl, TestResultDescr[] descrs) {
            int i;
            String[] conflictFiles = new String[descrs.length];
            for (i = 0; i < descrs.length; ++i) {
                conflictFiles[i] = descrs[i].getFile().getAbsolutePath() + " " + descrs[i].getStatus();
            }
            if (this.preffered != null) {
                for (i = 0; i < descrs.length; ++i) {
                    if (!descrs[i].getFile().equals(this.preffered)) continue;
                    return i;
                }
            }
            this.conflictResolutionDialog = new ConflictResolutionDialog(null, testUrl, conflictFiles, false, ReportTool.this.uif);
            this.wdc.hide();
            this.conflictResolutionDialog.setVisible(true);
            if (this.conflictResolutionDialog.wasCanceled()) {
                return -1;
            }
            this.wdc.restore();
            if (this.conflictResolutionDialog.getUseMostRecent()) {
                int res = 0;
                for (int i2 = 0; i2 < descrs.length; ++i2) {
                    if (descrs[i2].getTime() <= descrs[res].getTime()) continue;
                    res = i2;
                }
                return res;
            }
            int selected = this.conflictResolutionDialog.getSelectedIndex();
            if (selected != -1) {
                if (this.conflictResolutionDialog.getPreferredReport()) {
                    this.preffered = descrs[selected].getFile();
                }
                return selected;
            }
            return 0;
        }
    }

    class MostRecentConfilctResolver
    implements ConflictResolver {
        MostRecentConfilctResolver() {
        }

        @Override
        public int resolve(String testUrl, TestResultDescr[] descrs) {
            int res = 0;
            for (int i = 1; i < descrs.length; ++i) {
                boolean newer;
                boolean bl = newer = descrs[i].getTime() > descrs[res].getTime();
                if (descrs[res].isNotRun()) {
                    if (descrs[i].isNotRun() && !newer) continue;
                    res = i;
                    continue;
                }
                if (descrs[i].isNotRun() || !newer) continue;
                res = i;
            }
            return res;
        }
    }

    private static class WaitDialogController {
        private JDialog waitDialog;
        private boolean wasFinished = false;
        private boolean wasShown = false;
        private boolean wasHidden = false;

        WaitDialogController(JDialog waitDialog) {
            this.waitDialog = waitDialog;
        }

        synchronized void show() {
            if (!this.wasFinished) {
                this.wasShown = true;
                if (!this.wasHidden) {
                    this.setVisible(true);
                }
            }
        }

        synchronized void finish() {
            this.wasFinished = true;
            this.setVisible(false);
        }

        synchronized void hide() {
            this.wasHidden = true;
            if (this.wasShown && !this.wasFinished) {
                this.setVisible(false);
            }
        }

        synchronized void restore() {
            this.wasHidden = false;
            if (this.wasShown && !this.wasFinished) {
                this.setVisible(true);
            }
        }

        private synchronized void setVisible(final boolean b) {
            if (EventQueue.isDispatchThread()) {
                this.waitDialog.setVisible(b);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            WaitDialogController.this.waitDialog.setVisible(b);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

