/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.interview.DefaultInterviewParameters;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SimpleInterviewParameters
extends DefaultInterviewParameters
implements Parameters.EnvParameters {
    private Question qPrecompile = new NullQuestion(this, "precompile"){

        @Override
        public Question getNext() {
            return SimpleInterviewParameters.this.qEnvEnd;
        }

        @Override
        public void export(Map<String, String> data) {
            data.put("script.mode", "precompile");
            data.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private Question qDeveloper = new NullQuestion(this, "developer"){

        @Override
        public Question getNext() {
            return SimpleInterviewParameters.this.qName;
        }

        @Override
        public void export(Map<String, String> data) {
            data.put("script.mode", "developer");
            data.put("command.compile.java", System.getProperty("command.compile.java"));
        }
    };
    private StringQuestion qName = new StringQuestion(this, "name"){

        @Override
        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return SimpleInterviewParameters.this.qDesc;
        }
    };
    private Question qDesc = new StringQuestion(this, "desc"){

        @Override
        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return SimpleInterviewParameters.this.qCmdType;
        }

        @Override
        public void export(Map<String, String> data) {
            data.put("description", String.valueOf(this.value));
        }
    };
    private static final String AGENT = "agent";
    private static final String OTHER_VM = "otherVM";
    private Question qCmdType = new ChoiceQuestion(this, "cmdType"){
        {
            this.setChoices(new String[]{null, SimpleInterviewParameters.OTHER_VM, SimpleInterviewParameters.AGENT}, true);
        }

        @Override
        public Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(SimpleInterviewParameters.OTHER_VM)) {
                return SimpleInterviewParameters.this.qJVM;
            }
            return SimpleInterviewParameters.this.qEnvEnd;
        }

        @Override
        public void export(Map<String, String> data) {
            String cmd = this.value != null && this.value.equals(SimpleInterviewParameters.OTHER_VM) ? SimpleInterviewParameters.this.getOtherVMExecuteCommand() : "com.sun.javatest.agent.ActiveAgentCommand com.sun.javatest.lib.ExecStdTestSameJVMCmd $testExecuteClass $testExecuteArgs";
            data.put("command.execute", cmd);
        }
    };
    private FileQuestion qJVM = new FileQuestion(this, "jvm"){

        @Override
        public Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (!(this.value.exists() && this.value.isFile() && this.value.canRead())) {
                return SimpleInterviewParameters.this.qBadJVM;
            }
            return SimpleInterviewParameters.this.qClassPath;
        }
    };
    private Question qBadJVM = new ErrorQuestion(this, "badJVM"){

        @Override
        public Object[] getTextArgs() {
            return new Object[]{SimpleInterviewParameters.this.qJVM.getValue().getPath()};
        }
    };
    private FileListQuestion qClassPath = new FileListQuestion(this, "classPath"){
        {
            FileFilter[] filters = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(filters);
        }

        @Override
        public Question getNext() {
            return SimpleInterviewParameters.this.qEnvEnd;
        }
    };
    private Question qEnvEnd = new NullQuestion(this, "envEnd"){

        @Override
        public Question getNext() {
            return SimpleInterviewParameters.this.getEnvSuccessorQuestion();
        }
    };
    private static final int PRECOMPILE = 1;
    private static final int CERTIFY = 2;
    private static final int DEVELOPER = 3;
    private int mode;

    public SimpleInterviewParameters() throws Interview.Fault {
        super("simple");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setResourceBundle("i18n");
        this.mode = 2;
        String m = System.getProperty("SimpleInterviewParameters.mode");
        if (m != null) {
            if (m.equals("developer")) {
                this.mode = 3;
            } else if (m.equals("precompile")) {
                this.mode = 1;
            }
        }
    }

    @Override
    public TestEnvironment getEnv() {
        HashMap<String, String> envProps = new HashMap<String, String>();
        this.export(envProps);
        try {
            String name = this.qName.getValue();
            if (name == null || name.length() == 0) {
                name = "unknown";
            }
            return new TestEnvironment(name, envProps, "configuration interview");
        }
        catch (TestEnvironment.Fault e) {
            throw new Error("should not happen");
        }
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    public Question getEnvFirstQuestion() {
        switch (this.mode) {
            case 1: {
                return this.qPrecompile;
            }
            case 3: {
                return this.qDeveloper;
            }
        }
        return this.qName;
    }

    private String getOtherVMExecuteCommand() {
        char fs = File.separatorChar;
        char ps = File.pathSeparatorChar;
        StringBuffer sb = new StringBuffer();
        sb.append("com.sun.javatest.lib.ExecStdTestOtherJVMCmd ");
        File jvm = this.qJVM.getValue();
        sb.append(jvm == null ? "unknown_jvm" : jvm.getPath());
        File[] cpFiles = this.qClassPath.getValue();
        if (cpFiles != null && cpFiles.length > 0) {
            sb.append(" -classpath ");
            for (int i = 0; i < cpFiles.length; ++i) {
                if (i > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(cpFiles[i]);
            }
        }
        sb.append(" $testExecuteClass $testExecuteArgs");
        return sb.toString();
    }
}

