/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.interview;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;

public class EnvironmentInterview
extends Interview
implements Parameters.LegacyEnvParameters {
    private FileListQuestion qEnvFiles = new FileListQuestion(this, "envFiles"){
        {
            this.setFilter(new ExtensionFileFilter(".jte", "Environment File"));
            this.setDuplicatesAllowed(false);
        }

        @Override
        public File getBaseDirectory() {
            TestSuite ts = EnvironmentInterview.this.parent.getTestSuite();
            if (ts == null) {
                return null;
            }
            File r = ts.getRoot();
            return r.isDirectory() ? r : r.getParentFile();
        }

        @Override
        protected Question getNext() {
            EnvironmentInterview.this.updateCachedEnvTable();
            if (EnvironmentInterview.this.cachedEnvTableError != null) {
                return EnvironmentInterview.this.qEnvTableError;
            }
            if (EnvironmentInterview.this.cachedEnvTable == null || EnvironmentInterview.this.cachedEnvTable.getEnvNames().length == 0) {
                return EnvironmentInterview.this.qNoEnvs;
            }
            return EnvironmentInterview.this.qEnv;
        }
    };
    private TestEnvContext cachedEnvTable;
    private File[] cachedEnvTable_absFiles;
    private String cachedEnvTableError;
    private ErrorQuestion qNoEnvs = new ErrorQuestion(this, "noEnvs");
    private ErrorQuestion qEnvTableError = new ErrorQuestion(this, "envTableError"){

        @Override
        protected Object[] getTextArgs() {
            return new Object[]{EnvironmentInterview.this.cachedEnvTableError};
        }
    };
    private StringQuestion qEnv = new StringQuestion(this, "env"){
        private TestEnvContext cachedEnvTable;

        @Override
        public String[] getSuggestions() {
            TestEnvContext envTable = EnvironmentInterview.this.getEnvTable();
            if (envTable != this.cachedEnvTable) {
                Object[] envNames;
                if (envTable == null) {
                    envNames = new String[]{};
                } else {
                    Object[] names = envTable.getEnvMenuNames();
                    Arrays.sort(names);
                    envNames = names;
                }
                this.setSuggestions((String[])envNames);
                this.cachedEnvTable = envTable;
            }
            return super.getSuggestions();
        }

        @Override
        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            EnvironmentInterview.this.updateCachedEnv();
            if (EnvironmentInterview.this.cachedEnv == null) {
                return EnvironmentInterview.this.cachedEnvError;
            }
            return EnvironmentInterview.this.qEnd;
        }
    };
    private TestEnvironment cachedEnv;
    private TestEnvContext cachedEnv_envTable;
    private String cachedEnv_envName;
    private Question cachedEnvError;
    private Object[] cachedEnvErrorArgs;
    private ErrorQuestion qEnvError = new ErrorQuestion(this, "envError"){

        @Override
        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvNotFound = new ErrorQuestion(this, "envNotFound"){

        @Override
        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private ErrorQuestion qEnvUndefinedEntry = new ErrorQuestion(this, "envUndefinedEntry"){

        @Override
        protected Object[] getTextArgs() {
            return EnvironmentInterview.this.cachedEnvErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private InterviewParameters parent;

    public EnvironmentInterview(InterviewParameters parent) throws Interview.Fault {
        super(parent, "environment");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setHelpSet("/com/sun/javatest/moreInfo/moreInfo.hs");
        this.setFirstQuestion(this.qEnvFiles);
    }

    @Override
    public File[] getEnvFiles() {
        return this.qEnvFiles.getValue();
    }

    @Override
    public File[] getAbsoluteEnvFiles() {
        TestSuite ts = this.parent.getTestSuite();
        File tsRootDir = ts == null ? null : ts.getRootDir();
        return EnvironmentInterview.getAbsoluteFiles(tsRootDir, this.getEnvFiles());
    }

    @Override
    public void setEnvFiles(File[] files) {
        this.qEnvFiles.setValue(files);
    }

    @Override
    public String getEnvName() {
        return this.qEnv.getValue();
    }

    @Override
    public void setEnvName(String name) {
        this.qEnv.setValue(name);
    }

    @Override
    public TestEnvironment getEnv() {
        this.updateCachedEnv();
        return this.cachedEnv;
    }

    private TestEnvContext getEnvTable() {
        this.updateCachedEnvTable();
        return this.cachedEnvTable;
    }

    private void updateCachedEnvTable() {
        File[] absFiles = this.getAbsoluteEnvFiles();
        if (!EnvironmentInterview.equal(this.cachedEnvTable_absFiles, absFiles)) {
            try {
                this.cachedEnvTable = new TestEnvContext(absFiles);
                this.cachedEnvTableError = null;
            }
            catch (TestEnvContext.Fault e) {
                this.cachedEnvTable = null;
                this.cachedEnvTableError = e.getMessage();
            }
            this.cachedEnvTable_absFiles = absFiles;
        }
    }

    private void updateCachedEnv() {
        TestEnvContext envTable = this.getEnvTable();
        String envName = this.getEnvName();
        if (this.cachedEnv_envTable != envTable || !EnvironmentInterview.equal(this.cachedEnv_envName, envName)) {
            try {
                if (envTable == null || envName == null || envName.length() == 0) {
                    this.cachedEnv = null;
                    this.cachedEnvError = null;
                } else {
                    this.cachedEnv = envTable.getEnv(envName);
                    if (this.cachedEnv == null) {
                        this.cachedEnvError = this.qEnvNotFound;
                        this.cachedEnvErrorArgs = new Object[]{envName};
                    } else {
                        this.cachedEnvError = null;
                        this.cachedEnvErrorArgs = null;
                        Iterator<TestEnvironment.Element> i = this.cachedEnv.elements().iterator();
                        while (i.hasNext() && this.cachedEnvError == null) {
                            TestEnvironment.Element entry = i.next();
                            if (entry.getValue().indexOf("VALUE_NOT_DEFINED") < 0) continue;
                            this.cachedEnv = null;
                            String eText = (entry.getDefinedInEnv() == null ? "" : "env." + entry.getDefinedInEnv() + ".") + entry.getKey() + "=" + entry.getValue();
                            this.cachedEnvError = this.qEnvUndefinedEntry;
                            this.cachedEnvErrorArgs = new Object[]{eText, entry.getDefinedInFile()};
                        }
                    }
                }
            }
            catch (TestEnvironment.Fault e) {
                this.cachedEnv = null;
                this.cachedEnvError = this.qEnvError;
                this.cachedEnvErrorArgs = new Object[]{e.getMessage()};
            }
            this.cachedEnv_envTable = envTable;
            this.cachedEnv_envName = envName;
        }
    }

    private static File[] getAbsoluteFiles(File baseDir, File[] files) {
        if (files == null) {
            return null;
        }
        if (baseDir == null) {
            return files;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    private static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    private static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (EnvironmentInterview.equal(f1[i], f2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }
}

