/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;

public class ProviderRegistry {
    protected Map<String, Object> url2prov = new Hashtable<String, Object>();
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ProviderRegistry.class);
    protected static boolean debug = Boolean.getBoolean("debug." + ProviderRegistry.class.getName());
    protected JThttpProvider myProvider;

    public void addHandler(String url, String descrip, JThttpProvider obj) {
        block4: {
            if (debug) {
                System.out.println("PR-Adding Handler: " + descrip);
                System.out.println("   PR-Adding URL: " + url);
                System.out.println("   PR-Adding OBJ: " + obj);
            }
            try {
                boolean result = this.insertHandler(this.disassembleURL(url), descrip, obj, false);
                if (result) {
                    obj.addRegistredURL(url);
                }
            }
            catch (IllegalArgumentException e) {
                if (!debug) break block4;
                System.out.println("   PR-Error while inserting " + obj);
                System.out.println("   PR-Ignoring insert of URL " + url);
                e.printStackTrace();
            }
        }
    }

    public void addPrivateHandler(String url, String descrip, JThttpProvider obj) {
        block4: {
            if (debug) {
                System.out.println("PR-Adding Private Handler: " + descrip);
                System.out.println("   PR-Adding URL: " + url);
                System.out.println("   PR-Adding OBJ: " + obj);
            }
            try {
                boolean result = this.insertHandler(this.disassembleURL(url), descrip, obj, true);
                if (result) {
                    obj.addRegistredURL(url);
                }
            }
            catch (IllegalArgumentException e) {
                if (!debug) break block4;
                System.out.println("   PR-Error while inserting " + obj);
                System.out.println("   PR-Ignoring insert of URL " + url);
                e.printStackTrace();
            }
        }
    }

    public boolean removeHandler(String url, JThttpProvider obj) {
        if (debug) {
            System.out.println("PR-Removing Handler by URL: " + url);
            System.out.println("   PR-Removing OBJ : " + obj);
        }
        return this.deleteHandler(this.disassembleURL(url), obj);
    }

    public void removeHandler(JThttpProvider obj) {
        if (debug) {
            System.out.println("PR-Removing Handler by Object: " + obj);
        }
        String[] urls = obj.getRegisteredURLs();
        for (int i = 0; i < urls.length; ++i) {
            this.deleteHandler(this.disassembleURL(urls[i]), obj);
        }
    }

    public JThttpProvider getHandler(httpURL url) {
        JThttpProvider prov;
        if (url == null) {
            return null;
        }
        String nextDir = url.getNextFile();
        if (nextDir == null) {
            if (debug) {
                System.out.println("PR-End of URL, no handler, using default.");
            }
            prov = null;
        } else {
            Object target;
            if (debug) {
                System.out.println("PR-Looking up: " + nextDir);
            }
            if ((target = this.url2prov.get(nextDir)) == null) {
                prov = null;
            } else if (target instanceof HandlerEntry) {
                HandlerEntry he = (HandlerEntry)target;
                prov = he.getProvider();
            } else {
                prov = ((ProviderRegistry)target).getHandler(url);
            }
        }
        if (debug) {
            System.out.println("PR-URL resolved to: " + prov);
        }
        return prov == null ? this.getIndexProvider() : prov;
    }

    public JThttpProvider getIndexProvider() {
        if (this.myProvider == null) {
            this.myProvider = new IndexHandler(this.url2prov);
        }
        return this.myProvider;
    }

    public int getSize() {
        return this.url2prov.size();
    }

    public boolean isEmpty() {
        return this.url2prov.size() == 0;
    }

    protected Object lookupByName(String name) {
        Object obj = this.url2prov.get(name);
        if (debug) {
            System.out.println("PR-lookupName(" + name + "): " + obj);
        }
        return obj;
    }

    protected void deleteByName(String name) {
        Object obj = this.url2prov.remove(name);
        if (debug) {
            System.out.println("PR-Removed " + name + " from hashtable." + obj);
        }
    }

    static String stripDirName(String in) {
        if (in == null) {
            return null;
        }
        int startTrim = 0;
        if (in.charAt(0) == '/') {
            startTrim = 1;
        }
        int nextSlash = in.indexOf(47, startTrim);
        String processedURL = null;
        processedURL = nextSlash != -1 ? in.substring(startTrim, nextSlash) : in.substring(startTrim, in.length());
        return processedURL;
    }

    protected final boolean insertHandler(String[] url, String descrip, JThttpProvider obj, boolean hidden) throws IllegalArgumentException {
        boolean result;
        Object lookup;
        String file = url[0];
        url = (String[])DynamicArray.remove(url, false);
        if (debug) {
            System.out.println("    PR-Partial insert of " + file);
        }
        if ((lookup = this.lookupByName(file)) == null) {
            if (url == null || url.length == 0) {
                this.url2prov.put(file, new HandlerEntry(file, descrip, obj));
                if (debug) {
                    System.out.println("    Inserted " + file + " into " + this);
                }
                result = true;
            } else {
                ProviderRegistry pr = new ProviderRegistry();
                this.url2prov.put(file, pr);
                result = pr.insertHandler(url, descrip, obj, hidden);
                if (debug) {
                    System.out.println("    Created new registry and recursed, " + file);
                }
            }
        } else if (lookup instanceof ProviderRegistry) {
            if (debug) {
                System.out.println("    Found existing registry and recursed, " + file);
            }
            result = ((ProviderRegistry)lookup).insertHandler(url, descrip, obj, hidden);
        } else {
            throw new IllegalArgumentException("Supplied URL collides with another registered handler.  Ignoring new handler.");
        }
        return result;
    }

    protected final boolean deleteHandler(String[] url, JThttpProvider obj) {
        Object lookup;
        if (url.length == 0) {
            if (debug) {
                System.out.println("    PR-(del) Reached end of URL before done.");
            }
            return false;
        }
        String file = url[0];
        url = (String[])DynamicArray.remove(url, false);
        if (debug) {
            System.out.println("    PR-(del)Partial remove of " + file);
        }
        if ((lookup = this.lookupByName(file)) == null) {
            if (debug) {
                System.out.println("    PR-(del) Unable to match URL at: " + file);
            }
            return false;
        }
        if (lookup instanceof HandlerEntry) {
            HandlerEntry entry = (HandlerEntry)lookup;
            if (entry.getProvider() == obj) {
                this.deleteByName(file);
                return true;
            }
            throw new IllegalArgumentException("Given Provider ref. does not match URL Provider.  Unable to complete handler removal.");
        }
        if (lookup instanceof ProviderRegistry) {
            ProviderRegistry pr;
            boolean result;
            if (debug) {
                System.out.println("    PR-(del) Found existing registry and recursed, " + file);
            }
            if ((result = (pr = (ProviderRegistry)lookup).deleteHandler(url, obj)) && pr.isEmpty()) {
                this.deleteByName(file);
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object found in registry.  Unable to complete handler removal.");
    }

    final String[] disassembleURL(String url) {
        int pos;
        String[] result = new String[]{};
        if (url == null || url.length() == 0) {
            return result;
        }
        int urlLen = url.length();
        int start = url.charAt(0) == '/' ? 1 : 0;
        boolean done = false;
        block4: for (pos = start + 1; pos < urlLen && !done; ++pos) {
            char currC = url.charAt(pos);
            switch (currC) {
                case '/': {
                    if (pos > start + 1) {
                        result = DynamicArray.append(result, url.substring(start, pos));
                    }
                    start = pos + 1;
                    ++pos;
                    continue block4;
                }
                case ' ': 
                case '?': {
                    done = true;
                }
            }
        }
        if (!done && pos >= urlLen && pos - start >= 1) {
            result = DynamicArray.append(result, url.substring(start, pos));
        }
        if (debug) {
            System.out.println("PR-Dissolved url " + url + " into " + result.length + " files.");
        }
        return result;
    }

    protected static class IndexHandler
    extends JThttpProvider {
        private Map<String, Object> urlMap;

        IndexHandler(Map<String, Object> ht) {
            this.urlMap = ht;
        }

        @Override
        public void serviceRequest(httpURL requestURL, PrintWriter out) {
            PageGenerator.generateDocType(out, 0);
            PageGenerator.writeBeginDoc(out);
            PageGenerator.writeHeader(out, "JT Harness Webserver Root Page");
            PageGenerator.startBody(out);
            out.print("<h2>JT Harness");
            out.print("&#8482; ");
            IndexHandler.print(out, i18n.getString("provider.index.hdr"));
            out.println("</h2>");
            IndexHandler.println(out, i18n.getString("provider.index.note"));
            out.println("<br>");
            this.writeWebAvailPages(out);
            out.println("<hr>");
            PageGenerator.writeFooter(out);
            PageGenerator.endBody(out);
            PageGenerator.writeEndDoc(out);
            out.close();
        }

        private void writeWebAvailPages(PrintWriter out) {
            out.println("<h3>Available Web Pages</h3>");
            out.println("<ul>");
            for (Object next : this.urlMap.values()) {
                if (!(next instanceof HandlerEntry)) continue;
                HandlerEntry entry = (HandlerEntry)next;
                out.print("<li><a href=\"");
                out.print(entry.getURL());
                out.print("\">");
                out.print(entry.getDescription());
                out.println("</a>");
            }
            out.println("</ul>");
            out.println();
        }
    }

    private static class HandlerEntry {
        private String url;
        private String descrip;
        private JThttpProvider obj;
        private boolean hidden;

        HandlerEntry(String url, String descrip, JThttpProvider obj) {
            this.url = url;
            this.descrip = descrip;
            this.obj = obj;
        }

        public void setPrivate(boolean state) {
            this.hidden = state;
        }

        public String getURL() {
            return this.url;
        }

        public String getDescription() {
            return this.descrip;
        }

        public JThttpProvider getProvider() {
            return this.obj;
        }
    }
}

