/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.TagTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExpandTestFinder
extends TagTestFinder {
    private boolean verify;
    private Map<String, String> validEntries;
    private Map<String, String> validKeywords;
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static final String TRUE = "true";
    private Map<String, String> testStems = null;
    private Map<String, String[]> expandVars;
    private Map<String, Integer> expandVarLen;
    private String[] stdValidEntries = new String[]{"keywords", "source", "title", "context", "executeArgs", "executeClass", "executeNative", "id", "rmicClasses", "timeout"};
    private String[] stdValidKeywords = new String[]{"compiler", "runtime", "positive", "negative", "idl_inherit", "idl_tie", "interactive", "jniinvocationapi", "optionalPJava", "serial"};
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ExpandTestFinder.class);

    public ExpandTestFinder() {
        this.validEntries = this.initTable(this.stdValidEntries);
        this.validEntries = this.addTableItem(this.validEntries, "test", TRUE);
        this.validKeywords = this.initTable(this.stdValidKeywords);
        this.validKeywords = this.initTable(new String[0]);
        this.addExtension(".jasm", JavaCommentStream.class);
        this.addExtension(".jcod", JavaCommentStream.class);
    }

    @Override
    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equals("-verify")) {
            this.verify = true;
            return 1;
        }
        if (args[i].equals("-allowEntry")) {
            String e = args[i + 1];
            this.validEntries.put(e.toLowerCase(), e);
            return 2;
        }
        if (args[i].equals("-allowKeyword")) {
            String k = args[i + 1];
            this.validKeywords.put(k.toLowerCase(), k);
            return 2;
        }
        return super.decodeArg(args, i);
    }

    private Map<String, String> initTable(String[] entries) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < entries.length; ++i) {
            map.put(entries[i].toLowerCase(), entries[i]);
        }
        return map;
    }

    private Map<String, String> addTableItem(Map<String, String> entries, String name, String value) {
        entries.put(name, value);
        return entries;
    }

    @Override
    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        if (this.expandVars == null) {
            this.expandVars = new HashMap<String, String[]>(3);
            this.expandVarLen = new HashMap<String, Integer>(3);
            Iterator<String> i = env.keys().iterator();
            while (i.hasNext()) {
                try {
                    String n = i.next();
                    if (!n.startsWith("expand.")) continue;
                    String[] v = env.lookup(n);
                    String fqvName = n.substring("expand.".length());
                    this.expandVars.put(fqvName, v);
                    int pos = fqvName.indexOf(".");
                    if (pos == -1) continue;
                    String stem = fqvName.substring(0, pos);
                    Integer len = this.expandVarLen.get(stem);
                    if (len == null) {
                        this.expandVarLen.put(stem, new Integer(v.length));
                        continue;
                    }
                    if (v.length == len) continue;
                    this.error(i18n, "expand.lengthMismatch", new Object[]{stem, fqvName.substring(pos + 1)});
                }
                catch (TestEnvironment.Fault f) {
                    this.error(i18n, "expand.noDefn", f.getMessage());
                }
            }
        }
        if (testSuiteRoot.isDirectory()) {
            File f = new File(testSuiteRoot, TESTSUITE_HTML);
            if (!f.exists() || f.isDirectory() || !f.canRead()) {
                throw new TestFinder.Fault(i18n, "expand.badRootDir", new Object[]{TESTSUITE_HTML, testSuiteRoot.getPath()});
            }
        } else {
            String name = testSuiteRoot.getName();
            if (!name.equals(TESTSUITE_HTML)) {
                throw new TestFinder.Fault(i18n, "expand.badRootFile");
            }
            testSuiteRoot = new File(testSuiteRoot.getParent());
        }
        super.init(args, testSuiteRoot, env);
    }

    @Override
    protected void foundTestDescription(Map<String, String> entries, File file, int line) {
        String origId = entries.get("id");
        if (origId == null) {
            origId = "";
        }
        HashMap<String, Integer> loopVars = new HashMap<String, Integer>(3);
        this.foundTestDescription_1(entries, file, line, loopVars, origId);
    }

    private void foundTestDescription_1(Map<String, String> entries, File file, int line, Map<String, Integer> loopVars, String id) {
        for (String name : entries.keySet()) {
            String value = entries.get(name);
            if (name.equals("title") || name.equals("test") || name.equals("id")) continue;
            String[] words = StringArray.split(value);
            for (int i = 0; i < words.length; ++i) {
                int j;
                String[] valueList;
                String qualifier;
                String stem;
                int pos;
                if (!words[i].startsWith("$")) continue;
                String varName = words[i].substring(1);
                if (varName.startsWith("{")) {
                    if (!varName.endsWith("}")) {
                        this.error(i18n, "expand.missingCloseCurly", words[i]);
                        continue;
                    }
                    varName = varName.substring(1, varName.length() - 1);
                }
                if ((pos = varName.indexOf(".")) == -1) {
                    stem = varName;
                    qualifier = "";
                } else {
                    stem = varName.substring(0, pos);
                    qualifier = varName.substring(pos + 1);
                }
                if (this.testStems.get(stem) == null || (valueList = this.expandVars.get(varName)) == null) continue;
                String saveId = id;
                Integer idx = loopVars.get(stem);
                if (idx != null) {
                    j = idx;
                    words[i] = valueList[j];
                    id = saveId + "_" + words[i];
                    entries.put("id", id);
                    entries.put(name, StringArray.join(words));
                    continue;
                }
                for (j = 0; j < valueList.length; ++j) {
                    boolean loopy;
                    words[i] = valueList[j];
                    id = saveId + "_" + words[i];
                    entries.put("id", id);
                    entries.put(name, StringArray.join(words));
                    boolean bl = loopy = !qualifier.equals("");
                    if (loopy) {
                        loopVars.put(stem, new Integer(j));
                    }
                    this.foundTestDescription_1(new HashMap<String, String>(entries), file, line, loopVars, id);
                    if (!loopy) continue;
                    loopVars.remove(stem);
                }
                return;
            }
        }
        super.foundTestDescription(new HashMap<String, String>(entries), file, line);
    }

    @Override
    protected void processEntry(Map<String, String> entries, String name, String value) {
        if (name.equals("expand")) {
            if (this.testStems != null) {
                this.error(i18n, "expand.multipleTags");
            }
            this.testStems = new HashMap<String, String>(3);
            String[] stems = StringArray.split(value);
            for (int i = 0; i < stems.length; ++i) {
                this.testStems.put(stems[i], TRUE);
            }
        } else {
            boolean valid;
            boolean bl = valid = this.validEntries.get(name.toLowerCase()) != null;
            if (this.verify) {
                String[] keys;
                if (!valid) {
                    this.error(i18n, "expand.unknownEntry", new Object[]{name, this.getCurrentFile()});
                }
                if (name.equalsIgnoreCase("keywords") && (keys = StringArray.split(value)) != null) {
                    for (int i = 0; i < keys.length; ++i) {
                        String key = keys[i];
                        if (this.validKeywords.size() <= 0 || this.validKeywords.get(key.toLowerCase()) != null) continue;
                        this.error(i18n, "expand.unknownKeyword", new Object[]{key, this.getCurrentFile()});
                    }
                }
            }
            if (valid) {
                entries.put(name, value);
            }
        }
    }
}

