/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;

class TextPane
extends JEditorPane
implements MultiFormatPane.MediaPane {
    private JScrollPane owner;
    private UIFactory uif;
    private HTMLEditorKit htmlKit;
    private DefaultEditorKit defaultKit;
    private RTFEditorKit rtfKit;
    private static HashMap<String, String> extensionsToMIME = new HashMap();

    public TextPane(UIFactory uif, String uiKey, JScrollPane owner) {
        this.uif = uif;
        this.owner = owner;
        this.setName("text");
        this.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setFont(new Font("Monospaced", uif.getBaseFont().getStyle(), uif.getBaseFont().getSize()));
        uif.setAccessibleInfo(this, uiKey);
        this.htmlKit = new HTMLEditorKit();
        this.defaultKit = new DefaultEditorKit();
        this.rtfKit = new RTFEditorKit();
    }

    @Override
    public void changeURL(URL url) {
    }

    @Override
    public void setParent(JScrollPane owner) {
        this.owner = owner;
    }

    @Override
    public int getMode() {
        return 0;
    }

    public void showText(String text, String MIME) {
        this.setContentType(MIME);
        EditorKit kit = this.getKitByMIME(MIME);
        Document doc = kit.createDefaultDocument();
        this.setDocument(doc);
        this.setText(text);
        this.showTextArea();
    }

    public void showText(URL url) {
        try {
            String mimeType = TextPane.getMIMEType(url);
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            boolean loadManually = false;
            if (mimeType.indexOf("plain") != -1) {
                loadManually = true;
            }
            EditorKit kit = this.getKitByMIME(mimeType);
            this.setContentType(mimeType);
            Document doc = kit.createDefaultDocument();
            this.setDocument(doc);
            if (loadManually && "file".equals(url.getProtocol())) {
                File file = new File(url.getFile());
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                    this.read(r, (Object)url);
                    ((Reader)r).close();
                }
                catch (IOException e) {
                    this.uif.showError("mfp.load.error", new Object[]{url, e});
                }
            } else {
                this.setPage(url);
            }
            this.showTextArea();
        }
        catch (IOException e) {
            this.uif.showError("mfp.load.error", new Object[]{url, e});
        }
    }

    public static boolean isTextResource(URL url) {
        String mimeType = TextPane.getMIMEType(url);
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals("text/plain") || mimeType.equals("text/html") || mimeType.equals("text/rtf");
    }

    public static String getMIMEType(URL url) {
        String filename = url.getFile();
        String ext = filename.substring(filename.lastIndexOf(46) + 1);
        ext = ext.toLowerCase();
        return extensionsToMIME.get(ext);
    }

    public void showTextArea() {
        this.owner.setViewportView(this);
        this.owner.revalidate();
        this.owner.repaint();
    }

    private EditorKit getKitByMIME(String mime) {
        if (mime.indexOf("rtf") != -1) {
            return this.rtfKit;
        }
        if (mime.indexOf("html") != -1) {
            return this.htmlKit;
        }
        return this.defaultKit;
    }

    @Override
    public void scrollToReference(String reference) {
        Document d = this.getDocument();
        if (d instanceof HTMLDocument) {
            HTMLDocument doc = (HTMLDocument)d;
            HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
            while (iter.isValid()) {
                AttributeSet a = iter.getAttributes();
                String nm = (String)a.getAttribute(HTML.Attribute.NAME);
                if (nm == null) {
                    nm = (String)a.getAttribute(HTML.Attribute.ID);
                }
                if (nm != null && nm.equals(reference)) {
                    try {
                        int pos = iter.getStartOffset();
                        Rectangle r = this.modelToView(pos);
                        if (r != null) {
                            Rectangle vis = this.getVisibleRect();
                            r.height = vis.height;
                            this.scrollRectToVisible(r);
                            this.setCaretPosition(pos);
                        }
                    }
                    catch (BadLocationException ble) {
                        UIManager.getLookAndFeel().provideErrorFeedback(this);
                    }
                }
                iter.next();
            }
        }
    }

    static {
        extensionsToMIME.put("html", "text/html");
        extensionsToMIME.put("htm", "text/html");
        extensionsToMIME.put("htmls", "text/html");
        extensionsToMIME.put("htx", "text/html");
        extensionsToMIME.put("shtml", "text/html");
        extensionsToMIME.put("stm", "text/html");
        extensionsToMIME.put("jsp", "text/html");
        extensionsToMIME.put("text", "text/plain");
        extensionsToMIME.put("txt", "text/plain");
        extensionsToMIME.put("log", "text/plain");
        extensionsToMIME.put("list", "text/plain");
        extensionsToMIME.put("lst", "text/plain");
        extensionsToMIME.put("java", "text/plain");
        extensionsToMIME.put("xml", "text/plain");
        extensionsToMIME.put("jtr", "text/plain");
        extensionsToMIME.put("jti", "text/plain");
        extensionsToMIME.put("jtm", "text/plain");
        extensionsToMIME.put("jtx", "text/plain");
        extensionsToMIME.put("kfl", "text/plain");
        extensionsToMIME.put("css", "text/plain");
        extensionsToMIME.put("fx", "text/plain");
        extensionsToMIME.put("jasm", "text/plain");
        extensionsToMIME.put("jcod", "text/plain");
        extensionsToMIME.put("rtf", "text/rtf");
        extensionsToMIME.put("rtx", "text/rtf");
    }
}

