/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.PrefsPane;
import com.sun.javatest.exec.QSW_Listener;
import com.sun.javatest.exec.QuickStartWizard;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.WorkDirChooseTool;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.PreferencesPane;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ExecToolManager
extends ToolManager
implements QSW_Listener {
    QuickStartWizard qsw = null;
    private Action openQuickStartAction = new ToolAction(this.i18n, "mgr.openQuickStart"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecToolManager.this.showQSW();
        }
    };
    private Action openTMQSWAction = new ToolAction(this.i18n, "mgr.openTMQSW"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ExecToolManager.this.showQSW();
        }
    };
    private Action openTestSuiteAction = new ToolAction(this.i18n, "mgr.openTestSuite"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TestSuiteChooser tsc = ExecToolManager.this.getTestSuiteChooser();
            int action = tsc.showDialog(ExecToolManager.this.getDesktop().getDialogParent());
            if (action != 0) {
                return;
            }
            ExecToolManager.this.addNewExecTool(tsc.getSelectedTestSuite(), null, null, "tmgr.errorOpenTestSuite");
            tsc.setSelectedTestSuite(null);
        }
    };
    private Action openWorkDirAction = new ToolAction(this.i18n, "mgr.openWorkDir"){

        @Override
        public void actionPerformed(ActionEvent e) {
            WorkDirectory wd = WorkDirChooseTool.chooseWD(ExecToolManager.this.emptyTool, null, null, 1);
            if (wd == null) {
                return;
            }
            ExecToolManager.this.addNewExecTool(wd.getTestSuite(), wd, null, "tmgr.errorOpenWorkDir");
        }
    };
    private Action createWorkDirAction = new ToolAction(this.i18n, "mgr.createWorkDir"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Action act;
            Desktop d = ExecToolManager.this.getDesktop();
            Tool currentTool = d.getSelectedTool();
            if (currentTool == null || !(currentTool instanceof ExecTool)) {
                return;
            }
            TestSuite ts = ((ExecTool)currentTool).getTestSuite();
            ExecTool et = ExecToolManager.this.addNewExecTool(ts, null, null, "tmgr.errorOpenTestSuite");
            if (et != null && (act = et.getCreateWDAction()) != null && act.isEnabled()) {
                act.actionPerformed(e);
            }
        }
    };
    private FileOpener testSuiteOpener = new FileOpener(){

        @Override
        public String getFileType() {
            return "testSuite";
        }

        @Override
        public void open(File f) throws FileNotFoundException, FileOpener.Fault {
            try {
                TestSuite ts = TestSuite.open(f);
                ExecToolManager.this.addNewExecTool(ts, null, null, "tmgr.errorOpenTestSuite");
            }
            catch (TestSuite.Fault e) {
                throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningTestSuite", new Object[]{f, e});
            }
        }
    };
    private FileOpener workDirOpener = new FileOpener(){

        @Override
        public String getFileType() {
            return "workDirectory";
        }

        @Override
        public void open(File f) throws FileNotFoundException, FileOpener.Fault {
            try {
                WorkDirectory wd = WorkDirectory.open(f);
                ExecToolManager.this.addNewExecTool(wd.getTestSuite(), wd, null, "tmgr.errorOpenWorkDir");
            }
            catch (WorkDirectory.Fault e) {
                throw new FileOpener.Fault(ExecToolManager.this.i18n, "mgr.errorOpeningWorkDirectory", new Object[]{f, e.getMessage()});
            }
            Preferences prefs = Preferences.access();
            try {
                prefs.setPreference("wdct.default_wd_path", f.getParentFile().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    private TestSuiteChooser testSuiteChooser;
    private PrefsPane prefsPane;
    private boolean doneQuickStart;
    private boolean doneWDChoser;
    private UIFactory uif;
    private static final String EXEC = "exec";
    private static final File userDir = new File(System.getProperty("user.dir"));
    private final Tool emptyTool;
    private FileOpener[] fileOpeners = new FileOpener[]{this.testSuiteOpener, this.workDirOpener};

    public ExecToolManager(Desktop desktop) {
        super(desktop);
        this.emptyTool = new EmptyTool(this, "empty");
    }

    @Override
    public FileOpener[] getFileOpeners() {
        return this.fileOpeners;
    }

    @Override
    public Action[] getFileMenuActions() {
        if (QuickStartWizard.isQswDisabled()) {
            return new Action[0];
        }
        return new Action[]{this.openQuickStartAction};
    }

    @Override
    public JMenuItem[] getFileMenuPrimaries() {
        JMenuItem[] jMenuItemArray;
        Desktop d = this.getDesktop();
        Tool currentTool = d.getSelectedTool();
        Action createWD = null;
        Action openWD = this.openWorkDirAction;
        if (currentTool != null && currentTool instanceof ExecTool) {
            ExecTool et = (ExecTool)currentTool;
            createWD = et.getCreateWDAction();
            openWD = et.getOpenWDAction();
            if (createWD == null || !createWD.isEnabled()) {
                createWD = this.createWorkDirAction;
            }
            if (openWD == null || !openWD.isEnabled()) {
                openWD = this.openWorkDirAction;
            }
        }
        JMenu openMenu = new JMenu(this.i18n.getString("tmgr.openMenu.menu"));
        openMenu.setName("tmgr.openMenu");
        String keyString = this.i18n.getString("tmgr.openMenu.mne");
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyString);
        openMenu.setMnemonic(keyStroke.getKeyCode());
        openMenu.getAccessibleContext().setAccessibleDescription(this.i18n.getString("tmgr.openMenu.desc"));
        openMenu.add(new JMenuItem(openWD));
        openMenu.add(new JMenuItem(this.openTestSuiteAction));
        if (createWD == null) {
            JMenuItem[] jMenuItemArray2 = new JMenuItem[1];
            jMenuItemArray = jMenuItemArray2;
            jMenuItemArray2[0] = openMenu;
        } else {
            JMenuItem[] jMenuItemArray3 = new JMenuItem[2];
            jMenuItemArray3[0] = new JMenuItem(createWD);
            jMenuItemArray = jMenuItemArray3;
            jMenuItemArray3[1] = openMenu;
        }
        return jMenuItemArray;
    }

    @Override
    public JMenuItem[] getHelpPrimaryMenus() {
        Desktop d = this.getDesktop();
        Tool t = d.getSelectedTool();
        if (t != null && t instanceof ExecTool) {
            ExecTool et = (ExecTool)t;
            ContextManager context = et.getContextManager();
            if (context == null) {
                return null;
            }
            JavaTestMenuManager mm = context.getMenuManager();
            if (mm != null) {
                return mm.getMenuItems(14);
            }
            return null;
        }
        return null;
    }

    @Override
    public JMenuItem[] getHelpTestSuiteMenus() {
        Desktop d = this.getDesktop();
        Tool t = d.getSelectedTool();
        if (t != null && t instanceof ExecTool) {
            ExecTool et = (ExecTool)t;
            ContextManager context = et.getContextManager();
            if (context == null) {
                return null;
            }
            JavaTestMenuManager mm = context.getMenuManager();
            if (mm != null) {
                return mm.getMenuItems(15);
            }
            return null;
        }
        return null;
    }

    @Override
    public JMenuItem[] getHelpAboutMenus() {
        Desktop d = this.getDesktop();
        Tool t = d.getSelectedTool();
        if (t != null && t instanceof ExecTool) {
            ExecTool et = (ExecTool)t;
            ContextManager context = et.getContextManager();
            if (context == null) {
                return null;
            }
            JavaTestMenuManager mm = context.getMenuManager();
            if (mm != null) {
                return mm.getMenuItems(16);
            }
            return null;
        }
        return null;
    }

    @Override
    public Action[] getTaskMenuActions() {
        return null;
    }

    @Override
    public Action[] getWindowOpenMenuActions() {
        if (QuickStartWizard.isQswDisabled()) {
            return new Action[0];
        }
        return new Action[]{this.openTMQSWAction};
    }

    @Override
    public PreferencesPane getPrefsPane() {
        if (this.prefsPane == null) {
            this.prefsPane = new PrefsPane(this.getDesktop().getHelpBroker());
        }
        return this.prefsPane;
    }

    boolean checkOpenNewTool(ExecTool newTool, Desktop d) {
        return this.checkOpenNewTool(d, newTool.getContextManager());
    }

    public boolean checkOpenNewTool(Desktop d, ContextManager conManager) {
        if (conManager != null && conManager.getFeatureManager().isEnabled(4)) {
            Tool[] tools = d.getTools();
            ArrayList<Tool> list = new ArrayList<Tool>();
            for (int i = 0; i < tools.length; ++i) {
                FeatureManager fm;
                ExecTool tool;
                ContextManager cm;
                if (!(tools[i] instanceof ExecTool) || (cm = (tool = (ExecTool)tools[i]).getContextManager()) == null || !(fm = cm.getFeatureManager()).isEnabled(4)) continue;
                list.add(tools[i]);
            }
            if (list.isEmpty()) {
                return true;
            }
            if (list.size() == 1) {
                if (this.showCloseQuestion() == 0) {
                    ExecTool old = (ExecTool)list.get(0);
                    old.getDesktop().removeTool(old);
                    old.dispose();
                    return true;
                }
                return false;
            }
            this.showError("tse.single");
            return false;
        }
        return true;
    }

    @Override
    public Tool startTool() {
        this.showQSW();
        return null;
    }

    public Tool startTool(InterviewParameters p) {
        if (p != null) {
            return this.addNewExecTool(p.getTestSuite(), p.getWorkDirectory(), p, "tmgr.errorOpenConfig");
        }
        return null;
    }

    @Override
    public Tool restoreTool(Map<String, String> m) throws ToolManager.Fault {
        try {
            String tsp = m.get("testSuite");
            TestSuite ts = TestSuite.open(new File(tsp));
            ExecTool et = new ExecTool(this, ts);
            et.restore(m);
            return et;
        }
        catch (Exception e) {
            throw new ToolManager.Fault(this.i18n, "mgr.restoreFaultWD", e.getMessage());
        }
    }

    private static InterviewParameters getInterview(Map<String, String> m) throws Interview.Fault {
        String tsp = m.get("testSuite");
        String wdp = m.get("workDir");
        String cfp = m.get("config");
        if (ExecToolManager.isEmpty(tsp) && ExecToolManager.isEmpty(wdp) && ExecToolManager.isEmpty(cfp)) {
            return null;
        }
        return InterviewParameters.open(tsp, wdp, cfp);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    @Deprecated
    public ExecTool showTestSuite(TestSuite ts) throws Interview.Fault, TestSuite.Fault {
        return this.addNewExecTool(ts, null, null, "tmgr.errorOpenTestSuite");
    }

    private TestSuiteChooser getTestSuiteChooser() {
        if (this.testSuiteChooser == null) {
            this.testSuiteChooser = new TestSuiteChooser();
        }
        return this.testSuiteChooser;
    }

    void addToFileHistory(TestSuite ts) {
    }

    @Deprecated
    public ExecTool showWorkDirectory(WorkDirectory wd) throws Interview.Fault, TestSuite.Fault {
        return this.addNewExecTool(wd.getTestSuite(), wd, null, "tmgr.errorOpenWorkDir");
    }

    void addToFileHistory(WorkDirectory wd) {
        this.getDesktop().addToFileHistory(wd.getRoot(), this.workDirOpener);
    }

    void showError(String key) {
        this.showError(key, null);
    }

    void showError(String key, Object arg) {
        this.showError(key, new Object[]{arg});
    }

    void showError(String key, Object[] args) {
        this.getUIF().showError(key, args);
    }

    int showCloseQuestion() {
        return this.getUIF().showYesNoDialog("tse.closeCurrent");
    }

    UIFactory getUIF() {
        if (this.uif == null) {
            this.uif = new UIFactory(this.getClass(), this.getDesktop().getDialogParent(), this.getDesktop().getHelpBroker());
        }
        return this.uif;
    }

    protected ExecTool addNewExecTool(TestSuite ts, WorkDirectory wd, InterviewParameters ip, String errorKey) {
        ExecTool et;
        Desktop d = this.getDesktop();
        try {
            et = new ExecTool(this, ts);
            if (!this.checkOpenNewTool(et, d)) {
                return null;
            }
            this.addToFileHistory(ts);
            if (wd != null) {
                et.update(wd, ip == null);
                this.addToFileHistory(wd);
            }
            if (wd != null && ip != null) {
                et.update(ip);
            }
        }
        catch (Session.Fault ex) {
            this.showError(errorKey, ex.getMessage());
            return null;
        }
        d.addTool(et);
        d.setSelectedTool(et);
        return et;
    }

    @Override
    public void finishQSW(TestSuite ts, WorkDirectory wd, InterviewParameters ip, boolean showConfigEditorFlag, boolean runTestsFlag) {
        this.qsw = null;
        ExecTool et = this.addNewExecTool(ts, wd, ip, "tmgr.errorOpenWorkDir");
        if (et == null) {
            return;
        }
        if (showConfigEditorFlag) {
            et.showConfigEditor();
        } else if (runTestsFlag) {
            et.runTests();
        }
    }

    @Override
    public void cancelQSW() {
        this.qsw = null;
    }

    public void showQSW() {
        if (this.qsw != null || QuickStartWizard.isQswDisabled()) {
            return;
        }
        this.qsw = new QuickStartWizard(this.emptyTool, this.getDesktop().getLogo(), this, this.getUIF());
        this.qsw.setVisible(true);
    }

    public boolean isQuickStartWizardActive() {
        return this.qsw != null;
    }

    class EmptyTool
    extends Tool {
        EmptyTool(ToolManager m, String uiKey) {
            super(m, uiKey);
        }

        @Override
        public JMenuBar getMenuBar() {
            return new JMenuBar();
        }

        @Override
        protected void save(Map<String, String> m) {
        }

        @Override
        protected void restore(Map<String, String> m) {
        }
    }
}

