/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.BasicSessionControl;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_Control;
import com.sun.javatest.exec.ET_ControlFactory;
import com.sun.javatest.exec.ET_FilterControl;
import com.sun.javatest.exec.ET_FilterHandler;
import com.sun.javatest.exec.ET_HelpControl;
import com.sun.javatest.exec.ET_PrivateControlFactory;
import com.sun.javatest.exec.ET_ReportControl;
import com.sun.javatest.exec.ET_RunTestControl;
import com.sun.javatest.exec.ET_SessionControl;
import com.sun.javatest.exec.ET_TestTreeControl;
import com.sun.javatest.exec.ET_ViewControl;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.HarnessAware;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.SessionExt;
import com.sun.javatest.exec.ToolBarPanel;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ExecTool
extends Tool
implements ExecModel,
BasicSession.OrderedObserver {
    SessionExt session;
    ContextManager context;
    final ExecToolManager etm;
    final TestSuite testSuite;
    final ET_TestTreeControl testTreePanel;
    final ET_SessionControl sessionControl;
    final ET_RunTestControl runTestsHandler;
    final ET_ReportControl reportHandler;
    final ET_FilterHandler filterHandler;
    final List<ET_Control> controls = new ArrayList<ET_Control>();
    JMenuBar menuBar = null;
    private boolean shouldPauseTree;
    private PageFormat pageFormat;
    boolean initialized = false;
    static final String TOOLBAR_PREF = "exec.toolbar";
    static final String FILTER_WARN_PREF = "exec.filterWarn";
    static final String TESTS2RUN_PREF = "exec.tests2runPop";
    static final String ACTIVE_FILTER = "filter";

    public ExecTool(ExecToolManager mgr, TestSuite ts) throws Session.Fault {
        super(mgr, "exec", "browse.window.csh");
        this.testSuite = ts;
        String testSuiteName = this.testSuite.getName();
        if (testSuiteName != null) {
            this.setShortTitle(testSuiteName);
        }
        this.etm = mgr;
        this.context = this.createContextManager();
        ET_ControlFactory controlFactory = this.context.getExecToolControlFactory(this, this.uif);
        ET_PrivateControlFactory prviateFactory = new ET_PrivateControlFactory(this, this.uif, this);
        this.sessionControl = controlFactory.createSessionControl();
        Session s = this.sessionControl.getSession();
        if (!(s instanceof SessionExt)) {
            throw new Error(this.uif.getI18NString("bcc.notSessionExtInstance.err", s.getClass()));
        }
        this.session = (SessionExt)s;
        this.context.setCurrentConfig(this.session);
        this.controls.add(this.sessionControl);
        this.runTestsHandler = prviateFactory.createRunTestControl();
        this.runTestsHandler.setConfig(this.session);
        this.controls.add(this.runTestsHandler);
        this.reportHandler = controlFactory.createReportControl();
        this.controls.add(this.reportHandler);
        ET_FilterControl fControl = controlFactory.createFilterControl();
        if (!(fControl instanceof ET_FilterHandler)) {
            throw new Error(this.uif.getI18NString("et.badFilterControl.err"));
        }
        this.filterHandler = (ET_FilterHandler)fControl;
        this.controls.add(this.filterHandler);
        this.testTreePanel = prviateFactory.createTestTreeControl();
        this.testTreePanel.setFilterSelectionHandler(this.filterHandler.getFilterSelectionHandler());
        this.testTreePanel.setParameters(this.session.getParameters());
        this.runTestsHandler.setTreePanelModel(this.testTreePanel.getTreePanelModel());
        this.controls.add(this.testTreePanel);
        ET_ViewControl viewControl = controlFactory.createViewControl();
        viewControl.setConfig(this.session);
        this.controls.add(viewControl);
        ET_HelpControl helpControl = controlFactory.createHelpControl();
        this.controls.add(helpControl);
        List<ET_Control> customControls = controlFactory.createCustomControls();
        if (customControls != null) {
            this.controls.addAll(customControls);
        }
        Harness harness = this.runTestsHandler.getHarness();
        for (ET_Control c : this.controls) {
            if (c instanceof Session.Observer) {
                this.session.addObserver((Session.Observer)((Object)c));
            }
            if (c instanceof ET_RunTestControl.Observer) {
                this.runTestsHandler.addObserver((ET_RunTestControl.Observer)((Object)c));
            }
            if (!(c instanceof HarnessAware)) continue;
            ((HarnessAware)((Object)c)).setHarness(harness);
        }
        this.session.addObserver(this.context);
        this.session.addObserver(this);
    }

    ContextManager createContextManager() {
        try {
            ContextManager cm = ExecTool.createContextManager(this.testSuite);
            if (cm != null) {
                cm.setTestSuite(this.testSuite);
                if (this.session != null) {
                    cm.setCurrentConfig(this.session);
                }
                cm.setTool(this);
            }
            return cm;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ContextManager createContextManager(TestSuite ts) {
        ContextManager cm = null;
        String cls = null;
        if (ts != null) {
            cls = ts.getTestSuiteInfo("tmcontext");
        }
        try {
            cm = cls == null ? (ContextManager)Class.forName("com.sun.javatest.exec.ContextManager").newInstance() : (ContextManager)Class.forName(cls, true, ts.getClassLoader()).newInstance();
            cm.setTestSuite(ts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cm;
    }

    public UIFactory getUIF() {
        return this.uif;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (!this.initialized) {
            return null;
        }
        if (this.menuBar != null) {
            return this.menuBar;
        }
        this.menuBar = new JMenuBar();
        for (ET_Control c : this.controls) {
            JMenu m = c.getMenu();
            if (m == null) continue;
            this.menuBar.add(m);
        }
        return this.menuBar;
    }

    protected JToolBar getToolBar() {
        ArrayList<Action> v = new ArrayList<Action>();
        for (ET_Control c : this.controls) {
            List<Action> acts = c.getToolBarActionList();
            if (acts == null) continue;
            v.addAll(acts);
            v.add(null);
        }
        Action[] toolBarActions = v.toArray(new Action[v.size()]);
        Preferences p = Preferences.access();
        JToolBar toolBar = this.uif.createToolBar(TOOLBAR_PREF);
        toolBar.setFloatable(false);
        boolean tbVisible = p.getPreference(TOOLBAR_PREF, "true").equals("true");
        toolBar.setVisible(tbVisible);
        toolBar.getMargin().left = 10;
        toolBar.getMargin().right = 10;
        JLabel lab = this.uif.createLabel("exec.filter", false);
        JComponent selector = this.filterHandler.getFilterSelectionHandler().getFilterSelector();
        lab.setMaximumSize(lab.getPreferredSize());
        toolBar.add(lab);
        toolBar.addSeparator();
        toolBar.add(selector);
        toolBar.addSeparator();
        this.uif.addToolBarActions(toolBar, toolBarActions);
        return toolBar;
    }

    @Override
    public void setVisible(boolean f) {
        this.initGUI();
        super.setVisible(f);
    }

    protected void initGUI() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.context != null && "com.sun.javatest.exec.ContextManager".equals(this.context.getClass().getCanonicalName())) {
            this.context = null;
        }
        this.setLayout(new BorderLayout());
        if (this.shouldPauseTree) {
            this.testTreePanel.getTreePanelModel().pauseWork();
        }
        ToolBarPanel toolBarPanel = new ToolBarPanel();
        toolBarPanel.add(this.getToolBar());
        this.add((Component)toolBarPanel, "North");
        this.add((Component)this.testTreePanel.getViewComponent(), "Center");
        JPanel statusStrips = this.uif.createPanel("exec.strips", false);
        statusStrips.setLayout(new BorderLayout());
        statusStrips.add((Component)this.sessionControl.getViewComponent(), "North");
        statusStrips.add((Component)this.runTestsHandler.getViewComponent(), "South");
        this.add((Component)statusStrips, "South");
        this.testTreePanel.initialize();
        this.updateGUI();
    }

    @Override
    protected void save(Map<String, String> m) {
        for (ET_Control c : this.controls) {
            c.save(m);
        }
    }

    @Override
    protected void restore(Map<String, String> m) {
        for (ET_Control c : this.controls) {
            c.restore(m);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.context != null) {
            this.context.dispose();
        }
        for (ET_Control c : this.controls) {
            c.dispose();
        }
    }

    @Override
    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    @Override
    public TestSuite[] getLoadedTestSuites() {
        TestSuite[] testSuiteArray;
        if (this.testSuite == null) {
            testSuiteArray = null;
        } else {
            TestSuite[] testSuiteArray2 = new TestSuite[1];
            testSuiteArray = testSuiteArray2;
            testSuiteArray2[0] = this.testSuite;
        }
        return testSuiteArray;
    }

    @Override
    public WorkDirectory getWorkDirectory() {
        return this.session.getWorkDirectory();
    }

    @Override
    public InterviewParameters getInterviewParameters() {
        return this.session.getInterviewParameters();
    }

    @Override
    public FilterConfig getFilterConfig() {
        return this.filterHandler.getFilterConfig();
    }

    @Override
    public ContextManager getContextManager() {
        if (this.context == null) {
            try {
                this.context = this.createContextManager();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.context;
    }

    @Override
    public TestResultTable getActiveTestResultTable() {
        WorkDirectory workDir = this.getWorkDirectory();
        if (workDir != null) {
            return workDir.getTestResultTable();
        }
        if (this.testTreePanel != null) {
            return this.testTreePanel.getTestResultTable();
        }
        return null;
    }

    Action getCreateWDAction() {
        if (this.sessionControl instanceof BasicSessionControl) {
            return ((BasicSessionControl)this.sessionControl).newWorkDirAction;
        }
        return null;
    }

    Action getOpenWDAction() {
        if (this.sessionControl instanceof BasicSessionControl) {
            return ((BasicSessionControl)this.sessionControl).openWorkDirAction;
        }
        return null;
    }

    void updateGUI() {
        if (!this.initialized) {
            return;
        }
        for (ET_Control c : this.controls) {
            c.updateGUI();
        }
        this.updateTitle();
    }

    public void update(WorkDirectory wd) throws Session.Fault {
        this.session.update(new BasicSession.U_NewWD(wd), true);
    }

    public void update(WorkDirectory wd, boolean updateConfig) throws Session.Fault {
        this.session.update(new BasicSession.U_NewWD(wd), updateConfig);
    }

    public void update(InterviewParameters ip) throws Session.Fault {
        if (this.session.getInterviewParameters().getFile() != null) {
            return;
        }
        this.session.update(new BasicSession.U_NewConfig(ip));
    }

    @Override
    public void updated(Session.Event e) {
        this.updateGUI();
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void showWorkDirDialog(boolean allowTemplates) {
        throw new UnsupportedOperationException("Not supported already.");
    }

    @Override
    public void showConfigEditor(boolean runTests) {
        throw new UnsupportedOperationException("Not supported already.");
    }

    @Override
    public void showTemplateEditor() {
        throw new UnsupportedOperationException("Not supported already.");
    }

    public void showConfigEditor() {
        this.sessionControl.edit();
    }

    public void runTests() {
        this.runTestsHandler.runTests();
    }

    @Override
    public void runTests(String[] urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        this.runTestsHandler.executeImmediate(urls);
    }

    @Override
    public void showMessage(ResourceBundle msgs, String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void printSetup() {
        PageFormat pf = PrinterJob.getPrinterJob().pageDialog(this.pageFormat == null ? PrinterJob.getPrinterJob().defaultPage() : this.pageFormat);
        this.pageFormat = pf == null ? this.pageFormat : pf;
    }

    @Override
    public void print(Printable p) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(p, this.pageFormat == null ? pj.defaultPage() : this.pageFormat);
        boolean result = pj.printDialog();
        if (result) {
            try {
                pj.print();
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setWorkDir(WorkDirectory wd, boolean addToFileHistory) throws Interview.Fault, TestSuite.Fault {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void configure() {
        this.sessionControl.configure();
    }

    @Override
    public boolean isConfiguring() {
        return this.sessionControl.isConfiguring();
    }

    @Override
    public ExecToolManager getExecToolManager() {
        return this.etm;
    }

    public void showQuickStartWizard() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isQuickStartWizardShowing() {
        return false;
    }

    void updateTitle() {
        String workDirPath;
        String testSuiteName = this.testSuite == null ? null : this.testSuite.getName();
        WorkDirectory workDir = this.session.getParameters().getWorkDirectory();
        String string = workDirPath = workDir == null ? null : workDir.getRoot().getPath();
        if (this.testSuite == null) {
            this.setI18NTitle("exec.title.noTS.txt");
        } else if (workDirPath == null) {
            if (testSuiteName == null) {
                this.setI18NTitle("exec.title.noWD.txt");
            } else {
                this.setShortTitle(testSuiteName);
                this.setI18NTitle("exec.title.tsName.txt", testSuiteName);
            }
        } else if (testSuiteName == null) {
            this.setI18NTitle("exec.title.wd.txt", workDirPath);
        } else {
            this.setShortTitle(testSuiteName);
            this.setI18NTitle("exec.title.tsName_wd.txt", new Object[]{testSuiteName, workDirPath});
        }
    }

    void pauseTreeCacheWork() {
        if (this.testTreePanel != null && this.testTreePanel.getTreePanelModel() != null) {
            this.testTreePanel.getTreePanelModel().pauseWork();
        } else {
            this.shouldPauseTree = true;
        }
    }

    void unpauseTreeCacheWork() {
        if (this.testTreePanel != null && this.testTreePanel.getTreePanelModel() != null) {
            this.testTreePanel.getTreePanelModel().refreshTree();
            this.testTreePanel.getTreePanelModel().unpauseWork();
        } else {
            this.shouldPauseTree = false;
        }
    }

    void syncInterview() {
    }

    void loadInterview(File file) {
        if (this.sessionControl instanceof BasicSessionControl) {
            BasicSessionControl bcc = (BasicSessionControl)this.sessionControl;
            if (bcc.session.getWorkDirectory() == null) {
                throw new IllegalStateException();
            }
            bcc.loadInterviewFromFile(bcc.session.getWorkDirectory(), file);
        }
    }

    void saveTreeState(Map<String, String> m) {
        this.testTreePanel.saveTreeState(m);
    }

    void restoreTreeState(Map<String, String> m) {
        this.testTreePanel.restoreTreeState(m);
    }
}

