/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.AllTestsFilter;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.LastRunFilter;
import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.ParameterFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BasicCustomTestFilter;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.ET_FilterControl;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterConfig;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.Session;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ET_FilterHandler
implements ET_FilterControl,
Session.Observer {
    private FilterConfig fConfig;
    private FilterSelectionHandler fHandler;
    private ExecModel model;
    private UIFactory uif;
    private JComponent parentComponent;
    private Map<String, String> map;
    private LastRunFilter ltrFilter;
    private ParameterFilter paramFilter;
    private BasicCustomTestFilter bctf;
    private AllTestsFilter allFilter;
    private TestFilter certFilter;
    protected Vector<TestFilter> allFilters;
    private TestSuite lastTs;
    private static final String FILTER_PREFIX = "exec.vfilters";
    private static final String BTF_PREFIX = "exec.vfilters.btf";
    private static final String META_ID = "meta_tsid";
    private static final String META_NAME = "meta_tsn";
    private static final String META_CLASS = "meta_class";

    ET_FilterHandler(JComponent parent, ExecModel model, Harness h, UIFactory uif, Map<String, String> map) {
        this(parent, model, uif);
        this.setHarness(h);
        this.restore(map);
    }

    protected ET_FilterHandler(JComponent parent, ExecModel model, UIFactory uif) {
        this.uif = uif;
        this.model = model;
        this.parentComponent = parent;
        this.allFilters = new Vector();
    }

    @Override
    public void setHarness(Harness h) {
        h.addObserver(new Watcher());
    }

    FilterConfig loadFilters() {
        if (this.fConfig != null) {
            return this.fConfig;
        }
        this.fConfig = new FilterConfig(this.model, this.parentComponent, this.uif);
        this.fHandler = this.fConfig.createFilterSelectionHandler();
        ObservableTestFilter filter = this.ltrFilter = new LastRunFilter();
        this.allFilters.add(filter);
        this.fConfig.add(filter);
        this.paramFilter = new ParameterFilter();
        filter = this.paramFilter;
        this.allFilters.add(filter);
        this.fConfig.add(filter);
        List<TestFilter> usersFilters = this.getUsersFilters();
        if (usersFilters != null) {
            for (TestFilter tf : usersFilters) {
                this.allFilters.add(tf);
                this.fConfig.add(tf);
            }
        }
        this.allFilter = new AllTestsFilter();
        this.allFilters.add(this.allFilter);
        this.fConfig.add(this.allFilter);
        this.updateCustomFilter();
        this.fHandler.setFilter(this.getDefaultFilter(this.map));
        return this.fConfig;
    }

    protected List<TestFilter> getUsersFilters() {
        return null;
    }

    @Override
    public JMenu getFilterMenu() {
        return this.getFilterSelectionHandler().getFilterMenu();
    }

    FilterSelectionHandler getFilterSelectionHandler() {
        this.loadFilters();
        return this.fHandler;
    }

    private TestFilter getDefaultFilter(Map<String, String> map) {
        if (map != null) {
            String pref = map.get("filter");
            for (int i = 0; i < this.allFilters.size(); ++i) {
                if (!this.allFilters.elementAt(i).getClass().getName().equals(pref)) continue;
                return this.allFilters.elementAt(i);
            }
        }
        return this.allFilter;
    }

    protected void updateFilters() {
        InterviewParameters ips;
        this.loadFilters();
        this.updateCustomFilter();
        if (!this.ltrFilter.isWorkDirectorySet()) {
            this.ltrFilter.setWorkDirectory(this.model.getWorkDirectory());
        }
        if ((ips = this.model.getInterviewParameters()) == null) {
            return;
        }
        this.paramFilter.update(ips);
        TestFilter newCertFilter = ips.getRelevantTestFilter();
        if (newCertFilter == null) {
            if (this.certFilter != null) {
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(this.paramFilter);
                }
                this.fConfig.remove(this.certFilter);
            }
        } else if (!newCertFilter.equals(this.certFilter)) {
            if (newCertFilter == this.certFilter) {
                this.fConfig.notifyUpdated(this.certFilter);
            } else {
                this.fConfig.add(newCertFilter);
                if (this.fHandler.getActiveFilter() == this.certFilter) {
                    this.fHandler.setFilter(newCertFilter);
                }
                this.fConfig.remove(this.certFilter);
                this.certFilter = newCertFilter;
            }
        }
    }

    @Override
    public JMenu getMenu() {
        this.loadFilters();
        return null;
    }

    public FilterConfig getFilterConfig() {
        return this.fConfig;
    }

    @Override
    public void save(Map<String, String> m) {
        Preferences prefs = Preferences.access();
        TestFilter aFilter = this.fHandler.getActiveFilter();
        m.put("filter", aFilter.getClass().getName());
        TestSuite ts = this.model.getTestSuite();
        String tsId = null;
        String tsName = null;
        if (ts != null) {
            tsId = ts.getID();
            tsName = ts.getName();
        }
        int prefIndex = this.getPreferenceIndexForWrite(prefs, tsId);
        ConstrainedPreferenceMap cpm = new ConstrainedPreferenceMap(prefs);
        PrefixMap<String> pm = new PrefixMap<String>(cpm, FILTER_PREFIX + prefIndex);
        if (tsId != null) {
            pm.put(META_ID, tsId);
            pm.put(META_NAME, tsName);
        }
        pm.put(META_CLASS, this.bctf.getClass().getName());
        this.bctf.save(pm);
        prefs.save();
    }

    @Override
    public void restore(Map<String, String> m) {
        this.map = m;
        this.fHandler.setFilter(this.getDefaultFilter(m));
    }

    @Override
    public void updateGUI() {
    }

    @Override
    public List<Action> getToolBarActionList() {
        return null;
    }

    @Override
    public void dispose() {
    }

    private void updateCustomFilter() {
        Preferences prefs;
        int prefIndex;
        if (this.lastTs != null) {
            return;
        }
        this.lastTs = this.model.getTestSuite();
        String tsId = null;
        String tsName = null;
        if (this.lastTs != null) {
            tsId = this.lastTs.getID();
            tsName = this.lastTs.getName();
        }
        if ((prefIndex = this.getPreferenceIndexForRead(prefs = Preferences.access(), tsId)) >= 0) {
            ConstrainedPreferenceMap cpm = new ConstrainedPreferenceMap(prefs);
            PrefixMap<String> pm = new PrefixMap<String>(cpm, FILTER_PREFIX + prefIndex);
            if (this.bctf == null) {
                this.bctf = new BasicCustomTestFilter(pm, this.model, this.uif);
                this.allFilters.add(this.bctf);
                this.fConfig.add(this.bctf);
            } else {
                this.bctf.load(pm);
                this.fHandler.updateFilterMetaInfo(this.bctf);
            }
        } else if (this.bctf == null) {
            this.bctf = new BasicCustomTestFilter(this.model, this.uif);
            this.allFilters.add(this.bctf);
            this.fConfig.add(this.bctf);
        }
    }

    private int getPreferenceIndexForWrite(Preferences p, String tsId) {
        int index = 0;
        int numFilters = this.getPreferenceCount(p);
        if (tsId != null && numFilters != 0) {
            index = this.getPreferenceIndex(p, tsId, numFilters);
            if (index == -1) {
                index = ++numFilters;
                p.setPreference("exec.vfilters.count", Integer.toString(numFilters));
            }
        } else if (tsId != null && numFilters == 0) {
            index = 1;
            numFilters = 1;
            p.setPreference("exec.vfilters.count", Integer.toString(numFilters));
        }
        return index;
    }

    private int getPreferenceIndexForRead(Preferences p, String tsId) {
        int numFilters = this.getPreferenceCount(p);
        int result = -1;
        result = numFilters == 0 ? -1 : this.getPreferenceIndex(p, tsId, numFilters);
        return result;
    }

    private int getPreferenceIndex(Preferences p, String tsId, int numFilters) {
        int index = -1;
        for (int i = 1; i <= numFilters; ++i) {
            String id = p.getPreference(FILTER_PREFIX + i + "." + META_ID);
            if (!id.equals(tsId)) continue;
            index = i;
            break;
        }
        if (index > numFilters) {
            return -1;
        }
        return index;
    }

    private int getPreferenceCount(Preferences p) {
        int numFilters = Integer.parseInt(p.getPreference("exec.vfilters.count", "0"));
        return numFilters;
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewConfig) {
            this.paramFilter.update(((BasicSession.E_NewConfig)ev).ip);
        }
        this.updateFilters();
    }

    class Watcher
    implements Harness.Observer {
        Watcher() {
        }

        @Override
        public void startingTestRun(Parameters params) {
            Preferences p;
            ET_FilterHandler.this.ltrFilter.setLastStartTime(System.currentTimeMillis());
            ET_FilterHandler.this.ltrFilter.clearTestURLs();
            if (ET_FilterHandler.this.fHandler.getActiveFilter() == ET_FilterHandler.this.allFilter && (p = Preferences.access()).getPreference("exec.filterWarn", "true").equals("true")) {
                final JPanel pan = ET_FilterHandler.this.uif.createPanel("notagain", false);
                final JCheckBox cb = ET_FilterHandler.this.uif.createCheckBox("exec.fltr.noShow", false);
                final JTextArea msg = ET_FilterHandler.this.uif.createMessageArea("exec.fltr.note");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pan.setLayout(new BorderLayout());
                        pan.add((Component)cb, "South");
                        pan.add((Component)msg, "Center");
                        JOptionPane pane = new JOptionPane(pan, 1, -1, null, null, null);
                        JDialog dialog = pane.createDialog(ET_FilterHandler.this.parentComponent, ET_FilterHandler.this.uif.getI18NString("exec.fltr.note.title"));
                        dialog.show();
                        Object selectedValue = pane.getValue();
                        if (selectedValue instanceof Integer && (Integer)selectedValue >= 0) {
                            p.setPreference("exec.filterWarn", Boolean.toString(!cb.isSelected()));
                        }
                    }
                });
            }
        }

        @Override
        public void startingTest(TestResult tr) {
            ET_FilterHandler.this.ltrFilter.addTestURL(tr.getTestName());
        }

        @Override
        public void finishedTest(TestResult tr) {
        }

        @Override
        public void stoppingTestRun() {
        }

        @Override
        public void finishedTesting() {
        }

        @Override
        public void finishedTestRun(boolean allOK) {
        }

        @Override
        public void error(String msg) {
        }
    }

    private class FilterWatcher
    implements FilterSelectionHandler.Observer {
        private FilterWatcher() {
        }

        @Override
        public void filterUpdated(TestFilter f) {
        }

        @Override
        public void filterSelected(TestFilter f) {
        }

        @Override
        public void filterAdded(TestFilter f) {
        }

        @Override
        public void filterRemoved(TestFilter f) {
        }
    }

    private static class ConstrainedPreferenceMap
    implements Map<String, String> {
        private Preferences prefs;

        ConstrainedPreferenceMap(Preferences p) {
            this.prefs = p;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String get(Object key) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("key must be a string");
            }
            return this.prefs.getPreference((String)key);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String put(String key, String value) {
            this.prefs.setPreference(key, value);
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> values() {
            throw new UnsupportedOperationException();
        }

        public String get(String key) {
            return this.prefs.getPreference(key);
        }
    }
}

