/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class Map {
    private boolean tracing;
    private PrintStream traceOut;
    private String[] fromValues;
    private String[] toValues;

    public static Map readFile(String name) throws IOException {
        try {
            Class<?> c = Class.forName("java.io.FileReader");
            Constructor<?> m = c.getConstructor(String.class);
            Reader r = (Reader)m.newInstance(name);
            return new Map(r);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("file system not accessible (" + e + ")");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw Map.fileSystemProblem(t);
        }
        catch (IllegalAccessException e) {
            throw Map.fileSystemProblem(e);
        }
        catch (InstantiationException e) {
            throw Map.fileSystemProblem(e);
        }
        catch (NoSuchMethodException e) {
            throw Map.fileSystemProblem(e);
        }
        catch (Error e) {
            throw Map.fileSystemProblem(e);
        }
    }

    public static Map readURL(URL u) throws IOException {
        return new Map(new InputStreamReader(u.openStream(), StandardCharsets.UTF_8.name()));
    }

    public static Map readFileOrURL(String name) throws IOException {
        if (name.length() > 5 && name.substring(0, 5).equalsIgnoreCase("http:")) {
            return Map.readURL(new URL(name));
        }
        return Map.readFile(name);
    }

    private static IOException fileSystemProblem(Throwable t) {
        return new IOException("problem accessing file system: " + t);
    }

    public Map(Reader r) throws IOException {
        String line;
        BufferedReader in = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        Vector<String> from = new Vector<String>();
        Vector<String> to = new Vector<String>();
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
            String[] row = StringArray.split(line);
            if (row.length < 2) {
                throw new IOException("format error in map file, line is: " + line);
            }
            from.addElement(row[0].replaceAll("\\Q\\u0020\\E", " "));
            to.addElement(row[1].replaceAll("\\Q\\u0020\\E", " "));
        }
        in.close();
        this.fromValues = new String[from.size()];
        from.copyInto(this.fromValues);
        this.toValues = new String[to.size()];
        to.copyInto(this.toValues);
    }

    public void map(String[] args) {
        if (this.fromValues == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            for (int j = 0; j < this.fromValues.length; ++j) {
                String f = this.fromValues[j];
                String t = this.toValues[j];
                int index = arg.indexOf(f);
                while (index != -1) {
                    arg = arg.substring(0, index) + t + arg.substring(index + f.length());
                    index = arg.indexOf(f, index + t.length());
                }
            }
            if (this.tracing && arg != args[i]) {
                this.traceOut.println("MAPARG-from: " + args[i]);
                this.traceOut.println("MAPARG-to:   " + arg);
            }
            args[i] = arg;
        }
    }

    public Map(java.util.Map<String, String> map) {
        this.fromValues = new String[map.size()];
        this.toValues = new String[map.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.fromValues[index] = entry.getKey();
            this.toValues[index] = entry.getValue();
            ++index;
        }
    }

    public Enumeration<String[]> enumerate() {
        Vector<String[]> v = new Vector<String[]>(this.fromValues.length);
        for (int i = 0; i < this.fromValues.length; ++i) {
            v.addElement(new String[]{this.fromValues[i], this.toValues[i]});
        }
        return v.elements();
    }

    public void setTracing(boolean state, PrintStream out) {
        this.tracing = state;
        this.traceOut = state ? out : null;
    }
}

