/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;

class Folder
extends Panel
implements ItemSelectable {
    private ItemListener itemListener;
    private Vector<Entry> entries = new Vector();
    private int border;
    private int slant;
    private int tabSpace;
    private int hgap;
    private int vgap;
    private int tabpad;

    public Folder() {
        this(0, 0);
    }

    public Folder(int hgap, int vgap) {
        this(hgap, vgap, 10, 5, 5);
    }

    Folder(int hgap, int vgap, int border, int slant, int tabSpace) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.border = border;
        this.slant = slant;
        this.tabSpace = tabSpace;
        this.tabpad = 10;
        this.setLayout(new CardLayout());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Folder.this.mousePressed(e.getX(), e.getY());
            }
        };
        this.addMouseListener(mouseListener);
    }

    @Override
    public Insets getInsets() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int left_right = this.border + this.hgap;
        int top = this.border + (fm == null ? 0 : fm.getHeight()) + this.tabpad + this.vgap;
        int bottom = this.border + this.vgap;
        return new Insets(top, left_right, bottom, left_right);
    }

    @Override
    public Component add(String name, Component comp) {
        this.entries.addElement(new Entry(comp, name, null, true));
        return super.add(name, comp);
    }

    public Component add(String name, Component comp, Color color) {
        this.entries.addElement(new Entry(comp, name, color, true));
        return super.add(name, comp);
    }

    public Component add(String name, Component comp, Color color, boolean visibleTab) {
        this.entries.addElement(new Entry(comp, name, color, visibleTab));
        return super.add(name, comp);
    }

    public void showTab(String name) {
        this.showTab(name, true);
    }

    public void hideTab(String name) {
        this.showTab(name, false);
    }

    public void showTab(String name, boolean visible) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.name.equals(name)) continue;
            if (e.visibleTab != visible) {
                e.visibleTab = visible;
                this.repaint();
            }
            return;
        }
    }

    public String getNextVisibleTab() {
        int currentIndex = Math.max(0, this.getCurrentIndex());
        for (int i = currentIndex + 1; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.visibleTab) continue;
            return e.name;
        }
        return null;
    }

    public String getPrevVisibleTab() {
        int currentIndex = this.getCurrentIndex();
        for (int i = currentIndex - 1; i >= 0; --i) {
            Entry e = this.entries.elementAt(i);
            if (!e.visibleTab) continue;
            return e.name;
        }
        return null;
    }

    public Component current() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.comp.isVisible()) continue;
            return e.comp;
        }
        return null;
    }

    public void show(Component comp) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (e.comp != comp) continue;
            this.show(e);
            return;
        }
    }

    public void show(String name) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.name.equals(name)) continue;
            this.show(e);
            return;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        Dimension dims = this.getSize();
        FontMetrics fm = g.getFontMetrics();
        int tabHeight = fm.getHeight() + this.tabpad;
        Entry selected = null;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.comp.isVisible()) continue;
            selected = e;
            break;
        }
        if (selected != null) {
            g.setColor(selected.color != null ? selected.color : this.getBackground());
        }
        g.fillRoundRect(this.hgap, tabHeight + this.vgap, dims.width - 2 * this.hgap - 1, dims.height - tabHeight - 2 * this.vgap - 1, this.border, this.border);
        g.setColor(this.getForeground());
        g.drawRoundRect(this.hgap, tabHeight + this.vgap, dims.width - 2 * this.hgap - 1, dims.height - tabHeight - 2 * this.vgap - 1, this.border, this.border);
        int x = this.border + this.hgap;
        int baseLine = tabHeight + this.vgap;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            int tabH = e.visibleTab || e.comp.isVisible() ? tabHeight : tabHeight / 3;
            int w = fm.stringWidth(e.name);
            Polygon tab = new Polygon();
            tab.addPoint(x, baseLine);
            tab.addPoint(x + this.slant, baseLine - tabH);
            tab.addPoint(x + this.slant + w, baseLine - tabH);
            tab.addPoint(x + this.slant + w + this.slant, baseLine);
            if (e.color != null) {
                g.setColor(e.color);
                g.fillPolygon(tab);
            }
            g.setColor(this.getForeground());
            g.drawLine(tab.xpoints[0], tab.ypoints[0], tab.xpoints[1], tab.ypoints[1]);
            g.drawLine(tab.xpoints[1], tab.ypoints[1], tab.xpoints[2], tab.ypoints[2]);
            g.drawLine(tab.xpoints[2], tab.ypoints[2], tab.xpoints[3], tab.ypoints[3]);
            if (e.visibleTab || e.comp.isVisible()) {
                g.drawString(e.name, x + this.slant, baseLine - this.tabpad / 2 - fm.getDescent());
            }
            if (e.comp.isVisible()) {
                g.setColor(e.color != null ? e.color : this.getBackground());
                g.drawLine(tab.xpoints[0], tab.ypoints[0], tab.xpoints[3], tab.ypoints[3]);
            }
            x = tab.xpoints[3] + this.tabSpace;
        }
        super.paint(g);
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    @Override
    public Object[] getSelectedObjects() {
        Entry ce = this.getCurrentEntry();
        if (ce == null) {
            return null;
        }
        return new Object[]{ce.comp};
    }

    int getMinimumWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int w = this.border + 2 * this.hgap + this.tabSpace;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            w += this.slant + (fm == null ? 0 : fm.stringWidth(e.name)) + this.slant + this.tabSpace;
        }
        return w;
    }

    private void show(Entry e) {
        Entry prevEntry = this.getCurrentEntry();
        Component prevComp = prevEntry == null ? null : prevEntry.comp;
        ((CardLayout)this.getLayout()).show(this, e.name);
        this.repaint();
        if (this.itemListener != null) {
            ItemEvent ev1 = new ItemEvent(this, 701, prevComp, 2);
            ItemEvent ev2 = new ItemEvent(this, 701, e.comp, 1);
            this.itemListener.itemStateChanged(ev1);
            this.itemListener.itemStateChanged(ev2);
        }
    }

    private int getCurrentIndex() {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry e = this.entries.elementAt(i);
            if (!e.comp.isVisible()) continue;
            return i;
        }
        return -1;
    }

    private Entry getCurrentEntry() {
        int i = this.getCurrentIndex();
        return i == -1 ? null : this.entries.elementAt(i);
    }

    void mousePressed(int mouseX, int mouseY) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (this.vgap < mouseY && mouseY < this.border + fm.getHeight() + this.vgap) {
            int x = this.border + this.hgap;
            for (int i = 0; i < this.entries.size(); ++i) {
                Entry e = this.entries.elementAt(i);
                int w = fm.stringWidth(e.name);
                if (mouseX >= (x += this.slant + w + this.slant + this.tabSpace)) continue;
                this.show(e);
                break;
            }
        }
    }

    private class Layout
    extends CardLayout {
        private Layout() {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension size = super.minimumLayoutSize(parent);
            int width = Math.max(size.width, ((Folder)parent).getMinimumWidth());
            return new Dimension(width, size.height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = super.preferredLayoutSize(parent);
            int width = Math.max(size.width, ((Folder)parent).getMinimumWidth());
            return new Dimension(width, size.height);
        }
    }

    private class Entry {
        Component comp;
        String name;
        Color color;
        boolean visibleTab;

        Entry(Component comp, String name, Color color, boolean visibleTab) {
            this.comp = comp;
            this.name = name;
            this.color = color;
            this.visibleTab = visibleTab;
        }
    }
}

