/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

class TRT_Iterator
implements TestResultTable.TreeIterator {
    private String[] initialTests;
    private final Object outQueueLock = new Object();
    private LinkedList<TestResult> outQueue;
    private TestResultTable.TreeNode[] nodes;
    private int nodeIndex = -1;
    private TestFilter[] filters;
    private int[] resultStats;
    private int absoluteCount;
    private int rejectCount;
    private boolean recordRejects;
    private HashMap<TestFilter, ArrayList<TestDescription>> filteredTRs;
    private TestResult currentResult;
    private Object rejLock;
    private FilterObserver fo;
    final Preferences p = Preferences.access();
    boolean recordRejectTR = this.p.getPreference("exec.recordNotrunReasons", "false").equals("true");
    private Stack<PseudoFrame> stack;
    private PseudoFrame currFrame = null;
    private boolean finished = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(TRT_Iterator.class);
    protected boolean debug = Debug.getBoolean(TRT_Iterator.class);

    protected TRT_Iterator() {
        this.outQueue = new LinkedList();
        this.resultStats = new int[4];
        this.setRecordRejects(true);
    }

    TRT_Iterator(TestResultTable.TreeNode node) {
        this();
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = node;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator without filters, one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode node, TestFilter[] filters) {
        this();
        this.filters = filters;
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = node;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] nodes, TestFilter[] filters) {
        this();
        this.filters = filters;
        if (nodes != null) {
            this.nodes = new TestResultTable.TreeNode[nodes.length];
            System.arraycopy(nodes, 0, this.nodes, 0, nodes.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and initial nodes.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] nodes, TestResult[] trs, TestFilter[] filters) {
        this();
        this.filters = filters;
        if (trs != null && trs.length != 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < trs.length; ++i) {
                try {
                    if (this.wouldAccept(trs[i]) != -1) continue;
                    this.outQueue.addLast(trs[i]);
                    names.add(trs[i].getDescription().getRootRelativeURL());
                    continue;
                }
                catch (TestResult.Fault fault) {
                    // empty catch block
                }
            }
            this.initialTests = new String[names.size()];
            names.toArray(this.initialTests);
        }
        if (nodes != null) {
            this.nodes = new TestResultTable.TreeNode[nodes.length];
            System.arraycopy(nodes, 0, this.nodes, 0, nodes.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters, nodes and initial TR set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        Object object = this.outQueueLock;
        synchronized (object) {
            return !this.finished;
            {
            }
        }
    }

    @Override
    public TestResult nextElement() {
        TestResult val = null;
        Object object = this.outQueueLock;
        synchronized (object) {
            if (this.hasMoreElements()) {
                val = this.outQueue.removeFirst();
                this.findNext();
                int n = val.getStatus().getType();
                this.resultStats[n] = this.resultStats[n] + 1;
                return val;
            }
            throw new NoSuchElementException(i18n.getString("trt.noElements"));
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreElements();
    }

    @Override
    public TestResult next() {
        return this.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from TestResultTable through iterator.  Do not call this method.");
    }

    public int getProcessedCount() {
        return this.absoluteCount;
    }

    @Override
    public int getRejectCount() {
        return this.rejectCount;
    }

    @Override
    public void setRecordRejects(boolean state) {
        this.recordRejects = state;
        if (this.recordRejects) {
            if (this.filteredTRs == null) {
                this.filteredTRs = new HashMap(10);
            }
            if (this.fo == null) {
                this.fo = new FilterObserver();
            }
            if (this.rejLock == null) {
                this.rejLock = new Object();
            }
        }
    }

    @Override
    public int[] getResultStats() {
        int[] copy = new int[this.resultStats.length];
        System.arraycopy(this.resultStats, 0, copy, 0, this.resultStats.length);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<TestFilter, ArrayList<TestDescription>> getFilterStats() {
        if (this.filteredTRs == null) {
            return null;
        }
        HashMap<TestFilter, ArrayList<TestDescription>> out = new HashMap<TestFilter, ArrayList<TestDescription>>(this.filteredTRs.size());
        Object object = this.rejLock;
        synchronized (object) {
            Set<TestFilter> keys = this.filteredTRs.keySet();
            for (TestFilter thisKey : keys) {
                ArrayList al = new ArrayList(this.filteredTRs.get(thisKey));
                out.put(thisKey, al);
            }
        }
        return out;
    }

    @Override
    public TestFilter[] getFilters() {
        if (this.filters == null || this.filters.length == 0) {
            return null;
        }
        TestFilter[] copy = new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        return copy;
    }

    @Override
    public String[] getInitialURLs() {
        int i;
        String[] list = null;
        ArrayList<String> urls = new ArrayList<String>();
        if (this.nodes != null) {
            for (i = 0; i < this.nodes.length; ++i) {
                urls.add(TestResultTable.getRootRelativePath(this.nodes[i]));
            }
        }
        if (this.initialTests != null) {
            for (i = 0; i < this.initialTests.length; ++i) {
                urls.add(this.initialTests[i]);
            }
        }
        if (urls.size() > 0) {
            list = new String[urls.size()];
            urls.toArray(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object peek() {
        if (this.hasNext()) {
            Object object = this.outQueueLock;
            synchronized (object) {
                return this.outQueue.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPending(TestResult node) {
        boolean result;
        block31: {
            int pos;
            String dir;
            TRT_TreeNode tn;
            String partial;
            String testName;
            block32: {
                if (!this.hasMoreElements()) {
                    return false;
                }
                partial = testName = node.getTestName();
                Object object = this.outQueueLock;
                synchronized (object) {
                    if (this.outQueue.size() > 0) {
                        for (int i = 0; i < this.outQueue.size(); ++i) {
                            TestResult tr = this.outQueue.get(i);
                            if (!tr.getTestName().equals(testName)) continue;
                            return true;
                        }
                    }
                }
                result = false;
                boolean done = false;
                if (this.nodes == null) break block31;
                block12: for (int i = this.nodeIndex; i < this.nodes.length; ++i) {
                    String nodePath = TestResultTable.getRootRelativePath(this.nodes[i]);
                    if (!testName.startsWith(nodePath)) continue;
                    if (i > this.nodeIndex) {
                        result = true;
                        done = true;
                        break;
                    }
                    if (i < this.nodeIndex) {
                        result = false;
                        done = true;
                        break;
                    }
                    if (nodePath.length() != 0) {
                        partial = testName.substring(nodePath.length() + 1);
                    }
                    for (int j = 0; j < this.stack.size(); ++j) {
                        String dir2 = TestResultTable.getDirName(partial);
                        partial = TestResultTable.behead(partial);
                        PseudoFrame frame = (PseudoFrame)this.stack.elementAt(j);
                        TRT_TreeNode tn2 = (TRT_TreeNode)frame.getNode();
                        int pos2 = tn2.getNodeIndex(dir2, false);
                        int currIndex = frame.getCurrentIndex();
                        if (testName.indexOf("/") == -1) {
                            pos2 = currIndex;
                        }
                        if (pos2 == -1 || pos2 < currIndex) {
                            result = false;
                            done = true;
                            continue block12;
                        }
                        if (pos2 == frame.getCurrentIndex()) {
                            if (partial.indexOf(47) != -1) continue;
                            if (j + 1 == this.stack.size()) {
                                done = false;
                                continue block12;
                            }
                            switch (TRT_Iterator.checkTestPosition(frame, testName)) {
                                case -1: 
                                case 0: {
                                    result = false;
                                    done = true;
                                    continue block12;
                                }
                                case 2: {
                                    result = true;
                                    done = true;
                                    continue block12;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        result = true;
                        done = true;
                        continue block12;
                    }
                }
                if (done) break block31;
                tn = (TRT_TreeNode)this.currFrame.getNode();
                dir = TestResultTable.getDirName(partial);
                if ((partial = TestResultTable.behead(partial)).indexOf("/") != -1) break block32;
                switch (TRT_Iterator.checkTestPosition(this.currFrame, testName)) {
                    case -1: 
                    case 0: {
                        result = false;
                        break block31;
                    }
                    case 2: {
                        result = true;
                        break block31;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (!dir.equals(this.currFrame.getNode().getName())) {
                result = false;
                dir = TestResultTable.getDirName(partial);
                tn = (TRT_TreeNode)this.currFrame.getNode();
                pos = tn.getNodeIndex(dir, false);
                int currIndex = this.currFrame.getCurrentIndex();
                if (pos == -1) {
                    result = false;
                } else if (pos < currIndex) {
                    result = false;
                } else {
                    if (pos == currIndex) {
                        throw new IllegalStateException("");
                    }
                    result = true;
                }
            } else {
                pos = tn.getTestIndex(testName);
                if (pos == -1) {
                    result = false;
                }
                result = pos > this.currFrame.getCurrentIndex();
            }
        }
        return result;
    }

    private void init(TestResultTable.TreeNode[] nodes) {
        this.nodes = nodes != null && nodes.length == 0 ? null : nodes;
        boolean hasNodes = this.nextNode();
        if (hasNodes) {
            this.findNext();
        } else if (this.outQueue.size() == 0) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findNext() {
        boolean done = false;
        if (this.finished) {
            return;
        }
        while (!done) {
            TestResult test;
            block21: {
                if (this.currFrame == null) {
                    Object object = this.outQueueLock;
                    synchronized (object) {
                        if (this.outQueue.size() == 0) {
                            this.finished = true;
                        }
                    }
                    return;
                }
                int nextIndex = this.currFrame.nextIndex();
                if (nextIndex == -1) {
                    this.nextFrame();
                    continue;
                }
                Object anonNode = this.currFrame.getNode().getChild(nextIndex);
                if (anonNode == null) {
                    this.nextFrame();
                    continue;
                }
                if (anonNode instanceof TestResultTable.TreeNode) {
                    TestResultTable.TreeNode node = (TestResultTable.TreeNode)anonNode;
                    this.push(this.currFrame);
                    this.currFrame = new PseudoFrame(node);
                    continue;
                }
                test = (TestResult)anonNode;
                try {
                    int would = this.wouldAccept(test);
                    if (would >= 0) {
                    }
                    break block21;
                }
                catch (TestResult.Fault f) {
                    TestResultTable trt = null;
                    if (this.nodes != null && this.nodes[0] != null) {
                        trt = this.nodes[0].getEnclosingTable();
                    } else {
                        if (test.getParent() == null) continue;
                        trt = test.getParent().getEnclosingTable();
                    }
                    if (trt == null) continue;
                    test = trt.resetTest(test);
                    try {
                        if (this.wouldAccept(test) >= 0) {
                            continue;
                        }
                        break block21;
                    }
                    catch (TestResult.Fault f2) {
                        if (!this.debug) continue;
                        f2.printStackTrace(Debug.getWriter());
                    }
                }
                continue;
            }
            Object object = this.outQueueLock;
            synchronized (object) {
                this.outQueue.addLast(test);
            }
            done = true;
        }
    }

    private boolean isTop(TestResultTable.TreeNode where) {
        return where.isRoot() || this.nodes[this.nodeIndex] == where;
    }

    private boolean nextNode() {
        this.stack = new Stack();
        this.currFrame = null;
        if (this.nodes != null && ++this.nodeIndex < this.nodes.length) {
            TestResultTable.TreeNode next = this.nodes[this.nodeIndex];
            this.currFrame = new PseudoFrame(next);
            return true;
        }
        return false;
    }

    private void push(PseudoFrame frame) {
        this.stack.push(frame);
    }

    private PseudoFrame pop() {
        if (!this.stack.empty()) {
            return this.stack.pop();
        }
        return null;
    }

    private void nextFrame() {
        this.currFrame = this.pop();
        if (this.currFrame == null) {
            this.nextNode();
        }
    }

    private int wouldAccept(TestResult tr) throws TestResult.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return -1;
        }
        if (this.debug) {
            Debug.println("Iterator checking filter for: " + tr.getWorkRelativePath());
        }
        ++this.absoluteCount;
        this.currentResult = tr;
        TestDescription td = tr.getDescription();
        for (int i = 0; i < this.filters.length; ++i) {
            boolean accepted;
            block7: {
                accepted = true;
                try {
                    accepted = this.fo == null ? this.filters[i].accepts(td) : this.filters[i].accepts(td, (TestFilter.Observer)this.fo);
                }
                catch (TestFilter.Fault f) {
                    accepted = true;
                    if (!this.debug) break block7;
                    Debug.println("   -> exception while checking filter: " + f.getMessage());
                }
            }
            if (accepted) continue;
            if (this.debug) {
                Debug.println("   -> Rejected by: " + this.filters[i]);
                Debug.println("   -> Test Status: " + tr.getStatus().getType());
            }
            ++this.rejectCount;
            if (this.recordRejectTR && tr.getStatus().isNotRun()) {
                ArrayList<TestFilter> rejectors = TRT_Iterator.getFullFilteredList(this.filters, td);
                Status newstatus = Status.notRun(TRT_Iterator.generateFilteredStatus(rejectors));
                TestResult newone = new TestResult(td, newstatus);
                tr.getParent().getEnclosingTable().update(newone, true);
            }
            return i;
        }
        return -1;
    }

    private static int checkTestPosition(PseudoFrame frame, String testName) {
        TRT_TreeNode tn = (TRT_TreeNode)frame.getNode();
        int targetIndex = tn.getTestIndex(testName);
        int currIndex = frame.getCurrentIndex();
        int result = 3;
        result = targetIndex == -1 ? -1 : (targetIndex < currIndex ? 0 : (targetIndex == currIndex ? 1 : (targetIndex > currIndex ? 2 : 3)));
        return result;
    }

    private static ArrayList<TestFilter> getFullFilteredList(TestFilter[] filters, TestDescription td) {
        if (td == null || filters == null || filters.length == 0) {
            return null;
        }
        final ArrayList<TestFilter> out = new ArrayList<TestFilter>();
        TestFilter.Observer foo = new TestFilter.Observer(){

            @Override
            public void rejected(TestDescription td, TestFilter f) {
                out.add(f);
            }
        };
        for (TestFilter f : filters) {
            try {
                if (out.contains(f)) continue;
                f.accepts(td, foo);
            }
            catch (TestFilter.Fault fault) {
                out.add(f);
            }
        }
        return out;
    }

    private static String generateFilteredStatus(ArrayList<TestFilter> fs) {
        StringBuilder sb = new StringBuilder();
        if (fs == null || fs.size() == 0) {
            sb.append("Rejected by test filters.");
        } else {
            sb.append("Rejected by test filters: ");
            for (TestFilter f : fs) {
                sb.append(f.getName());
                sb.append(", ");
            }
        }
        if (sb.length() > 2) {
            return sb.substring(0, sb.length() - 2);
        }
        return "";
    }

    private class FilterObserver
    implements TestFilter.Observer {
        private FilterObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rejected(TestDescription d, TestFilter rejector) {
            Object object = TRT_Iterator.this.rejLock;
            synchronized (object) {
                ArrayList<TestDescription> vec = (ArrayList<TestDescription>)TRT_Iterator.this.filteredTRs.get(rejector);
                if (vec == null) {
                    vec = new ArrayList<TestDescription>();
                    TRT_Iterator.this.filteredTRs.put(rejector, vec);
                }
                try {
                    if (TRT_Iterator.this.currentResult.getDescription() != d) {
                        throw new JavaTestError("TRT_Iterator observered TR.TD does not match filtered one.");
                    }
                }
                catch (TestResult.Fault f) {
                    throw new JavaTestError("TRT_Iterator cannot determine TR source info.", f);
                }
                vec.add(d);
            }
        }
    }

    private static class PseudoFrame {
        private int currIndex;
        private TestResultTable.TreeNode node;

        PseudoFrame(TestResultTable.TreeNode node) {
            this.node = node;
            this.currIndex = -1;
        }

        int nextIndex() {
            if (++this.currIndex < this.node.getChildCount()) {
                return this.currIndex;
            }
            return -1;
        }

        TestResultTable.TreeNode getNode() {
            return this.node;
        }

        int getCurrentIndex() {
            return this.currIndex;
        }
    }
}

