/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ResourceTable {
    private Map<String, Thread> table;

    public ResourceTable() {
        this.table = new HashMap<String, Thread>();
    }

    public ResourceTable(int initialSize) {
        this.table = new HashMap<String, Thread>(initialSize);
    }

    public synchronized boolean acquire(String[] resourceNames, int timeout) throws InterruptedException {
        long start;
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout required");
        }
        if (resourceNames.length > 1) {
            TreeSet<String> ts = new TreeSet<String>();
            ts.addAll(Arrays.asList(resourceNames));
            String[] s = new String[ts.size()];
            ts.toArray(s);
            resourceNames = s;
        }
        long now = start = System.currentTimeMillis();
        try {
            for (int i = 0; i < resourceNames.length; ++i) {
                String resourceName = resourceNames[i];
                Thread owner = null;
                while ((owner = this.table.get(resourceName)) != null) {
                    long remain = start + (long)timeout - now;
                    if (remain < 0L) {
                        this.release(resourceNames);
                        return false;
                    }
                    this.wait(remain);
                    now = System.currentTimeMillis();
                }
                this.table.put(resourceName, Thread.currentThread());
            }
            return true;
        }
        catch (InterruptedException e) {
            this.release(resourceNames);
            throw e;
        }
    }

    public synchronized void release(String[] resourceNames) {
        for (int i = 0; i < resourceNames.length; ++i) {
            Thread owner = this.table.get(resourceNames[i]);
            if (owner != Thread.currentThread()) continue;
            this.table.remove(resourceNames[i]);
        }
        this.notifyAll();
    }
}

