/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class ExcludeList {
    private Map<Key, Object> table = new HashMap<Key, Object>();
    private String title;
    private boolean strict;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ExcludeList.class);
    public static final String EXCLUDEFILE_EXTN = ".jtx";
    private static boolean caseSensitive = Boolean.getBoolean("javatest.caseSensitiveJtx");

    public static boolean isExcludeFile(File f) {
        return f.getPath().endsWith(EXCLUDEFILE_EXTN);
    }

    public ExcludeList() {
    }

    public ExcludeList(File f) throws FileNotFoundException, IOException, Fault {
        this(f, false);
    }

    public ExcludeList(File f, boolean strict) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(strict);
        if (f != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));){
                Entry e;
                Parser p = new Parser(in);
                while ((e = p.readEntry()) != null) {
                    this.addEntry(e);
                }
                this.title = p.getTitle();
            }
        }
    }

    public ExcludeList(File[] files) throws FileNotFoundException, IOException, Fault {
        this(files, false);
    }

    public ExcludeList(File[] files, boolean strict) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(strict);
        for (File file : files) {
            ExcludeList et = new ExcludeList(file, strict);
            this.merge(et);
        }
    }

    public void setStrictModeEnabled(boolean on) {
        this.strict = on;
    }

    public boolean isStrictModeEnabled() {
        return this.strict;
    }

    public boolean excludesAllOf(TestDescription td) {
        return this.excludesAllOf(td.getRootRelativeURL());
    }

    public boolean excludesAllOf(String url) {
        Object o = this.table.get(new Key(url));
        return o != null && o instanceof Entry && ((Entry)o).testCase == null;
    }

    public boolean excludesAnyOf(TestDescription td) {
        return this.excludesAnyOf(td.getRootRelativeURL());
    }

    public boolean excludesAnyOf(String url) {
        Object o = this.table.get(new Key(url));
        return o != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestCases(TestDescription td) {
        Key key = new Key(td.getRootRelativeURL());
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Object o = this.table.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                if (e.testCase == null) {
                    return null;
                }
                return new String[]{e.testCase};
            }
            Entry[] ee = (Entry[])o;
            String[] testCases = new String[ee.length];
            for (int i = 0; i < ee.length; ++i) {
                testCases[i] = ee[i].testCase;
            }
            return testCases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Entry e) throws Fault {
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Key key = new Key(e.relativeURL);
            Object o = this.table.get(key);
            if (o == null) {
                this.table.put(key, e);
            } else if (o instanceof Entry) {
                Entry curr = (Entry)o;
                if (curr.testCase == null) {
                    if (e.testCase == null) {
                        this.table.put(key, e);
                    } else if (this.strict) {
                        throw new Fault(i18n, "excl.cantExcludeCase", e.relativeURL);
                    }
                } else if (e.testCase == null) {
                    if (this.strict) {
                        throw new Fault(i18n, "excl.cantExcludeTest", e.relativeURL);
                    }
                    this.table.put(key, e);
                } else if (curr.testCase.equals(e.testCase)) {
                    this.table.put(key, e);
                } else {
                    this.table.put(key, new Entry[]{curr, e});
                }
            } else if (e.testCase == null) {
                if (this.strict) {
                    throw new Fault(i18n, "excl.cantExcludeTest", e.relativeURL);
                }
                this.table.put(key, e);
            } else {
                Entry[] curr = (Entry[])o;
                for (int i = 0; i < curr.length; ++i) {
                    if (!curr[i].testCase.equals(e.testCase)) continue;
                    curr[i] = e;
                    return;
                }
                this.table.put(key, DynamicArray.append(curr, e));
            }
        }
    }

    public Entry getEntry(String url) {
        int i;
        String testCase = null;
        if (url.endsWith("]") && (i = url.lastIndexOf("[")) != -1) {
            testCase = url.substring(i + 1, url.length() - 1);
            url = url.substring(0, i);
        }
        return this.getEntry(url, testCase);
    }

    public Entry getEntry(String url, String testCase) {
        Entry[] entries;
        Key key = new Key(url);
        Object o = this.table.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Entry) {
            Entry e = (Entry)o;
            if (testCase == null) {
                return e;
            }
            return ExcludeList.isInList(e.testCase, testCase) ? e : null;
        }
        for (Entry e : entries = (Entry[])o) {
            if (!ExcludeList.isInList(e.testCase, testCase)) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ExcludeList other) {
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Iterator<?> iter = other.getIterator(false);
            while (iter.hasNext()) {
                Entry otherEntry = (Entry)iter.next();
                Key key = new Key(otherEntry.relativeURL);
                Object o = this.table.get(key);
                if (o == null) {
                    this.table.put(key, otherEntry);
                    continue;
                }
                if (o instanceof Entry) {
                    Entry curr = (Entry)o;
                    if (curr.testCase == null || otherEntry.testCase == null) {
                        this.table.put(key, new Entry(curr.relativeURL, null, ExcludeList.mergeBugIds(curr.bugIdStrings, otherEntry.bugIdStrings), ExcludeList.mergePlatforms(curr.platforms, otherEntry.platforms), ExcludeList.mergeSynopsis(curr.synopsis, otherEntry.synopsis)));
                        continue;
                    }
                    this.table.put(key, new Entry[]{curr, otherEntry});
                    continue;
                }
                if (otherEntry.testCase == null) {
                    String[] bugIdStrings = otherEntry.bugIdStrings;
                    String[] platforms = otherEntry.platforms;
                    String synopsis = otherEntry.synopsis;
                    for (Entry entry : (Entry[])o) {
                        bugIdStrings = ExcludeList.mergeBugIds(bugIdStrings, entry.bugIdStrings);
                        platforms = ExcludeList.mergePlatforms(platforms, entry.platforms);
                        synopsis = ExcludeList.mergeSynopsis(synopsis, entry.synopsis);
                    }
                    this.table.put(key, new Entry(otherEntry.relativeURL, null, bugIdStrings, platforms, synopsis));
                    continue;
                }
                this.table.put(key, DynamicArray.append((Entry[])o, otherEntry));
            }
        }
    }

    static String[] mergeBugIds(String[] a, String[] b) {
        return ExcludeList.merge(a, b);
    }

    static String[] mergePlatforms(String[] a, String[] b) {
        return ExcludeList.merge(a, b);
    }

    static String[] merge(String[] a, String[] b) {
        TreeSet<String> s = new TreeSet<String>();
        s.addAll(Arrays.asList(a));
        s.addAll(Arrays.asList(b));
        return s.toArray(new String[s.size()]);
    }

    static String mergeSynopsis(String a, String b) {
        if (a == null || a.trim().length() == 0) {
            return b;
        }
        if (b == null || b.trim().length() == 0) {
            return a;
        }
        if (a.indexOf(b) != -1) {
            return a;
        }
        if (b.indexOf(a) != -1) {
            return b;
        }
        return a + "; " + b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Entry e) {
        Map<Key, Object> map = this.table;
        synchronized (map) {
            Key key = new Key(e.relativeURL);
            Object o = this.table.get(key);
            if (o == null) {
                return;
            }
            if (o instanceof Entry) {
                if (o == e) {
                    this.table.remove(key);
                }
            } else {
                Entry[] o2 = DynamicArray.remove((Entry[])o, e);
                if (o2 == o) {
                    return;
                }
                if (o2.length == 1) {
                    this.table.put(key, o2[0]);
                } else {
                    this.table.put(key, o2);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        int n = 0;
        for (Object o : this.table.values()) {
            if (o instanceof Entry[]) {
                n += ((Entry[])o).length;
                continue;
            }
            ++n;
        }
        return n;
    }

    public Iterator<?> getIterator(boolean group) {
        if (group) {
            return this.table.values().iterator();
        }
        Vector<Object> v = new Vector<Object>(this.table.size());
        for (Object o : this.table.values()) {
            if (o instanceof Entry) {
                v.addElement(o);
                continue;
            }
            for (Entry entry : (Entry[])o) {
                v.addElement(entry);
            }
        }
        return v.iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void write(File f) throws IOException {
        int maxURLWidth = 0;
        int maxBugIdWidth = 0;
        int maxPlatformWidth = 0;
        TreeSet<Entry> entries = new TreeSet<Entry>();
        Iterator<?> iter = this.getIterator(false);
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            entries.add(entry);
            maxURLWidth = entry.testCase == null ? Math.max(entry.relativeURL.length(), maxURLWidth) : Math.max(entry.relativeURL.length() + entry.testCase.length() + 2, maxURLWidth);
            maxBugIdWidth = Math.max(this.bugIdsToString(entry).length(), maxBugIdWidth);
            maxPlatformWidth = Math.max(this.platformsToString(entry).length(), maxPlatformWidth);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8));
        out.write("# Exclude List");
        out.newLine();
        out.write("# SCCS %W% %E%");
        out.newLine();
        if (this.title != null) {
            out.write("### title " + this.title);
            out.newLine();
        }
        for (Entry e : entries) {
            if (e.testCase == null) {
                this.write(out, e.relativeURL, maxURLWidth + 2);
            } else {
                this.write(out, e.relativeURL + "[" + e.testCase + "]", maxURLWidth + 2);
            }
            this.write(out, this.bugIdsToString(e), maxBugIdWidth + 2);
            this.write(out, this.platformsToString(e), maxPlatformWidth + 2);
            out.write(e.synopsis);
            out.newLine();
        }
        out.close();
    }

    private void write(Writer out, String s, int width) throws IOException {
        out.write(s);
        for (int i = s.length(); i < width; ++i) {
            out.write(32);
        }
    }

    private String bugIdsToString(Entry e) {
        StringBuffer sb = new StringBuffer(e.bugIdStrings.length * 10);
        sb.append(e.bugIdStrings[0]);
        for (int i = 1; i < e.bugIdStrings.length; ++i) {
            sb.append(',');
            sb.append(e.bugIdStrings[i]);
        }
        return sb.toString();
    }

    private String platformsToString(Entry e) {
        StringBuffer sb = new StringBuffer(e.platforms.length * 10);
        sb.append(e.platforms[0]);
        for (int i = 1; i < e.platforms.length; ++i) {
            sb.append(',');
            sb.append(e.platforms[i]);
        }
        return sb.toString();
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    private static boolean isInList(String list, String val) {
        if (list == null || val == null) {
            return false;
        }
        int pos = list.indexOf(val);
        while (pos != -1) {
            if (!(pos != 0 && list.charAt(pos - 1) != ',' || pos + val.length() != list.length() && list.charAt(pos + val.length()) != ',')) {
                return true;
            }
            pos = list.indexOf(val, pos + 1);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcludeList other = (ExcludeList)obj;
        return this.table == other.table || this.table != null && this.table.equals(other.table);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.table != null ? this.table.hashCode() : 0);
        return hash;
    }

    public static final class Entry
    implements Comparable<Entry> {
        private String relativeURL;
        private String testCase;
        private String[] bugIdStrings;
        private int[] bugIds;
        private String[] platforms;
        private String synopsis;

        public Entry(String u, String tc, String[] b, String[] p, String s) {
            if (b == null || p == null) {
                throw new NullPointerException();
            }
            if (b.length == 0 && p.length > 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = u;
            this.testCase = tc;
            this.bugIdStrings = b;
            this.platforms = p;
            this.synopsis = s;
        }

        public Entry(String u, String tc, int[] b, String[] p, String s) {
            if (b == null || p == null) {
                throw new NullPointerException();
            }
            if (b.length == 0 && p.length > 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = u;
            this.testCase = tc;
            this.bugIdStrings = new String[b.length];
            for (int i = 0; i < b.length; ++i) {
                this.bugIdStrings[i] = String.valueOf(b[i]);
            }
            this.bugIds = b;
            this.platforms = p;
            this.synopsis = s;
        }

        @Override
        public int compareTo(Entry e) {
            int n = this.relativeURL.compareTo(e.relativeURL);
            if (n == 0) {
                if (this.testCase == null && e.testCase == null) {
                    return 0;
                }
                if (this.testCase == null) {
                    return -1;
                }
                if (e.testCase == null) {
                    return 1;
                }
                return this.testCase.compareTo(e.testCase);
            }
            return n;
        }

        public String getRelativeURL() {
            return this.relativeURL;
        }

        public String getTestCases() {
            return this.testCase;
        }

        public String[] getTestCaseList() {
            if (this.testCase == null) {
                return null;
            }
            Vector<String> v = new Vector<String>();
            int start = -1;
            for (int i = 0; i < this.testCase.length(); ++i) {
                if (this.testCase.charAt(i) == ',') {
                    if (start != -1) {
                        v.addElement(this.testCase.substring(start, i));
                    }
                    start = -1;
                    continue;
                }
                if (start != -1) continue;
                start = i;
            }
            if (start != -1) {
                v.addElement(this.testCase.substring(start));
            }
            if (v.size() == 0) {
                return null;
            }
            Object[] a = new String[v.size()];
            v.copyInto(a);
            return a;
        }

        public int[] getBugIds() {
            if (this.bugIds == null) {
                this.bugIds = new int[this.bugIdStrings.length];
                for (int i = 0; i < this.bugIds.length; ++i) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        String str = this.bugIdStrings[i];
                        for (int j = 0; j < str.length(); ++j) {
                            if (!Character.isDigit(str.charAt(j))) continue;
                            sb.append(str.charAt(j));
                        }
                        this.bugIds[i] = Integer.parseInt(sb.toString());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.bugIds[i] = -1;
                    }
                }
            }
            return this.bugIds;
        }

        public String[] getBugIdStrings() {
            return this.bugIdStrings;
        }

        public String[] getPlatforms() {
            return this.platforms;
        }

        public String getSynopsis() {
            return this.synopsis;
        }

        public static Entry read(String text) throws Fault {
            try {
                return new Parser(new StringReader(text)).readEntry();
            }
            catch (IOException e) {
                throw new Fault(i18n, "excl.badEntry", e);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return Entry.equals(this.relativeURL, e.relativeURL) && Entry.equals(this.testCase, e.testCase) && Entry.equals(this.bugIdStrings, e.bugIdStrings) && Entry.equals(this.platforms, e.platforms) && Entry.equals(this.synopsis, e.synopsis);
            }
            return false;
        }

        public int hashCode() {
            return this.relativeURL.hashCode();
        }

        public String toString() {
            int i;
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.relativeURL);
            if (this.testCase != null) {
                sb.append('[');
                sb.append(this.testCase);
                sb.append(']');
            }
            if (this.bugIdStrings != null) {
                for (i = 0; i < this.bugIdStrings.length; ++i) {
                    sb.append(i == 0 ? (char)' ' : ',');
                    sb.append(this.bugIdStrings[i]);
                }
            }
            if (this.platforms != null) {
                for (i = 0; i < this.platforms.length; ++i) {
                    sb.append(i == 0 ? (char)' ' : ',');
                    sb.append(this.platforms[i]);
                }
            }
            if (this.synopsis != null) {
                sb.append(' ');
                sb.append(this.synopsis);
            }
            return new String(sb);
        }

        private static boolean equals(int[] i1, int[] i2) {
            if (i1 == null || i2 == null) {
                return i1 == null && i2 == null;
            }
            if (i1.length != i2.length) {
                return false;
            }
            for (int x = 0; x < i1.length; ++x) {
                if (i1[x] == i2[x]) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String[] s1, String[] s2) {
            if (s1 == null || s2 == null) {
                return s1 == null && s2 == null;
            }
            if (s1.length != s2.length) {
                return false;
            }
            for (int x = 0; x < s1.length; ++x) {
                if (Entry.equals(s1[x], s2[x])) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String s1, String s2) {
            return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
        }
    }

    private static class Key {
        private static final char sep = File.separatorChar;
        private String relativeURL;
        private int hash;

        Key(String url) {
            this.relativeURL = url;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                int len = this.relativeURL.length();
                for (int i = 0; i < len; ++i) {
                    char c = this.relativeURL.charAt(i);
                    if (!caseSensitive) {
                        c = Character.toLowerCase(c);
                    }
                    if (c == sep) {
                        c = '/';
                    }
                    h = 31 * h + c;
                }
                this.hash = h;
            }
            return h;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Key)) {
                return false;
            }
            String u1 = this.relativeURL;
            String u2 = ((Key)o).relativeURL;
            int len = u1.length();
            if (len != u2.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char c1 = u1.charAt(i);
                if (c1 == sep) {
                    c1 = '/';
                } else if (!caseSensitive) {
                    c1 = Character.toLowerCase(c1);
                }
                char c2 = u2.charAt(i);
                if (c2 == sep) {
                    c2 = '/';
                } else if (!caseSensitive) {
                    c2 = Character.toLowerCase(c2);
                }
                if (c1 == c2) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Parser {
        private Reader in;
        private int ch;
        private Map<String, String[]> platformCache = new HashMap<String, String[]>();
        private String title;

        Parser(Reader in) throws IOException {
            this.in = in;
            this.ch = in.read();
        }

        String getTitle() {
            return this.title;
        }

        Entry readEntry() throws IOException, Fault {
            int i;
            String url = this.readURL();
            if (url == null) {
                return null;
            }
            String testCase = null;
            if (url.endsWith("]") && (i = url.lastIndexOf("[")) != -1) {
                testCase = url.substring(i + 1, url.length() - 1);
                url = url.substring(0, i);
            }
            String[] bugIdStrings = this.readBugIds();
            String[] platforms = this.readPlatforms();
            String synopsis = this.readRest();
            return new Entry(url, testCase, bugIdStrings, platforms, synopsis);
        }

        private boolean isEndOfLine(int ch) {
            return ch == -1 || ch == 10 || ch == 13;
        }

        private boolean isWhitespace(int ch) {
            return ch == 32 || ch == 9;
        }

        private String readURL() throws IOException, Fault {
            block5: while (true) {
                this.skipWhite();
                switch (this.ch) {
                    case -1: {
                        return null;
                    }
                    case 35: {
                        this.skipComment();
                        continue block5;
                    }
                    case 10: 
                    case 13: {
                        this.ch = this.in.read();
                        continue block5;
                    }
                }
                break;
            }
            return this.readWord();
        }

        private String[] readBugIds() throws IOException {
            this.skipWhite();
            TreeSet<String> s = new TreeSet<String>();
            StringBuffer sb = new StringBuffer();
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                if (this.ch == 44) {
                    if (sb.length() > 0) {
                        s.add(sb.toString());
                        sb.setLength(0);
                    }
                } else {
                    sb.append((char)this.ch);
                }
                this.ch = this.in.read();
            }
            if (sb.length() > 0) {
                s.add(sb.toString());
            }
            if (s.size() == 0) {
                s.add("0");
            }
            return s.toArray(new String[s.size()]);
        }

        private String[] readPlatforms() throws IOException {
            this.skipWhite();
            String s = this.readWord();
            String[] platforms = this.platformCache.get(s);
            if (platforms == null) {
                int n = 0;
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) != ',') continue;
                    ++n;
                }
                TreeSet<String> ts = new TreeSet<String>();
                int start = 0;
                int end = s.indexOf(44);
                while (end != -1) {
                    ts.add(s.substring(start, end));
                    start = end + 1;
                    end = s.indexOf(44, start);
                }
                ts.add(s.substring(start));
                platforms = ts.toArray(new String[ts.size()]);
                this.platformCache.put(s, platforms);
            }
            return platforms;
        }

        private String readRest() throws IOException {
            this.skipWhite();
            StringBuffer word = new StringBuffer(80);
            while (!this.isEndOfLine(this.ch)) {
                word.append((char)this.ch);
                this.ch = this.in.read();
            }
            this.ch = this.in.read();
            return word.toString();
        }

        private String readWord() throws IOException {
            StringBuffer word = new StringBuffer(32);
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                word.append((char)this.ch);
                this.ch = this.in.read();
            }
            return word.toString();
        }

        private void skipComment() throws IOException, Fault {
            this.ch = this.in.read();
            if (this.ch == 35) {
                this.ch = this.in.read();
                if (this.ch == 35) {
                    this.ch = this.in.read();
                    this.skipWhite();
                    String s = this.readWord();
                    if (s.equals("title")) {
                        this.skipWhite();
                        this.title = this.readRest();
                        return;
                    }
                }
            }
            while (!this.isEndOfLine(this.ch)) {
                this.ch = this.in.read();
            }
        }

        private void skipWhite() throws IOException {
            while (this.ch != -1 && this.isWhitespace(this.ch)) {
                this.ch = this.in.read();
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }
    }
}

