/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public abstract class BasicParameters
implements Parameters,
Parameters.MutableTestsParameters,
Parameters.MutableExcludeListParameters,
Parameters.MutableKeywordsParameters,
Parameters.MutablePriorStatusParameters,
Parameters.MutableConcurrencyParameters,
Parameters.MutableTimeoutFactorParameters {
    private TestSuite testSuite;
    protected String testSuiteError;
    private WorkDirectory workDir;
    protected String workDirError;
    private int testsMode = 1;
    private String[] tests;
    private int excludeMode = 1;
    private boolean latestExcludeAutoCheck;
    private int latestExcludeAutoCheckMode;
    private int latestExcludeAutoCheckInterval;
    private File[] customExcludeFiles = new File[0];
    private File[] cachedAbsExcludeFiles;
    private File cachedAbsExcludeFiles_base;
    private File[] cachedAbsExcludeFiles_excludeFiles;
    private ExcludeList cachedExcludeList;
    private File[] cachedExcludeList_absExclFiles;
    private ExcludeListFilter cachedExcludeListFilter;
    protected String excludeListError;
    private int keywordsMode = 1;
    private int keywordsMatchMode = 3;
    private String keywordsMatchValue;
    private int cachedKeywordsMatchMode;
    private String cachedKeywordsMatchValue;
    private Keywords cachedKeywords;
    private TestFilter cachedKeywordsFilter;
    protected String keywordsError;
    private int priorStatusMode = 1;
    private boolean[] priorStatusValues = new boolean[4];
    private StatusFilter cachedPriorStatusFilter;
    private int concurrency = 1;
    protected String concurrencyError;
    private float timeoutFactor = 1.0f;
    protected String timeoutFactorError;
    private TestFilter cachedRelevantTestFilter;
    private TestSuite cachedRelevantTestFilterTestSuite;
    private TestEnvironment cachedRelevantTestFilterEnv;
    private TestFilter[] cachedTestFilters;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BasicParameters.class);

    @Override
    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(File file) {
        if (file == null) {
            this.testSuiteError = i18n.getString("bp.noTestSuite");
        } else {
            try {
                this.setTestSuite(TestSuite.open(file));
            }
            catch (FileNotFoundException e) {
                this.testSuiteError = i18n.getString("bp.cantFindTestSuite", file);
            }
            catch (TestSuite.Fault e) {
                this.testSuiteError = i18n.getString("bp.badTestSuite", e.getMessage());
            }
        }
    }

    @Override
    public void setTestSuite(TestSuite ts) {
        if (ts == null) {
            throw new NullPointerException();
        }
        if (this.testSuite != null && this.testSuite != ts) {
            throw new IllegalStateException();
        }
        this.testSuite = ts;
        this.testSuiteError = null;
    }

    private boolean isTestSuiteOK() {
        return this.testSuiteError == null;
    }

    @Override
    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(File dir) {
        block12: {
            if (dir == null) {
                this.workDirError = i18n.getString("bp.workDirMissing");
            } else if (this.isTestSuiteOK()) {
                try {
                    TestSuite ts = this.getTestSuite();
                    if (dir.exists()) {
                        if (WorkDirectory.isWorkDirectory(dir)) {
                            this.setWorkDirectory(WorkDirectory.open(dir, ts));
                            this.workDirError = null;
                        } else if (WorkDirectory.isEmptyDirectory(dir)) {
                            this.workDir = WorkDirectory.create(dir, ts);
                            this.workDirError = null;
                        } else {
                            this.workDirError = i18n.getString("bp.badWorkDir", dir.getPath());
                        }
                        break block12;
                    }
                    this.workDirError = i18n.getString("bp.cantFindWorkDir", dir.getPath());
                }
                catch (FileNotFoundException e) {
                    this.workDirError = i18n.getString("bp.cantFindWorkDir", dir.getPath());
                }
                catch (WorkDirectory.Fault e) {
                    this.workDirError = i18n.getString("bp.workDirError", e.getMessage());
                }
            } else {
                this.workDirError = i18n.getString("bp.noTestSuite");
            }
        }
    }

    @Override
    public void setWorkDirectory(WorkDirectory wd) {
        if (wd == null) {
            throw new NullPointerException();
        }
        if (this.workDir != null && this.workDir != wd) {
            throw new IllegalStateException();
        }
        if (this.testSuite != null && wd.getTestSuite() != this.testSuite) {
            throw new IllegalArgumentException();
        }
        if (this.testSuite == null) {
            this.setTestSuite(wd.getTestSuite());
        }
        this.workDir = wd;
    }

    private boolean isWorkDirectoryOK() {
        return this.workDirError == null;
    }

    @Override
    public Parameters.TestsParameters getTestsParameters() {
        return this;
    }

    @Override
    public String[] getTests() {
        return this.tests;
    }

    @Override
    public void setTests(String[] tests) {
        if (tests == null) {
            this.testsMode = 1;
        } else {
            this.testsMode = 2;
            this.tests = tests;
        }
    }

    @Override
    public int getTestsMode() {
        return this.testsMode;
    }

    @Override
    public void setTestsMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.testsMode = mode;
    }

    @Override
    public String[] getSpecifiedTests() {
        return this.tests;
    }

    @Override
    public void setSpecifiedTests(String[] tests) {
        if (tests == null) {
            throw new NullPointerException();
        }
        this.tests = tests;
    }

    private boolean isTestsOK() {
        return true;
    }

    @Override
    public Parameters.ExcludeListParameters getExcludeListParameters() {
        return this;
    }

    @Override
    public File[] getExcludeFiles() {
        TestSuite ts = this.getTestSuite();
        switch (this.excludeMode) {
            case 2: {
                if (ts == null) {
                    return null;
                }
                File df = ts.getInitialExcludeList();
                if (df == null) {
                    return null;
                }
                return new File[]{df};
            }
            case 3: {
                if (ts == null) {
                    return null;
                }
                URL u = ts.getLatestExcludeList();
                if (u == null) {
                    return null;
                }
                WorkDirectory wd = this.getWorkDirectory();
                if (wd == null) {
                    return null;
                }
                return new File[]{wd.getSystemFile("latest.jtx")};
            }
            case 4: {
                return this.customExcludeFiles;
            }
        }
        return null;
    }

    @Override
    public void setExcludeFiles(File[] files) {
        if (files == null || files.length == 0) {
            this.setExcludeMode(1);
        } else {
            this.setExcludeMode(4);
            this.setCustomExcludeFiles(files);
        }
    }

    @Override
    public ExcludeList getExcludeList() {
        this.updateExcludeList();
        return this.cachedExcludeList;
    }

    @Override
    public TestFilter getExcludeListFilter() {
        this.updateExcludeList();
        return this.cachedExcludeListFilter;
    }

    @Override
    public int getExcludeMode() {
        return this.excludeMode;
    }

    @Override
    public void setExcludeMode(int mode) {
        this.excludeMode = mode;
    }

    @Override
    public File[] getCustomExcludeFiles() {
        return this.customExcludeFiles;
    }

    @Override
    public void setCustomExcludeFiles(File[] files) {
        this.customExcludeFiles = files;
    }

    @Override
    public boolean isLatestExcludeAutoCheckEnabled() {
        return false;
    }

    @Override
    public void setLatestExcludeAutoCheckEnabled(boolean b) {
        this.latestExcludeAutoCheck = b;
    }

    @Override
    public int getLatestExcludeAutoCheckMode() {
        return this.latestExcludeAutoCheckMode;
    }

    @Override
    public void setLatestExcludeAutoCheckMode(int mode) {
        this.latestExcludeAutoCheckMode = mode;
    }

    @Override
    public int getLatestExcludeAutoCheckInterval() {
        return this.latestExcludeAutoCheckInterval;
    }

    @Override
    public void setLatestExcludeAutoCheckInterval(int days) {
        this.latestExcludeAutoCheckInterval = days;
    }

    private boolean isExcludeListOK() {
        return this.excludeListError == null;
    }

    private File[] getAbsoluteExcludeFiles() {
        this.updateAbsoluteExcludeFiles();
        return this.cachedAbsExcludeFiles;
    }

    private void updateAbsoluteExcludeFiles() {
        TestSuite ts = this.getTestSuite();
        File base = ts == null ? null : ts.getRootDir();
        File[] excludeFiles = this.getExcludeFiles();
        if (this.cachedAbsExcludeFiles == null || this.cachedAbsExcludeFiles_base != base || this.cachedAbsExcludeFiles_excludeFiles != excludeFiles) {
            this.cachedAbsExcludeFiles = BasicParameters.getAbsoluteFiles(base, excludeFiles);
        }
    }

    private void updateExcludeList() {
        File[] absExclFiles = this.getAbsoluteExcludeFiles();
        if (this.cachedExcludeList == null || !BasicParameters.equal(this.cachedExcludeList_absExclFiles, absExclFiles)) {
            try {
                this.cachedExcludeList = absExclFiles == null ? new ExcludeList() : new ExcludeList(this.cachedAbsExcludeFiles);
                this.cachedExcludeList_absExclFiles = this.cachedAbsExcludeFiles;
                this.cachedExcludeListFilter = new ExcludeListFilter(this.cachedExcludeList);
                this.excludeListError = null;
            }
            catch (FileNotFoundException e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListNotFound", e.getMessage());
            }
            catch (IOException e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListFault", e);
            }
            catch (ExcludeList.Fault e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListFault", e.getMessage());
            }
        }
    }

    @Override
    public Parameters.KeywordsParameters getKeywordsParameters() {
        return this;
    }

    @Override
    public Keywords getKeywords() {
        this.updateCachedKeywords();
        return this.cachedKeywords;
    }

    @Override
    public void setKeywords(int mode, String value) {
        if (value == null) {
            this.keywordsMode = 1;
        } else {
            this.keywordsMode = 2;
            this.keywordsMatchMode = mode;
            this.keywordsMatchValue = value;
        }
    }

    @Override
    public TestFilter getKeywordsFilter() {
        this.updateCachedKeywords();
        if (this.keywordsMode == 1) {
            return null;
        }
        return this.cachedKeywordsFilter;
    }

    @Override
    public int getKeywordsMode() {
        return this.keywordsMode;
    }

    @Override
    public void setKeywordsMode(int mode) {
        this.keywordsMode = mode;
    }

    @Override
    public int getMatchKeywordsMode() {
        return this.keywordsMatchMode;
    }

    @Override
    public String getMatchKeywordsValue() {
        return this.keywordsMatchValue;
    }

    @Override
    public void setMatchKeywords(int mode, String value) {
        this.keywordsMatchMode = mode;
        this.keywordsMatchValue = value;
    }

    private void updateCachedKeywords() {
        if (this.keywordsMode == 1) {
            this.cachedKeywordsMatchMode = -1;
            this.cachedKeywordsMatchValue = null;
            this.cachedKeywords = null;
            this.cachedKeywordsFilter = null;
            this.keywordsError = null;
        } else if (this.cachedKeywordsMatchMode != this.keywordsMatchMode || this.cachedKeywordsMatchValue == null || !this.cachedKeywordsMatchValue.equals(this.keywordsMatchValue)) {
            try {
                this.cachedKeywordsMatchMode = this.keywordsMatchMode;
                this.cachedKeywordsMatchValue = this.keywordsMatchValue;
                String op = this.keywordsMatchMode == 3 ? "expr" : (this.keywordsMatchMode == 2 ? "all of" : "any of");
                this.cachedKeywords = Keywords.create(op, this.keywordsMatchValue);
                this.cachedKeywordsFilter = new KeywordsFilter(this.cachedKeywords);
            }
            catch (Keywords.Fault e) {
                this.cachedKeywords = null;
                this.cachedKeywordsFilter = null;
                this.keywordsError = i18n.getString("bp.badKeywords", e.getMessage());
            }
        }
    }

    private boolean isKeywordsOK() {
        this.updateCachedKeywords();
        return this.keywordsError == null;
    }

    @Override
    public Parameters.PriorStatusParameters getPriorStatusParameters() {
        return this;
    }

    @Override
    public boolean[] getPriorStatusValues() {
        if (this.priorStatusMode == 1) {
            return null;
        }
        return this.priorStatusValues;
    }

    @Override
    public void setPriorStatusValues(boolean[] values) {
        if (values == null) {
            this.priorStatusMode = 1;
        } else {
            this.priorStatusMode = 2;
            this.priorStatusValues = values;
        }
    }

    @Override
    public TestFilter getPriorStatusFilter() {
        WorkDirectory wd = this.getWorkDirectory();
        TestResultTable r = wd == null ? null : wd.getTestResultTable();
        boolean[] s = this.getPriorStatusValues();
        if (r == null || s == null) {
            this.cachedPriorStatusFilter = null;
        } else if (this.cachedPriorStatusFilter == null || this.cachedPriorStatusFilter.getTestResultTable() != r || !BasicParameters.equal(this.cachedPriorStatusFilter.getStatusValues(), s)) {
            this.cachedPriorStatusFilter = new StatusFilter(s, r);
        }
        return this.cachedPriorStatusFilter;
    }

    @Override
    public int getPriorStatusMode() {
        return this.priorStatusMode;
    }

    @Override
    public void setPriorStatusMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.priorStatusMode = mode;
    }

    @Override
    public boolean[] getMatchPriorStatusValues() {
        return this.priorStatusValues;
    }

    @Override
    public void setMatchPriorStatusValues(boolean[] v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (v.length != 4) {
            throw new IllegalArgumentException();
        }
        this.priorStatusValues = v;
    }

    private boolean isPriorStatusOK() {
        return true;
    }

    @Override
    public Parameters.ConcurrencyParameters getConcurrencyParameters() {
        return this;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public void setConcurrency(int conc) {
        if (conc <= 0) {
            this.concurrencyError = i18n.getString("bp.badConcurrency", new Integer(conc));
            this.concurrency = 1;
        } else {
            this.concurrencyError = null;
            this.concurrency = conc;
        }
    }

    private boolean isConcurrencyOK() {
        return this.concurrencyError == null;
    }

    @Override
    public Parameters.TimeoutFactorParameters getTimeoutFactorParameters() {
        return this;
    }

    @Override
    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    @Override
    public void setTimeoutFactor(float tf) {
        if (tf <= 0.0f) {
            this.timeoutFactorError = i18n.getString("bp.badTimeout", new Float(tf));
            this.timeoutFactor = 1.0f;
        } else {
            this.timeoutFactorError = null;
            this.timeoutFactor = tf;
        }
    }

    private boolean isTimeoutFactorOK() {
        return this.timeoutFactorError == null;
    }

    @Override
    public TestFilter getRelevantTestFilter() {
        TestSuite ts = this.getTestSuite();
        TestEnvironment env = this.getEnv();
        if (ts == null || env == null) {
            this.cachedRelevantTestFilter = null;
        } else if (this.cachedRelevantTestFilter == null || ts != this.cachedRelevantTestFilterTestSuite || env != this.cachedRelevantTestFilterEnv) {
            this.cachedRelevantTestFilter = ts.createTestFilter(env);
        }
        return this.cachedRelevantTestFilter;
    }

    @Override
    public synchronized TestFilter[] getFilters() {
        TestFilter testSuiteFilter;
        TestFilter statusFilter;
        TestFilter keywordFilter;
        Vector<TestFilter> v = new Vector<TestFilter>();
        TestFilter excludeFilter = this.getExcludeListFilter();
        if (excludeFilter != null) {
            v.addElement(excludeFilter);
        }
        if ((keywordFilter = this.getKeywordsFilter()) != null) {
            v.addElement(keywordFilter);
        }
        if ((statusFilter = this.getPriorStatusFilter()) != null) {
            v.addElement(statusFilter);
        }
        if ((testSuiteFilter = this.getRelevantTestFilter()) != null) {
            v.addElement(testSuiteFilter);
        }
        if (v.size() == 0) {
            return null;
        }
        if (BasicParameters.equal(v, this.cachedTestFilters)) {
            return this.cachedTestFilters;
        }
        Object[] filters = new TestFilter[v.size()];
        v.copyInto(filters);
        return filters;
    }

    @Override
    public boolean isValid() {
        return this.isTestSuiteOK() && this.isWorkDirectoryOK() && this.isTestsOK() && this.isExcludeListOK() && this.isKeywordsOK() && this.isPriorStatusOK() && this.isConcurrencyOK() && this.isTimeoutFactorOK();
    }

    @Override
    public String getErrorMessage() {
        return this.testSuiteError != null ? this.testSuiteError : (this.workDirError != null ? this.workDirError : (this.excludeListError != null ? this.excludeListError : (this.keywordsError != null ? this.keywordsError : (this.concurrencyError != null ? this.concurrencyError : (this.timeoutFactorError != null ? this.timeoutFactorError : null)))));
    }

    protected static File[] getAbsoluteFiles(File baseDir, File[] files) {
        if (files == null) {
            return null;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    protected static boolean equal(boolean[] b1, boolean[] b2) {
        if (b1 == null || b2 == null) {
            return b1 == b2;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(Vector<TestFilter> v, TestFilter[] f) {
        if (f == null || v.size() != f.length) {
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            if (v.elementAt(i).equals(f[i])) continue;
            return false;
        }
        return true;
    }
}

