/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.interview.wizard.Exporter;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InfoPanel;
import com.sun.interview.wizard.PathPanel;
import com.sun.interview.wizard.QuestionPanel;
import com.sun.interview.wizard.SearchDialog;
import com.sun.javatest.tool.jthelp.HelpBroker;
import com.sun.javatest.tool.jthelp.HelpSet;
import com.sun.javatest.tool.jthelp.JTHelpBroker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public class Wizard
extends JComponent {
    public static final String OK = "OK";
    private ActionListener performer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Wizard.this.perform(e.getActionCommand());
        }
    };
    private Interview interview;
    private Exporter[] exporters;
    private String title;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JComponent main;
    private JPanel body;
    private PathPanel pathPanel;
    private QuestionPanel questionPanel;
    private InfoPanel infoPanel;
    private JToolBar buttonPanel;
    private JButton cancelBtn;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton okBtn;
    private JToggleButton infoBtn;
    private Window window;
    private ActionListener okListener;
    private SearchDialog searchDialog;
    private boolean initialInfoVisible = true;
    private Listener listener = new Listener();
    private HelpSet helpHelpSet;
    private HelpBroker helpHelpBroker;
    private String helpHelpPrefix;
    private JMenu helpMenu;
    private File currFile;
    private File defaultFile;
    private boolean exitOnClose;
    private final FileFilter jtiFilter = new ExtensionFileFilter(".jti");
    private final FileFilter htmlFilter = new ExtensionFileFilter(new String[]{".htm", ".html"});
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke("ENTER");
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static final String[][] fileMenuData = new String[][]{{"new", "performNew"}, {"open", "performOpen"}, {"save", "performSave"}, {"saveAs", "performSaveAs"}, null, {"exportLog", "performExportLog"}};
    private static final String[][] helpMenuData = new String[][]{{"help", "performHelp", "F1"}};
    private static final String[][] searchMenuData = new String[][]{{"find", "performFind", "control F"}, {"findNext", "performFindNext", "F3"}};

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            Class<?> ic = Class.forName(args[0], true, ClassLoader.getSystemClassLoader());
            Interview i = (Interview)ic.newInstance();
            Wizard w = new Wizard(i);
            w.showInFrame(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public Wizard(Interview i) {
        this(i, null);
    }

    public Wizard(Interview i, Exporter[] e) {
        this.interview = i;
        this.exporters = e;
    }

    public void open(File f) throws Interview.Fault, IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            Map<String, String> stringProps = com.sun.javatest.util.Properties.load(in);
            this.interview.load(stringProps);
            this.interview.setEdited(false);
            String info = stringProps.get("INFO");
            if (info == null) {
                info = "true";
            }
            this.initialInfoVisible = info.equals("true");
        }
    }

    public void save(File f) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            Properties p = new Properties();
            if (this.infoPanel != null) {
                p.put("INFO", String.valueOf(this.infoPanel.isShowing()));
            }
            this.interview.save(com.sun.javatest.util.Properties.convertToStringProps(p));
            this.interview.setEdited(false);
            p.save(out, "Wizard data file: " + this.interview.getTitle());
        }
    }

    public File getFile() {
        return this.currFile;
    }

    public void setFile(File f) {
        this.currFile = new File(f.getAbsolutePath());
        if (this.window != null) {
            this.updateTitle(this.window);
        }
    }

    public void setDefaultFile(File f) {
        this.defaultFile = f;
        if (this.window != null) {
            this.updateTitle(this.window);
        }
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpHelpBroker = helpBroker;
    }

    public void setHelpSet(HelpSet helpSet) {
        this.helpHelpSet = helpSet;
    }

    public void setHelpSetPrefix(String helpPrefix) {
        this.helpHelpPrefix = helpPrefix;
    }

    public void setHelpMenu(JMenu helpMenu) {
        this.helpMenu = helpMenu;
    }

    public void showInFrame(final boolean exitOnClose) {
        if (this.window != null && !(this.window instanceof JFrame)) {
            throw new IllegalStateException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Wizard.this.showInFrame(exitOnClose);
                }
            });
            return;
        }
        this.initGUI();
        this.okBtn.setVisible(false);
        this.cancelBtn.setVisible(false);
        JFrame f = new JFrame();
        this.initMenuBar(f);
        this.updateTitle(f);
        f.setName("interview.wizard");
        f.setJMenuBar(this.menuBar);
        f.setContentPane(this.main);
        f.pack();
        f.setDefaultCloseOperation(0);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Wizard.this.interview.isEdited() && !Wizard.this.okToContinue()) {
                    return;
                }
                e.getWindow().dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (exitOnClose) {
                    System.exit(0);
                }
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = f.getSize();
        f.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
        f.show();
        this.window = f;
    }

    public void showInDialog(final Frame parent, final ActionListener okListener) {
        if (this.window != null && !(this.window instanceof JDialog)) {
            throw new IllegalStateException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Wizard.this.showInDialog(parent, okListener);
                }
            });
            return;
        }
        this.okListener = okListener;
        this.initGUI();
        this.okBtn.setVisible(true);
        this.okBtn.setEnabled(this.interview.isFinishable());
        this.cancelBtn.setVisible(true);
        JDialog d = new JDialog(parent);
        this.initMenuBar(d);
        this.updateTitle(d);
        d.setJMenuBar(this.menuBar);
        d.setContentPane(this.main);
        d.pack();
        d.setDefaultCloseOperation(0);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!Wizard.this.interview.isEdited() || Wizard.this.okToContinue()) {
                    e.getWindow().dispose();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = d.getSize();
        d.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
        d.show();
        this.window = d;
    }

    @Override
    public boolean isShowing() {
        return this.window != null && this.window.isShowing();
    }

    public void toFront() {
        if (this.window != null) {
            this.window.toFront();
        }
    }

    private void initGUI() {
        this.title = this.interview.getTitle();
        if (this.title == null || this.title.equals("")) {
            this.title = i18n.getString("wizard.defaultTitle");
        }
        this.setLayout(new BorderLayout());
        this.main = this;
        this.questionPanel = new QuestionPanel(this.interview);
        this.questionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pathPanel = new PathPanel(this.questionPanel, this.interview);
        if (this.interview.getHelpSet() != null) {
            this.infoPanel = new InfoPanel(this.interview);
        }
        this.buttonPanel = new JToolBar();
        this.buttonPanel.setFloatable(false);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.backBtn = this.createButton("back", "performBack", this.performer);
        this.buttonPanel.add(this.backBtn);
        this.nextBtn = this.createButton("next", "performNext", this.performer);
        this.buttonPanel.add(this.nextBtn);
        this.buttonPanel.addSeparator();
        this.okBtn = this.createButton("ok", "performOk", this.performer);
        this.buttonPanel.add(this.okBtn);
        this.cancelBtn = this.createButton("cancel", "performCancel", this.performer);
        this.buttonPanel.add(this.cancelBtn);
        if (this.infoPanel != null) {
            this.buttonPanel.addSeparator();
            this.infoBtn = this.createToggle("info", "performInfo", this.performer);
            this.infoBtn.setSelected(this.initialInfoVisible);
            this.buttonPanel.add(this.infoBtn);
        }
        this.buttonPanel.addAncestorListener(new Listener());
        this.body = new JPanel(new BorderLayout());
        this.body.add((Component)this.pathPanel, "West");
        this.body.add((Component)this.questionPanel, "Center");
        this.body.add((Component)this.buttonPanel, "South");
        this.body.registerKeyboardAction(this.performer, "performFindNext", KeyStroke.getKeyStroke("F3"), 1);
        if (this.helpHelpPrefix == null) {
            this.helpHelpPrefix = "wizard.";
        }
        if (this.helpHelpSet == null && this.infoPanel != null) {
            this.helpHelpSet = this.infoPanel.getHelpSet();
        }
        if (this.helpHelpBroker == null && this.helpHelpSet != null) {
            this.helpHelpBroker = new JTHelpBroker();
        }
        if (this.helpHelpBroker != null && this.helpHelpSet != null) {
            this.helpHelpBroker.enableHelpKey(this.main, this.helpHelpPrefix + "window.csh");
        }
        if (this.infoPanel == null) {
            this.main.add(this.body);
        } else {
            this.update(this.infoBtn.isSelected());
        }
    }

    private void initMenuBar(Window w) {
        this.menuBar = new JMenuBar();
        this.fileMenu = this.createMenu("file", fileMenuData, this.performer);
        if (w instanceof JFrame) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.createMenuItem("file", "exit", "performExit", this.performer));
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.createMenuItem("file", "close", "performCancel", this.performer));
        }
        if (this.exporters != null) {
            for (int i = 0; i < this.fileMenu.getItemCount(); ++i) {
                JMenuItem mi = this.fileMenu.getItem(i);
                if (mi == null || !mi.getActionCommand().equals("performExportLog")) continue;
                this.fileMenu.remove(i);
                ExportMenu exportMenu = new ExportMenu(this.exporters);
                exportMenu.add(this.createMenuItem("export", "log", "performExportLog", this.performer));
                this.fileMenu.insert(exportMenu, i);
                break;
            }
        }
        this.menuBar.add(this.fileMenu);
        JMenu searchMenu = this.createMenu("search", searchMenuData, this.performer);
        this.menuBar.add(searchMenu);
        if (this.helpHelpBroker != null) {
            if (this.helpMenu == null) {
                this.helpMenu = this.createMenu("help", helpMenuData, this.performer);
            }
            this.menuBar.add(this.helpMenu);
        }
    }

    private void update(boolean showInfoPanel) {
        Dimension bodySize = this.body.getSize();
        if (bodySize.width == 0) {
            bodySize = this.body.getPreferredSize();
        }
        Dimension infoSize = this.infoPanel.getSize();
        if (infoSize.width == 0) {
            infoSize = this.infoPanel.getPreferredSize();
        }
        boolean infoPanelIsShowing = this.infoPanel.isShowing();
        this.main.removeAll();
        if (showInfoPanel) {
            JSplitPane sp = new JSplitPane(1, this.body, this.infoPanel);
            sp.setDividerLocation(bodySize.width + 2);
            this.main.add(sp);
            this.infoPanel.setCurrentID(this.interview.getCurrentQuestion());
        } else {
            this.main.add(this.body);
        }
        if (this.window != null) {
            int divWidth = new JSplitPane().getDividerSize();
            Dimension winSize = this.window.getSize();
            int newWidth = winSize.width;
            if (showInfoPanel != infoPanelIsShowing) {
                newWidth += (showInfoPanel ? 1 : -1) * (infoSize.width + divWidth + 4);
            }
            this.window.setSize(newWidth, winSize.height);
        }
        if (this.infoBtn.isSelected() != showInfoPanel) {
            this.infoBtn.setSelected(showInfoPanel);
        }
    }

    private void updateTitle(Window w) {
        String t = this.currFile == null || this.defaultFile != null && this.currFile.equals(this.defaultFile) ? this.title : i18n.getString("wizard.titleAndFile", new Object[]{this.title, this.currFile.getPath()});
        if (w instanceof JFrame) {
            ((JFrame)w).setTitle(t);
        } else {
            ((JDialog)w).setTitle(t);
        }
    }

    private void perform(String s) {
        try {
            Method m = Wizard.class.getDeclaredMethod(s, new Class[0]);
            m.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            System.err.println(s);
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            System.err.println(s);
            ex.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            System.err.println(s);
        }
    }

    private void performBack() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.prev();
        }
        catch (Interview.Fault fault) {
        }
        catch (RuntimeException e) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performCancel() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        this.window.dispose();
    }

    private void performExit() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        System.exit(0);
    }

    private void performExportLog() {
        File f;
        this.questionPanel.saveCurrentResponse();
        JFileChooser chooser = new JFileChooser();
        if (this.currFile != null) {
            chooser.setCurrentDirectory(new File(this.currFile.getParent()));
            int dot = this.currFile.getName().lastIndexOf(".");
            if (dot != -1) {
                f = new File(this.currFile.getName().substring(0, dot) + ".html");
                chooser.setSelectedFile(f);
            }
        } else {
            chooser.setCurrentDirectory(this.getUserDir());
        }
        chooser.setFileFilter(this.htmlFilter);
        int action = chooser.showDialog(this.main, i18n.getString("wizard.exportLog"));
        if (action != 0) {
            return;
        }
        f = this.ensureExtn(chooser.getSelectedFile(), ".html");
        if (f.exists() && !this.okToOverwrite(f)) {
            return;
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);
            WizPrint w = new WizPrint(this.interview, this.interview.getPath());
            w.setShowResponses(true);
            w.write(out);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", e.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", e.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private void performFind() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this.window, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.setVisible(true);
    }

    private void performFindNext() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this.window, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.find();
    }

    private void performHelp() {
        this.helpHelpBroker.displayCurrentID(this.helpHelpPrefix + "intro.csh");
    }

    private void performInfo() {
        boolean infoOn = this.infoBtn.isSelected();
        if (this.infoPanel.isShowing() != infoOn) {
            this.update(infoOn);
            this.window.validate();
        }
    }

    private void performNew() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        this.interview.clear();
        this.interview.setEdited(false);
        this.setFile(this.defaultFile);
    }

    private void performNext() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.next();
        }
        catch (Interview.Fault e) {
            this.questionPanel.getToolkit().beep();
        }
        catch (RuntimeException e) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performOk() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.window.dispose();
            this.okListener.actionPerformed(new ActionEvent(this, 1001, OK));
        }
        catch (RuntimeException e) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performOpen() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        if (this.currFile != null) {
            chooser.setCurrentDirectory(new File(this.currFile.getParent()));
            chooser.setSelectedFile(new File(this.currFile.getName()));
        } else {
            chooser.setCurrentDirectory(this.getUserDir());
        }
        chooser.setFileFilter(this.jtiFilter);
        int action = chooser.showOpenDialog(this.main);
        if (action != 0) {
            return;
        }
        File f = this.ensureExtn(chooser.getSelectedFile(), ".jti");
        try {
            this.open(f);
            this.setFile(f);
        }
        catch (Interview.Fault e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badInterview.txt", e.getMessage()), i18n.getString("wizard.badInterview.title"), 0);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", e.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", e.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private void performSave() {
        this.questionPanel.saveCurrentResponse();
        if (this.currFile == null) {
            this.performSaveAs();
        } else {
            this.performSaveInternal(this.currFile);
        }
    }

    private void performSaveAs() {
        this.questionPanel.saveCurrentResponse();
        JFileChooser chooser = new JFileChooser();
        if (this.currFile != null) {
            chooser.setCurrentDirectory(new File(this.currFile.getParent()));
            chooser.setSelectedFile(new File(this.currFile.getName()));
        } else {
            chooser.setCurrentDirectory(this.getUserDir());
        }
        chooser.setFileFilter(this.jtiFilter);
        int action = chooser.showSaveDialog(this.main);
        if (action != 0) {
            return;
        }
        File f = this.ensureExtn(chooser.getSelectedFile(), ".jti");
        if (f.exists() && !this.okToOverwrite(f)) {
            return;
        }
        this.performSaveInternal(f);
    }

    private void performSaveInternal(File f) {
        try {
            this.save(f);
            this.setFile(f);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", e.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", e.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private JButton createButton(String uiKey, String actionCommand, ActionListener l) {
        JButton b = new JButton(this.createIcon(uiKey));
        b.setToolTipText(i18n.getString("wizard." + uiKey + ".tip"));
        b.setActionCommand(actionCommand);
        b.addActionListener(l);
        b.registerKeyboardAction(l, actionCommand, enterKey, 0);
        return b;
    }

    private Icon createIcon(String uiKey) {
        String iconResource = i18n.getString("wizard." + uiKey + ".icon");
        URL url = this.getClass().getResource(iconResource);
        return url == null ? null : new ImageIcon(url);
    }

    private JMenu createMenu(String uiKey, String[][] menuData, ActionListener l) {
        JMenu m = new JMenu(i18n.getString("wizard." + uiKey + ".menu"));
        m.setName("wizard." + uiKey);
        m.setMnemonic(i18n.getString("wizard." + uiKey + ".mne").charAt(0));
        for (int i = 0; i < menuData.length; ++i) {
            String[] data = menuData[i];
            if (data == null) {
                m.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(uiKey, data[0], data[1], l);
            if (data.length > 2) {
                KeyStroke accel = KeyStroke.getKeyStroke(data[2]);
                mi.setAccelerator(accel);
            }
            m.add(mi);
        }
        return m;
    }

    private JMenuItem createMenuItem(String uiKey, String name, String actionCommand, ActionListener l) {
        JMenuItem item = new JMenuItem(i18n.getString("wizard." + uiKey + "." + name + ".mit"));
        item.setName(name);
        item.setMnemonic(i18n.getString("wizard." + uiKey + "." + name + ".mne").charAt(0));
        item.setActionCommand(actionCommand);
        item.addActionListener(l);
        return item;
    }

    private JToggleButton createToggle(String uiKey, String actionCommand, ActionListener l) {
        JToggleButton b = new JToggleButton(this.createIcon(uiKey)){

            @Override
            public Insets getInsets() {
                return Wizard.this.nextBtn == null ? super.getInsets() : Wizard.this.nextBtn.getInsets();
            }
        };
        b.setToolTipText(i18n.getString("wizard." + uiKey + ".tip"));
        b.setActionCommand(actionCommand);
        b.addActionListener(l);
        b.registerKeyboardAction(l, actionCommand, enterKey, 0);
        return b;
    }

    private File ensureExtn(File f, String extn) {
        if (f.getName().endsWith(extn)) {
            return f;
        }
        return new File(f.getPath() + extn);
    }

    private boolean okToContinue() {
        int response = JOptionPane.showConfirmDialog(this.main, i18n.getString("wizard.unsavedAnswers.txt"), i18n.getString("wizard.unsavedAnswers.title"), 0);
        return response == 0;
    }

    private boolean okToOverwrite(File f) {
        int response = JOptionPane.showConfirmDialog(this.main, i18n.getString("wizard.overwrite.txt", f), i18n.getString("wizard.overwrite.title"), 0);
        return response == 0;
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            Wizard.this.interview.addObserver(this);
            this.pathUpdated();
            this.currentQuestionChanged(Wizard.this.interview.getCurrentQuestion());
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            Wizard.this.interview.removeObserver(this);
        }

        @Override
        public void pathUpdated() {
            Wizard.this.okBtn.setEnabled(Wizard.this.interview.isFinishable());
        }

        @Override
        public void currentQuestionChanged(Question q) {
            Wizard.this.backBtn.setEnabled(!Wizard.this.interview.isFirst(q));
            Wizard.this.nextBtn.setEnabled(!Wizard.this.interview.isLast(q));
        }
    }

    private class ExportMenu
    extends JMenu
    implements ActionListener,
    PopupMenuListener {
        ExportMenu(Exporter[] exporters) {
            super(i18n.getString("wizard.export.menu"));
            this.setName("export");
            this.setMnemonic(i18n.getString("wizard.export.mne").charAt(0));
            for (int i = 0; i < exporters.length; ++i) {
                JMenuItem mi = new JMenuItem(exporters[i].getName());
                mi.putClientProperty("exporter", exporters[i]);
                mi.setActionCommand("performGenericExport");
                mi.addActionListener(this);
                this.add(mi);
            }
            this.getPopupMenu().addPopupMenuListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Wizard.this.questionPanel.saveCurrentResponse();
            JMenuItem mi = (JMenuItem)ev.getSource();
            Exporter e = (Exporter)mi.getClientProperty("exporter");
            this.export(e);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent ev) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
            JPopupMenu m = (JPopupMenu)ev.getSource();
            for (int i = 0; i < m.getComponentCount(); ++i) {
                Exporter e;
                JMenuItem mi = (JMenuItem)m.getComponent(i);
                if (mi == null || (e = (Exporter)mi.getClientProperty("exporter")) == null) continue;
                mi.setEnabled(e.isExportable());
            }
        }

        private void export(Exporter e) {
            String[] extns;
            JFileChooser exportChooser = new JFileChooser();
            if (Wizard.this.currFile != null) {
                exportChooser.setCurrentDirectory(new File(Wizard.this.currFile.getParent()));
                extns = e.getFileExtensions();
                int dot = Wizard.this.currFile.getName().lastIndexOf(".");
                if (dot != -1 && extns != null && extns.length > 0) {
                    File f = new File(Wizard.this.currFile.getName().substring(0, dot) + extns[0]);
                    exportChooser.setSelectedFile(f);
                }
            } else {
                exportChooser.setCurrentDirectory(Wizard.this.getUserDir());
            }
            exportChooser.setApproveButtonText(i18n.getString("wizard.exportChooser.export"));
            extns = e.getFileExtensions();
            String desc = e.getFileDescription();
            exportChooser.setFileFilter(new ExtensionFileFilter(extns, desc));
            int action = exportChooser.showSaveDialog(Wizard.this.main);
            if (action != 0) {
                return;
            }
            try {
                File f = Wizard.this.ensureExtn(exportChooser.getSelectedFile(), extns[0]);
                if (f.exists() && !Wizard.this.okToOverwrite(f)) {
                    return;
                }
                e.export(f);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(Wizard.this.main, i18n.getString("wizard.exportError.txt", ex.getMessage()), i18n.getString("wizard.exportError.title"), 0);
            }
            catch (Interview.Fault ex) {
                JOptionPane.showMessageDialog(Wizard.this.main, i18n.getString("wizard.exportError.txt", ex.getMessage()), i18n.getString("wizard.exportError.title"), 0);
            }
        }
    }

    private class ExtensionFileFilter
    extends FileFilter {
        private String[] extns;
        private String description;

        ExtensionFileFilter(String extn) {
            this.extns = new String[]{extn};
        }

        ExtensionFileFilter(String[] extns) {
            this.extns = extns;
        }

        ExtensionFileFilter(String[] extns, String description) {
            this.extns = extns;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extns.length; ++i) {
                if (!f.getName().endsWith(this.extns[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            if (this.description == null) {
                StringBuffer sb = new StringBuffer("wizard.extn");
                if (this.extns.length == 0) {
                    sb.append(".allFiles");
                } else {
                    for (int i = 0; i < this.extns.length; ++i) {
                        sb.append(this.extns[i]);
                    }
                }
                this.description = i18n.getString(sb.toString());
            }
            return this.description;
        }
    }
}

