/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InfoPanel;
import com.sun.interview.wizard.PathPanel;
import com.sun.interview.wizard.QuestionPanel;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SearchDialog;
import com.sun.javatest.tool.jthelp.HelpBroker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WizPane
extends JPanel {
    private Listener listener = new Listener();
    private Interview interview;
    private boolean infoEnabled;
    private HelpBroker helpHelpBroker;
    private String helpHelpPrefix = "wizard.";
    private JComponent main;
    private JPanel body;
    private PathPanel pathPanel;
    private QuestionPanel questionPanel;
    private JPanel buttonPanel;
    private InfoPanel infoPanel;
    private SearchDialog searchDialog;
    private static String DETAILS = "details";
    private static String FIND_NEXT = "findNext";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public WizPane(Interview i) {
        this(i, true);
    }

    public WizPane(Interview i, boolean enableInfo) {
        this.interview = i;
        this.infoEnabled = enableInfo;
        this.initGUI();
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpHelpBroker = helpBroker;
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpHelpPrefix = helpPrefix;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
        this.body.add((Component)buttonPanel, "South");
    }

    public boolean isEdited() {
        this.questionPanel.saveCurrentResponse();
        return this.interview.isEdited();
    }

    public boolean hasInfo() {
        return this.infoPanel != null;
    }

    public boolean isInfoVisible() {
        return this.main instanceof JSplitPane;
    }

    public void setInfoVisible(boolean b) {
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (b == this.isInfoVisible()) {
            return;
        }
        Dimension bodySize = this.body.getSize();
        if (bodySize.width == 0) {
            bodySize = this.body.getPreferredSize();
        }
        Dimension infoSize = this.infoPanel.getSize();
        if (infoSize.width == 0) {
            infoSize = this.infoPanel.getPreferredSize();
        }
        this.remove(this.main);
        if (b) {
            this.body.setBorder(null);
            JSplitPane sp = new JSplitPane(1, this.body, this.infoPanel);
            sp.setDividerLocation(bodySize.width - 1);
            this.main = sp;
            this.infoPanel.setCurrentID(this.interview.getCurrentQuestion());
        } else {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        }
        this.add(this.main);
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            Dimension winSize = window.getSize();
            int divWidth = new JSplitPane().getDividerSize();
            int newWidth = winSize.width;
            window.setSize(newWidth += (b ? 1 : -1) * (infoSize.width + divWidth), winSize.height);
        }
    }

    public boolean isTagVisible() {
        return this.questionPanel.isTagVisible();
    }

    public void setTagVisible(boolean v) {
        this.questionPanel.setTagVisible(v);
    }

    public boolean getMarkersEnabled() {
        return this.pathPanel.getMarkersEnabled();
    }

    public void setMarkersEnabled(boolean on) {
        this.pathPanel.setMarkersEnabled(on);
    }

    public boolean getMarkersFilterEnabled() {
        return this.pathPanel.getMarkersFilterEnabled();
    }

    public void setMarkersFilterEnabled(boolean on) {
        this.pathPanel.setMarkersFilterEnabled(on);
    }

    public JMenu getMarkerMenu() {
        return this.pathPanel.getMarkerMenu();
    }

    public void save() {
        this.questionPanel.saveCurrentResponse();
    }

    public void prev() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.prev();
        }
        catch (Interview.Fault fault) {
            // empty catch block
        }
    }

    public void prevVisible() {
        this.questionPanel.saveCurrentResponse();
        this.setCurrentQuestion(this.pathPanel.getPrevVisible());
    }

    public void next() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.next();
        }
        catch (Interview.Fault e) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void nextVisible() {
        this.questionPanel.saveCurrentResponse();
        this.setCurrentQuestion(this.pathPanel.getNextVisible());
    }

    public void last() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.last();
        }
        catch (Interview.Fault e) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void lastVisible() {
        this.questionPanel.saveCurrentResponse();
        Question cq = this.interview.getCurrentQuestion();
        Question lq = this.pathPanel.getLastVisible();
        if (lq == cq) {
            if (!(lq instanceof FinalQuestion)) {
                this.questionPanel.showValueInvalidMessage();
            }
        } else {
            this.setCurrentQuestion(lq);
        }
    }

    private void setCurrentQuestion(Question q) {
        if (q == null) {
            this.questionPanel.showValueInvalidMessage();
        } else {
            try {
                this.interview.setCurrentQuestion(q);
            }
            catch (Interview.Fault ignore) {
                throw new IllegalStateException();
            }
        }
    }

    public void find() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.setVisible(true);
    }

    public void findNext() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.find();
    }

    public void prepareClosing() {
        this.questionPanel.prepareClosing();
    }

    private void initGUI() {
        this.setInfo(this, "wizPane");
        this.setLayout(new BorderLayout());
        this.questionPanel = new QuestionPanel(this.interview);
        this.questionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.questionPanel.setNextAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizPane.this.getMarkersFilterEnabled()) {
                    WizPane.this.nextVisible();
                } else {
                    WizPane.this.next();
                }
            }
        });
        this.pathPanel = new PathPanel(this.questionPanel, this.interview);
        JScrollPane psp = new JScrollPane(this.pathPanel, 20, 31);
        psp.setName(this.pathPanel.getName() + ".sp");
        psp.setFocusable(false);
        this.body = new JPanel(new BorderLayout());
        this.body.setName("wizPane.body");
        this.body.setFocusable(false);
        JScrollPane qsp = new JScrollPane(this.questionPanel, 20, 31);
        qsp.setName(this.questionPanel.getName() + ".sp");
        qsp.setFocusable(false);
        JSplitPane lsp = new JSplitPane(1, psp, qsp);
        this.body.add((Component)lsp, "Center");
        this.body.registerKeyboardAction(this.listener, FIND_NEXT, KeyStroke.getKeyStroke("F3"), 1);
        if (this.infoEnabled && this.interview.getHelpSet() != null) {
            this.infoPanel = new InfoPanel(this.interview);
        }
        if (this.infoPanel == null) {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        } else {
            this.body.setBorder(null);
            this.main = new JSplitPane(1, this.body, this.infoPanel);
            this.setInfo(this.main, "wizPane.split");
        }
        this.add(this.main);
    }

    private void setInfo(JComponent jc, String uiKey) {
        jc.setName(uiKey);
        AccessibleContext ac = jc.getAccessibleContext();
        ac.setAccessibleName(i18n.getString(uiKey + ".name"));
        ac.setAccessibleDescription(i18n.getString(uiKey + ".desc"));
    }

    public void setCustomRenderers(Map<Class<? extends Question>, QuestionRenderer> customRenderers) {
        this.questionPanel.setCustomRenderers(customRenderers);
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(FIND_NEXT)) {
                WizPane.this.findNext();
            }
        }
    }
}

