/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TypeInPanel
extends JPanel {
    protected JTextField field;
    protected JComboBox<String> choice;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public TypeInPanel(String uiKey, final Question q, int fieldWidth, String[] suggestions, JButton btn, ActionListener listener) {
        this.setLayout(new GridBagLayout());
        this.setName(uiKey);
        this.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        if (fieldWidth <= 0) {
            c.anchor = 17;
            c.gridwidth = 0;
            c.weightx = 1.0;
        }
        JLabel label = new JLabel(i18n.getString(uiKey + ".lbl"));
        label.setName(uiKey + ".lbl");
        label.setDisplayedMnemonic(i18n.getString(uiKey + ".mne").charAt(0));
        label.setToolTipText(i18n.getString(uiKey + ".tip"));
        this.add((Component)label, c);
        c.gridwidth = 1;
        if (suggestions == null) {
            this.field = new JTextField(q.getStringValue());
            this.field.setName(uiKey + ".txt");
            this.field.addActionListener(listener);
            this.field.getDocument().addDocumentListener(new ActionDocListener(this.field, listener, "edited"));
            this.field.setToolTipText(label.getToolTipText());
            label.setLabelFor(this.field);
            if (fieldWidth <= 0) {
                c.fill = 2;
            } else {
                this.field.setColumns(fieldWidth);
            }
            this.add((Component)this.field, c);
        } else {
            this.choice = new JComboBox();
            this.choice.setName(uiKey + ".chc");
            this.choice.setEditable(true);
            this.choice.setSelectedItem(q.getStringValue());
            label.setLabelFor(this.choice);
            Component editComp = this.choice.getEditor().getEditorComponent();
            editComp.setFont(editComp.getFont().deriveFont(0));
            if (editComp instanceof Accessible) {
                if (editComp.getName() == null) {
                    editComp.setName(uiKey + ".chc.ed");
                }
                AccessibleContext ed_ac = editComp.getAccessibleContext();
                ed_ac.setAccessibleName(i18n.getString(uiKey + ".chc.ed.name"));
                ed_ac.setAccessibleDescription(i18n.getString(uiKey + ".chc.ed.desc"));
            }
            for (int i = 0; i < suggestions.length; ++i) {
                this.choice.addItem(suggestions[i]);
            }
            if (fieldWidth <= 0) {
                c.fill = 2;
                c.weightx = 1.0;
            } else {
                c.anchor = 17;
                c.weightx = 0.0;
            }
            this.add(this.choice, c);
        }
        if (btn != null) {
            c.insets.left = 10;
            c.weightx = 0.0;
            this.add((Component)btn, c);
        }
        Runnable valueSaver = new Runnable(){

            @Override
            public void run() {
                try {
                    q.setValue(TypeInPanel.this.getValue());
                }
                catch (Interview.Fault e) {
                    throw new Error(e);
                }
            }
        };
        this.putClientProperty("valueSaver", valueSaver);
    }

    protected String getValue() {
        if (this.field != null) {
            return this.field.getText();
        }
        if (this.choice.isEditable()) {
            return this.choice.getEditor().getItem().toString();
        }
        return this.choice.getSelectedItem().toString();
    }

    protected void setValue(String value) {
        if (this.field != null) {
            this.field.setText(value);
        } else {
            this.choice.setSelectedItem(value);
        }
    }
}

