/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChoiceQuestionRenderer
implements QuestionRenderer {
    protected static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    protected ChoiceQuestion q;
    protected String[] displayChoices;
    protected String[] values;
    protected int starts_from;
    protected ActionListener editedListener;
    protected JRadioButton[] rb;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        this.q = (ChoiceQuestion)qq;
        this.displayChoices = this.q.getDisplayChoices();
        this.values = this.q.getChoices();
        this.starts_from = this.values[0] == null ? 1 : 0;
        this.editedListener = listener;
        return this.createChoiceTable();
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected JComponent createChoiceTable() {
        TableModel tm = this.createTableModel();
        final JTable tbl = new JTable(tm);
        tbl.setOpaque(false);
        this.rb = new JRadioButton[this.displayChoices.length - this.starts_from];
        ButtonGroup bg = new ButtonGroup();
        String v = this.q.getValue();
        for (int i = 0; i < this.rb.length; ++i) {
            this.rb[i] = new JRadioButton(this.displayChoices[i + this.starts_from], this.values[i + this.starts_from] == v);
            this.rb[i].setActionCommand(this.values[i + this.starts_from]);
            this.rb[i].setName("chc.btn." + this.values[i + this.starts_from]);
            if (i < 10) {
                this.rb[i].setMnemonic(48 + i);
            }
            this.rb[i].setToolTipText(i18n.getString("chc.btn.tip"));
            this.rb[i].getAccessibleContext().setAccessibleName(this.rb[i].getName());
            this.rb[i].getAccessibleContext().setAccessibleDescription(this.rb[i].getToolTipText());
            this.rb[i].setBackground(tbl.getBackground());
            this.rb[i].setOpaque(false);
            this.rb[i].setFocusPainted(false);
            bg.add(this.rb[i]);
            this.rb[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableCellEditor editor = tbl.getCellEditor();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                }
            });
        }
        tbl.setPreferredScrollableViewportSize(new Dimension(DOTS_PER_INCH, DOTS_PER_INCH));
        tbl.setShowHorizontalLines(false);
        tbl.setShowVerticalLines(false);
        tbl.setTableHeader(null);
        tbl.setAutoResizeMode(0);
        tbl.setRowSelectionAllowed(false);
        tbl.setColumnSelectionAllowed(false);
        tbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        TableColumn col0 = tbl.getColumnModel().getColumn(0);
        TableCellRenderer r = this.createCellRenderer();
        col0.setCellRenderer(r);
        TableCellEditor e = this.createCellEditor();
        col0.setCellEditor(e);
        col0.setPreferredWidth(this.getColumnWidth(tbl, 0) + 20);
        JScrollPane sp = new JScrollPane(tbl);
        sp.setName("chcArr.sp");
        sp.getViewport().setBackground(tbl.getBackground());
        JLabel lbl = new JLabel(i18n.getString("chcArr.tbl.lbl"));
        lbl.setName("chcArr.tbl.lbl");
        lbl.setDisplayedMnemonic(i18n.getString("chcArr.tbl.mne").charAt(0));
        lbl.setToolTipText(i18n.getString("chcArr.tbl.tip"));
        lbl.setLabelFor(sp);
        tbl.setRowHeight(this.getRowHeight());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)lbl, "North");
        result.add((Component)sp, "Center");
        return result;
    }

    protected int getColumnWidth(JTable table, int colIndex) {
        int width = -1;
        TableModel model = table.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            TableCellRenderer r = table.getCellRenderer(i, colIndex);
            Component c = r.getTableCellRendererComponent(table, model.getValueAt(i, colIndex), false, false, i, colIndex);
            width = Math.max(width, c.getPreferredSize().width);
        }
        return width;
    }

    protected int getRowHeight() {
        return 22;
    }

    protected void fireEditedEvent(Object src, ActionListener l) {
        ActionEvent e = new ActionEvent(src, 1001, "edited");
        l.actionPerformed(e);
    }

    protected TableModel createTableModel() {
        return new TestTableModel();
    }

    protected TableCellRenderer createCellRenderer() {
        return new TestTableRenderer();
    }

    protected TableCellEditor createCellEditor() {
        return new TestTableEditor();
    }

    protected class TestTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected TestTableEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ChoiceQuestionRenderer.this.rb[row].setSelected(true);
            return ChoiceQuestionRenderer.this.rb[row];
        }
    }

    protected class TestTableRenderer
    implements TableCellRenderer {
        protected TestTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return ChoiceQuestionRenderer.this.rb[row];
        }
    }

    protected class TestTableModel
    extends AbstractTableModel {
        protected TestTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ChoiceQuestionRenderer.this.displayChoices.length - ChoiceQuestionRenderer.this.starts_from;
        }

        @Override
        public Object getValueAt(int r, int c) {
            return ChoiceQuestionRenderer.this.values[r + ChoiceQuestionRenderer.this.starts_from];
        }

        @Override
        public void setValueAt(Object o, int r, int c) {
            if (c == 0) {
                ChoiceQuestionRenderer.this.q.setValue(ChoiceQuestionRenderer.this.values[r + ChoiceQuestionRenderer.this.starts_from]);
                ChoiceQuestionRenderer.this.fireEditedEvent(this, ChoiceQuestionRenderer.this.editedListener);
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return true;
        }
    }
}

