/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;

public abstract class TreeQuestion
extends Question {
    private static String[] empty = new String[0];
    private Model model;
    protected String[] value;
    private String[] defaultValue;

    protected TreeQuestion(Interview interview, String tag, Model model) {
        super(interview, tag);
        this.model = model;
        this.clear();
        this.setDefaultValue(this.value);
    }

    public Model getModel() {
        return this.model;
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] v) {
        this.defaultValue = v;
    }

    public String[] getValue() {
        return this.value;
    }

    public String[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public void setValue(String newValue) {
        this.setValue(TreeQuestion.split(newValue));
    }

    public void setValue(String[] newValue) {
        Object[] oldValue;
        if (newValue == null) {
            oldValue = this.value;
            this.value = null;
        } else {
            oldValue = this.value;
            this.value = newValue;
        }
        if (!Arrays.equals(this.value, oldValue)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void setValue(Object[] nodes) {
        if (nodes == null) {
            this.setValue((String[])null);
            return;
        }
        String[] paths = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = this.model.getPath(nodes[i]);
        }
    }

    @Override
    public String getStringValue() {
        return TreeQuestion.join(this.value);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map<String, String> data) {
        String paths = data.get(this.tag);
        this.setValue(paths);
    }

    @Override
    protected void save(Map<String, String> data) {
        data.put(this.tag, TreeQuestion.join(this.value));
    }

    public static String[] split(String s) {
        if (s == null) {
            return empty;
        }
        Vector<String> v = new Vector<String>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (TreeQuestion.white(s.charAt(i))) {
                if (start != -1) {
                    v.addElement(s.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            v.addElement(s.substring(start));
        }
        if (v.size() == 0) {
            return empty;
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        return a;
    }

    public static String join(String[] paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        int l = paths.length - 1;
        for (int i = 0; i < paths.length; ++i) {
            l += paths[i].length();
        }
        StringBuffer sb = new StringBuffer(l);
        sb.append(paths[0]);
        for (int i = 1; i < paths.length; ++i) {
            sb.append(' ');
            sb.append(paths[i]);
        }
        return sb.toString();
    }

    public static boolean white(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    public static interface Model {
        public Object getRoot();

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public String getName(Object var1);

        public String getPath(Object var1);

        public boolean isLeaf(Object var1);
    }
}

