/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.Vector;

public abstract class StringListQuestion
extends Question {
    private static final String[] empty = new String[0];
    protected String[] value;
    private String[] defaultValue;
    private boolean duplicatesAllowed = true;

    protected StringListQuestion(Interview interview, String tag) {
        super(interview, tag);
        this.clear();
        this.setDefaultValue(this.value);
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] v) {
        this.defaultValue = v;
    }

    public void setDuplicatesAllowed(boolean b) {
        this.duplicatesAllowed = b;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public String[] getValue() {
        return this.value;
    }

    public String[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.value.length; ++i) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (this.value[i] == null) continue;
            sb.append(this.value[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    public boolean isValueAlwaysValid() {
        return false;
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : StringListQuestion.split(s));
    }

    public void setValue(String[] newValue) {
        if (newValue != null) {
            for (int i = 0; i < newValue.length; ++i) {
                if (newValue[i] != null && newValue[i].indexOf("\n") == -1) continue;
                throw new IllegalArgumentException();
            }
        }
        if (!StringListQuestion.equal(newValue, this.value)) {
            if (newValue == null) {
                this.value = null;
            } else {
                this.value = new String[newValue.length];
                System.arraycopy(newValue, 0, this.value, 0, newValue.length);
            }
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    @Override
    public void clear() {
        this.setValue(this.defaultValue);
    }

    @Override
    protected void load(Map<String, String> data) {
        String o = data.get(this.tag);
        this.setValue(o);
    }

    @Override
    protected void save(Map<String, String> data) {
        if (this.value != null) {
            data.put(this.tag, this.getStringValue());
        }
    }

    protected static boolean equal(String[] s1, String[] s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i = 0; i < s1.length; ++i) {
            if (StringListQuestion.equal(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    protected static String[] split(String s) {
        if (s == null) {
            return empty;
        }
        int sep = 10;
        Vector<String> v = new Vector<String>();
        int start = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n') {
                if (start != -1) {
                    v.addElement(s.substring(start, i));
                }
                start = -1;
                continue;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start != -1) {
            v.addElement(s.substring(start));
        }
        if (v.size() == 0) {
            return empty;
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        return a;
    }
}

