/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.jthelp.HelpID;
import com.sun.javatest.tool.jthelp.HelpSet;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;

public class Help {
    static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");

    public static HelpSet getHelpSet(Interview i) {
        if (i == null) {
            return null;
        }
        return (HelpSet)i.getHelpSet();
    }

    public static HelpID getHelpID(Question q) {
        if (q == null) {
            return null;
        }
        Object id = q.getHelpID();
        if (id != null && id instanceof HelpID) {
            return (HelpID)id;
        }
        HelpID helpID = Help.getID(q.getInterview(), q.getKey());
        if (helpID != null) {
            q.setHelpID(helpID);
        }
        return helpID;
    }

    private static HelpID getID(Interview i, String key) {
        Map<String, URL> m;
        HelpID helpId = null;
        if (i.getParent() != null) {
            helpId = Help.getID(i.getParent(), key);
        }
        if (helpId != null) {
            return helpId;
        }
        HelpSet hs = Help.getHelpSet(i);
        if (hs != null && (m = hs.getLocalMap()) != null) {
            helpId = HelpID.create(key, hs);
            return helpId;
        }
        return null;
    }

    public static HelpSet[] getAdditionalDocs(TestSuite ts) throws Fault {
        HelpSet[] additionalDocs = null;
        String[] names = ts.getAdditionalDocNames();
        if (names == null) {
            additionalDocs = new HelpSet[]{};
        } else {
            HelpSet[] docs = new HelpSet[names.length];
            ClassLoader loader = ts.getClassLoader();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                URL u = HelpSet.findHelpSet(loader, name);
                if (u == null) {
                    throw new Fault(i18n, "ts.cantFindDoc", name);
                }
                docs[i] = new HelpSet(loader, u);
            }
            additionalDocs = docs;
        }
        return additionalDocs;
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        public Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        public Fault(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

