/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.TypeAnnotationUtils;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class TypeAnnotationData
extends AnnotationData {
    private TypeAnnotationUtils.TargetInfo target_info = null;
    private ArrayList<TypeAnnotationUtils.TypePathEntry> target_path;
    private static TTVis TT_Visitor = new TTVis();

    public TypeAnnotationData(boolean invisible, ClassData cls) {
        super(invisible, cls);
        this.visAnnotToken = "@T+";
        this.invAnnotToken = "@T-";
        this.dataName = "TypeAnnotationData";
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        super.read(in);
        byte tt = (byte)in.readUnsignedByte();
        Integer ttInt = new Integer(tt);
        TypeAnnotationUtils.TargetType ttype = TypeAnnotationUtils.targetTypeEnum(ttInt);
        if (ttype == null) {
            throw new IOException("Bad target type: " + tt + " in TypeAnnotationData");
        }
        TT_Visitor.init(in);
        TT_Visitor.visitExcept(ttype);
        this.target_info = TT_Visitor.getTargetInfo();
        int len = in.readUnsignedShort();
        this.target_path = new ArrayList(len);
        TraceUtils.traceln("    --------- [TypeAnnotationData.read]: Reading Location (length = " + len + ").");
        TraceUtils.trace("    --------- [TypeAnnotationData.read]: [ ");
        for (int i = 0; i < len; ++i) {
            int pathType = in.readUnsignedByte();
            String pk = TypeAnnotationUtils.getPathKind(pathType).parsekey();
            char pathArgIndex = (char)in.readUnsignedByte();
            this.target_path.add(new TypeAnnotationUtils.TypePathEntry(pathType, pathArgIndex));
            TraceUtils.trace(" " + pk + "(" + pathType + "," + pathArgIndex + "), ");
        }
        TraceUtils.traceln("] ");
    }

    @Override
    protected void printBody(PrintWriter out, String tab) {
        out.print(" {");
        super.printBody(out, tab);
        this.target_info.print(out, tab);
        this.printPath(out, tab);
        out.print("}");
    }

    protected void printPath(PrintWriter out, String tab) {
        out.print(" {");
        boolean first = true;
        for (TypeAnnotationUtils.TypePathEntry tpe : this.target_path) {
            if (!first) {
                out.print(", ");
            }
            first = false;
            out.print(tpe.toString());
        }
        this.target_info.print(out, tab);
        this.printPath(out, tab);
        out.print("}");
    }

    @Override
    protected void _toString(StringBuilder sb) {
        sb.append(this.target_info.toString());
    }

    private static class TTVis
    extends TypeAnnotationUtils.TypeAnnotationTargetVisitor {
        private TypeAnnotationUtils.TargetInfo ti = null;
        private IOException IOProb = null;
        private DataInputStream in;

        public void init(DataInputStream in) {
            this.in = in;
        }

        public int scanByteVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedByte();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public int scanShortVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedShort();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public int scanIntVal() {
            int val = 0;
            try {
                val = this.in.readInt();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public void visitExcept(TypeAnnotationUtils.TargetType tt) throws IOException {
            this.IOProb = null;
            this.ti = null;
            TraceUtils.traceln("                      Target Type: " + tt.parseKey());
            this.visit(tt);
            if (this.IOProb != null) {
                throw this.IOProb;
            }
        }

        public TypeAnnotationUtils.TargetInfo getTargetInfo() {
            return this.ti;
        }

        private boolean error() {
            return this.IOProb != null;
        }

        @Override
        public void visit_type_param_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      Type Param Target: ");
            int byteval = this.scanByteVal();
            TraceUtils.traceln("{ param_index: " + byteval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.typeparam_target(tt, byteval);
            }
        }

        @Override
        public void visit_supertype_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      SuperType Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ type_index: " + shortval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.supertype_target(tt, shortval);
            }
        }

        @Override
        public void visit_typeparam_bound_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      TypeParam Bound Target: ");
            int byteval1 = this.scanByteVal();
            if (this.error()) {
                return;
            }
            int byteval2 = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TraceUtils.traceln("{ param_index: " + byteval1 + " bound_index: " + byteval2 + "}");
            this.ti = new TypeAnnotationUtils.typeparam_bound_target(tt, byteval1, byteval2);
        }

        @Override
        public void visit_empty_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.traceln("                      Empty Target: ");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.empty_target(tt);
            }
        }

        @Override
        public void visit_methodformalparam_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      MethodFormalParam Target: ");
            int byteval = this.scanByteVal();
            TraceUtils.traceln("{ param_index: " + byteval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.methodformalparam_target(tt, byteval);
            }
        }

        @Override
        public void visit_throws_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      Throws Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ exception_index: " + shortval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.throws_target(tt, shortval);
            }
        }

        @Override
        public void visit_localvar_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.traceln("                      LocalVar Target: ");
            int tblsize = this.scanShortVal();
            if (this.error()) {
                return;
            }
            TypeAnnotationUtils.localvar_target locvartab = new TypeAnnotationUtils.localvar_target(tt, tblsize);
            this.ti = locvartab;
            for (int i = 0; i < tblsize; ++i) {
                int shortval1 = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int shortval2 = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int shortval3 = this.scanShortVal();
                TraceUtils.trace("                         LocalVar[" + i + "]: ");
                TraceUtils.traceln("{ startPC: " + shortval1 + ", length: " + shortval2 + ", CPX: " + shortval3 + "}");
                locvartab.addEntry(shortval1, shortval2, shortval3);
            }
        }

        @Override
        public void visit_catch_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      Catch Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ catch_index: " + shortval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.catch_target(tt, shortval);
            }
        }

        @Override
        public void visit_offset_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      Offset Target: ");
            int shortval = this.scanShortVal();
            TraceUtils.traceln("{ offset_index: " + shortval + "}");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.offset_target(tt, shortval);
            }
        }

        @Override
        public void visit_typearg_target(TypeAnnotationUtils.TargetType tt) {
            TraceUtils.trace("                      TypeArg Target: ");
            int shortval = this.scanShortVal();
            if (this.error()) {
                return;
            }
            int byteval = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TraceUtils.traceln("{ offset: " + shortval + " type_index: " + byteval + "}");
            this.ti = new TypeAnnotationUtils.typearg_target(tt, shortval, byteval);
        }
    }
}

