/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.TraceUtils;

class StackMapData {
    static int prevFramePC = 0;
    boolean isStackMapTable = false;
    Tables.StackMapFrameType stackFrameType = null;
    int start_pc;
    int[] lockMap;
    int[] stackMap;

    public StackMapData() {
    }

    public StackMapData(CodeData code, DataInputStream in) throws IOException {
        this.start_pc = in.readUnsignedShort();
        TraceUtils.trace("      stack_map_entry:pc=" + this.start_pc);
        TraceUtils.trace(" numloc=");
        this.lockMap = this.readMap(code, in);
        TraceUtils.trace(" numstack=");
        this.stackMap = this.readMap(code, in);
        TraceUtils.traceln("");
    }

    public StackMapData(CodeData code, DataInputStream in, boolean isStackMapTable) throws IOException {
        this.isStackMapTable = isStackMapTable;
        int ft_val = in.readUnsignedByte();
        Tables.StackMapFrameType frame_type = Tables.stackMapFrameType(ft_val);
        int offset = 0;
        switch (frame_type) {
            case SAME_FRAME: {
                TraceUtils.trace("      same_frame=" + ft_val);
                TraceUtils.traceln("");
                offset = ft_val;
                break;
            }
            case SAME_FRAME_EX: {
                TraceUtils.trace("      same_frame_extended=" + ft_val);
                TraceUtils.traceln("");
                offset = in.readUnsignedShort();
                TraceUtils.trace(" offset=" + offset);
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                TraceUtils.trace("      same_locals_1_stack_item_frame=" + ft_val);
                offset = ft_val - 64;
                TraceUtils.trace(" offset=" + offset);
                TraceUtils.trace(" numstack=");
                this.stackMap = this.readMapElements(code, in, 1);
                TraceUtils.traceln("");
                break;
            }
            case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                TraceUtils.trace("      same_locals_1_stack_item_frame_extended=" + ft_val);
                offset = in.readUnsignedShort();
                TraceUtils.trace(" offset=" + offset);
                TraceUtils.trace(" numstack=");
                this.stackMap = this.readMapElements(code, in, 1);
                TraceUtils.traceln("");
                break;
            }
            case CHOP_1_FRAME: 
            case CHOP_2_FRAME: 
            case CHOP_3_FRAME: {
                TraceUtils.trace("      chop_frame=" + ft_val);
                TraceUtils.traceln("");
                offset = in.readUnsignedShort();
                TraceUtils.trace(" offset=" + offset);
                break;
            }
            case APPEND_FRAME: {
                TraceUtils.trace("      append_frame=" + ft_val);
                offset = in.readUnsignedShort();
                TraceUtils.trace(" offset=" + offset);
                TraceUtils.trace(" numloc=");
                this.lockMap = this.readMapElements(code, in, ft_val - 251);
                TraceUtils.traceln("");
                break;
            }
            case FULL_FRAME: {
                TraceUtils.trace("      full_frame=" + ft_val);
                offset = in.readUnsignedShort();
                TraceUtils.trace(" offset=" + offset);
                TraceUtils.trace(" numloc=");
                this.lockMap = this.readMap(code, in);
                TraceUtils.trace(" numstack=");
                this.stackMap = this.readMap(code, in);
                TraceUtils.traceln("");
                break;
            }
            default: {
                TraceUtils.trace("incorrect frame_type argument");
            }
        }
        this.stackFrameType = frame_type;
        prevFramePC = this.start_pc = prevFramePC == 0 ? offset : prevFramePC + offset + 1;
    }

    private int[] readMap(CodeData code, DataInputStream in) throws IOException {
        int num = in.readUnsignedShort();
        TraceUtils.trace("" + num);
        return this.readMapElements(code, in, num);
    }

    private int[] readMapElements(CodeData code, DataInputStream in, int num) throws IOException {
        int[] map = new int[num];
        for (int k = 0; k < num; ++k) {
            int mt_val = 0;
            try {
                mt_val = in.readUnsignedByte();
            }
            catch (EOFException eofe) {
                TraceUtils.traceln("");
                throw eofe;
            }
            Tables.StackMapType maptype = Tables.stackMapType(mt_val, null);
            switch (maptype) {
                case ITEM_Object: {
                    mt_val |= in.readUnsignedShort() << 8;
                    break;
                }
                case ITEM_NewObject: {
                    int pc = in.readUnsignedShort();
                    code.get_iAtt((int)pc).referred = true;
                    mt_val |= pc << 8;
                    break;
                }
            }
            map[k] = mt_val;
            TraceUtils.trace(" " + HexUtils.toHex(mt_val));
        }
        return map;
    }
}

