/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotElem;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.ParameterAnnotationData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class MethodData
extends MemberData {
    protected int name_cpx;
    protected int sig_cpx;
    private CodeData code;
    private int[] exc_table = null;
    protected String lP;
    public static final String initialTab = "";
    protected ArrayList<ParamNameData> paramNames;
    protected ParameterAnnotationData visibleParameterAnnotations;
    protected ParameterAnnotationData invisibleParameterAnnotations;
    protected AnnotElem.AnnotValue defaultAnnotation;

    public MethodData(ClassData cls) {
        this.init(cls);
        this.memberType = "MethodData";
        this.lP = this.options.contains(Options.PR.LABS) ? "L" : initialTab;
        this.paramNames = null;
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        boolean handled = true;
        switch (attrtag) {
            case ATT_Code: {
                this.code = new CodeData(this);
                this.code.read(in, attrlen);
                break;
            }
            case ATT_Exceptions: {
                this.readExceptions(in);
                break;
            }
            case ATT_MethodParameters: {
                this.readMethodParameters(in);
                break;
            }
            case ATT_RuntimeVisibleParameterAnnotations: 
            case ATT_RuntimeInvisibleParameterAnnotations: {
                boolean invisible1 = attrtag == Tables.AttrTag.ATT_RuntimeInvisibleParameterAnnotations;
                ParameterAnnotationData pannots = new ParameterAnnotationData(this.cls, invisible1);
                pannots.read(in);
                if (invisible1) {
                    this.invisibleParameterAnnotations = pannots;
                    break;
                }
                this.visibleParameterAnnotations = pannots;
                break;
            }
            case ATT_AnnotationDefault: {
                this.defaultAnnotation = AnnotElem.readValue(in, this.cls, false);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.sig_cpx = in.readUnsignedShort();
        TraceUtils.traceln("      MethodData: {modifiers}: " + Modifiers.toString(this.access, Tables.CF_Context.CTX_METHOD));
        TraceUtils.traceln("      MethodData: name[" + this.name_cpx + "]=" + this.cls.pool.getString(this.name_cpx) + " sig[" + this.sig_cpx + "]=" + this.cls.pool.getString(this.sig_cpx));
        this.readAttributes(in);
    }

    private void readExceptions(DataInputStream in) throws IOException {
        int exc_table_len = in.readUnsignedShort();
        TraceUtils.traceln("        ExceptionsAttr[" + exc_table_len + "]");
        this.exc_table = new int[exc_table_len];
        for (int l = 0; l < exc_table_len; ++l) {
            short exc = in.readShort();
            TraceUtils.traceln("             throws:#" + exc);
            this.exc_table[l] = exc;
        }
    }

    private void readMethodParameters(DataInputStream in) throws IOException {
        int num_params = in.readUnsignedByte();
        TraceUtils.traceln("        MethodParametersAttr[" + num_params + "]");
        this.paramNames = new ArrayList(num_params);
        for (int l = 0; l < num_params; ++l) {
            short pname_cpx = (short)in.readUnsignedShort();
            int paccess = in.readUnsignedShort();
            TraceUtils.traceln("            P[" + l + "] ={ name[" + pname_cpx + "]: " + this.cls.pool.getString(pname_cpx) + " modifiers [" + paccess + "]: " + Modifiers.toString(paccess, Tables.CF_Context.CTX_METHOD) + "}");
            this.paramNames.add(l, new ParamNameData(pname_cpx, paccess));
        }
    }

    public void printPAnnotations() throws IOException {
        int visSize = 0;
        int invisSize = 0;
        int pNumSize = 0;
        if (this.visibleParameterAnnotations != null) {
            visSize = this.visibleParameterAnnotations.numParams();
        }
        if (this.invisibleParameterAnnotations != null) {
            invisSize = this.invisibleParameterAnnotations.numParams();
        }
        if (this.paramNames != null) {
            pNumSize = this.paramNames.size();
        }
        int maxParams = pNumSize > invisSize ? pNumSize : invisSize;
        maxParams = visSize > maxParams ? visSize : maxParams;
        for (int paramNum = 0; paramNum < maxParams; ++paramNum) {
            boolean nullAnnots;
            ArrayList<AnnotationData> visAnnots = null;
            if (this.visibleParameterAnnotations != null && paramNum < visSize) {
                visAnnots = this.visibleParameterAnnotations.get(paramNum);
            }
            ArrayList<AnnotationData> invisAnnots = null;
            if (this.invisibleParameterAnnotations != null && paramNum < invisSize) {
                invisAnnots = this.invisibleParameterAnnotations.get(paramNum);
            }
            ParamNameData pname = this.paramNames == null ? null : this.paramNames.get(paramNum);
            boolean bl = nullAnnots = visAnnots == null && invisAnnots == null;
            if (pname != null && pname.name_cpx == 0) {
                pname = null;
            }
            if (pname == null && nullAnnots) continue;
            this.out.print("\t" + paramNum + ": ");
            boolean firstTime = true;
            if (pname != null) {
                this.out.print(JasmTokens.Token.PARAM_NAME.parsekey());
                this.out.print(JasmTokens.Token.LBRACE.parsekey());
                this.out.print(this.cls.pool.getString(pname.name_cpx));
                this.out.print(" ");
                this.out.print(Modifiers.toString(pname.access, Tables.CF_Context.CTX_METHOD));
                this.out.print(JasmTokens.Token.RBRACE.parsekey());
                this.out.print(" ");
            }
            if (visAnnots != null) {
                for (AnnotationData annot : visAnnots) {
                    if (!firstTime) {
                        this.out.print("\t   ");
                    }
                    annot.print(this.out, initialTab);
                    firstTime = false;
                }
            }
            if (invisAnnots != null) {
                for (AnnotationData annot : invisAnnots) {
                    if (!firstTime) {
                        this.out.print("\t   ");
                    }
                    annot.print(this.out, initialTab);
                    firstTime = false;
                }
            }
            if (pname == null && nullAnnots) continue;
            this.out.println(initialTab);
        }
    }

    public void print(boolean skipBlankLine) throws IOException {
        if (this.visibleAnnotations != null) {
            this.out.println();
            for (AnnotationData visad : this.visibleAnnotations) {
                visad.print(this.out, initialTab);
                this.out.println();
                skipBlankLine = true;
            }
        }
        if (this.invisibleAnnotations != null) {
            this.out.println();
            for (AnnotationData invisad : this.invisibleAnnotations) {
                invisad.print(this.out, initialTab);
                this.out.println();
                skipBlankLine = true;
            }
        }
        if (this.visibleTypeAnnotations != null) {
            this.out.println();
            for (AnnotationData visad : this.visibleTypeAnnotations) {
                visad.print(this.out, initialTab);
                this.out.println();
                skipBlankLine = true;
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            this.out.println();
            for (AnnotationData invisad : this.invisibleTypeAnnotations) {
                invisad.print(this.out, initialTab);
                this.out.println();
                skipBlankLine = true;
            }
        }
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        if (!skipBlankLine) {
            this.out.println();
        }
        this.out.print(Modifiers.accessString(this.access, Tables.CF_Context.CTX_METHOD));
        if (this.isSynthetic) {
            this.out.print(JasmTokens.Token.SYNTHETIC.parsekey() + " ");
        }
        if (this.isDeprecated) {
            this.out.print(JasmTokens.Token.DEPRECATED.parsekey() + " ");
        }
        this.out.print(JasmTokens.Token.METHODREF.parsekey() + " ");
        if (pr_cpx) {
            this.out.print("#" + this.name_cpx + ":#" + this.sig_cpx);
            this.out.print("\t // ");
            this.out.println(this.cls.pool.getName(this.name_cpx) + ":" + this.cls.pool.getName(this.sig_cpx));
        } else {
            this.out.print(this.cls.pool.getName(this.name_cpx) + ":" + this.cls.pool.getName(this.sig_cpx));
        }
        if (this.defaultAnnotation != null) {
            this.out.print(" default { ");
            this.defaultAnnotation.print(this.out, initialTab);
            this.out.print(" } ");
        }
        this.printExceptionTable();
        if (this.code == null) {
            this.out.print(";");
            if (pr_cpx) {
                this.out.print("\t // ");
                this.out.print(this.cls.pool.getName(this.name_cpx) + ":" + this.cls.pool.getName(this.sig_cpx));
            }
            this.out.println(initialTab);
        } else {
            this.code.print();
        }
    }

    private void printExceptionTable() {
        if (this.exc_table != null) {
            this.out.print("\n\tthrows ");
            int len = this.exc_table.length;
            for (int exceptNum = 0; exceptNum < len; ++exceptNum) {
                this.out.print(this.cls.pool.getClassName(this.exc_table[exceptNum]));
                if (exceptNum >= len - 1) continue;
                this.out.print(", ");
            }
        }
    }

    class ParamNameData {
        public int access;
        public int name_cpx;

        public ParamNameData(int name, int access) {
            this.access = access;
            this.name_cpx = name;
        }
    }
}

