/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.TraceUtils;
import org.openjdk.asmtools.jdis.TypeAnnotationData;

public class MemberData {
    protected int access;
    protected boolean isSynthetic = false;
    protected boolean isDeprecated = false;
    protected ArrayList<AnnotationData> visibleAnnotations;
    protected ArrayList<AnnotationData> invisibleAnnotations;
    protected ArrayList<TypeAnnotationData> visibleTypeAnnotations;
    protected ArrayList<TypeAnnotationData> invisibleTypeAnnotations;
    protected ArrayList<AttrData> attrs;
    protected Options options = Options.OptionObject();
    protected ClassData cls;
    protected PrintWriter out;
    protected String memberType = "";

    public void init(ClassData cls) {
        this.out = cls.out;
        this.cls = cls;
        this.options = cls.options;
    }

    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        return false;
    }

    protected void readAttributes(DataInputStream in) throws IOException {
        int natt = in.readUnsignedShort();
        TraceUtils.traceln("natt=" + natt);
        this.attrs = new ArrayList(natt);
        TraceUtils.traceln(this.memberType + " - Attributes: " + natt);
        block6: for (int k = 0; k < natt; ++k) {
            int name_cpx = in.readUnsignedShort();
            AttrData attr = new AttrData(this.cls);
            this.attrs.add(attr);
            String attr_name = this.cls.pool.getString(name_cpx);
            TraceUtils.traceln("   " + this.memberType + ": #" + k + " name[" + name_cpx + "]=" + attr_name);
            Tables.AttrTag tag = Tables.attrtag(attr_name);
            int attrlen = in.readInt();
            switch (tag) {
                case ATT_Synthetic: {
                    if (attrlen != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isSynthetic = true;
                    continue block6;
                }
                case ATT_Deprecated: {
                    if (attrlen != 0) {
                        throw new ClassFormatError("invalid Deprecated attr length");
                    }
                    this.isDeprecated = true;
                    continue block6;
                }
                case ATT_RuntimeVisibleAnnotations: 
                case ATT_RuntimeInvisibleAnnotations: {
                    int cnt = in.readShort();
                    ArrayList<AnnotationData> annots = new ArrayList<AnnotationData>(cnt);
                    boolean invisible = tag == Tables.AttrTag.ATT_RuntimeInvisibleAnnotations;
                    for (int i = 0; i < cnt; ++i) {
                        TraceUtils.traceln("      AnnotationData: #" + i);
                        AnnotationData annot = new AnnotationData(invisible, this.cls);
                        annot.read(in);
                        annots.add(annot);
                    }
                    if (invisible) {
                        this.invisibleAnnotations = annots;
                        continue block6;
                    }
                    this.visibleAnnotations = annots;
                    continue block6;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    int tcnt = in.readShort();
                    ArrayList<TypeAnnotationData> tannots = new ArrayList<TypeAnnotationData>(tcnt);
                    boolean tinvisible = tag == Tables.AttrTag.ATT_RuntimeInvisibleTypeAnnotations;
                    for (int tindex = 0; tindex < tcnt; ++tindex) {
                        TraceUtils.traceln("      TypeAnnotationData: #" + tindex);
                        TypeAnnotationData tannot = new TypeAnnotationData(tinvisible, this.cls);
                        tannot.read(in);
                        tannots.add(tannot);
                    }
                    if (tinvisible) {
                        this.invisibleTypeAnnotations = tannots;
                        continue block6;
                    }
                    this.visibleTypeAnnotations = tannots;
                    continue block6;
                }
                default: {
                    boolean handled = this.handleAttributes(in, tag, attrlen);
                    if (handled) continue block6;
                    attr.read(name_cpx, attrlen, in);
                }
            }
        }
    }
}

