/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.uEscWriter;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main {
    private Options options = Options.OptionObject();
    public static String programName;
    PrintWriter out;
    boolean DebugFlag = false;
    private int bytelimit = 0;
    public static final I18NResourceBundle i18n;

    public Main(PrintWriter out, String program) {
        this.out = out;
        programName = program;
    }

    public void error(String msg) {
        System.err.println(programName + ": " + msg);
    }

    public void usage() {
        this.error(i18n.getString("jdis.usage"));
        this.error(i18n.getString("jdis.opt.g"));
        this.error(i18n.getString("jdis.opt.sl"));
        this.error(i18n.getString("jdis.opt.hx"));
        this.error(i18n.getString("jdis.opt.v"));
        this.error(i18n.getString("jdis.opt.version"));
    }

    public synchronized boolean disasm(String[] argv) {
        ArrayList<String> vj = new ArrayList<String>();
        block18: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    this.options.set(Options.PR.DEBUG);
                    continue block18;
                }
                case "-v": {
                    this.options.setCodeOptions();
                    continue block18;
                }
                case "-sl": {
                    this.options.set(Options.PR.SRC);
                    continue block18;
                }
                case "-hx": {
                    this.options.set(Options.PR.HEX);
                    continue block18;
                }
                case "-version": {
                    this.out.println(ProductInfo.FULL_VERSION);
                    continue block18;
                }
                default: {
                    if (arg.startsWith("-")) {
                        this.error(i18n.getString("jdis.error.invalid_option", (Object)arg));
                        this.usage();
                        return false;
                    }
                    vj.add(arg);
                }
            }
        }
        if (vj.isEmpty()) {
            this.usage();
            return false;
        }
        for (String inpname : vj) {
            if (inpname == null) continue;
            try {
                ClassData cc = new ClassData(this.out);
                cc.read(new DataInputStream(new FileInputStream(inpname)));
                cc.print();
                continue;
            }
            catch (FileNotFoundException ee) {
                this.error(i18n.getString("jdis.error.cannot_read", (Object)inpname));
            }
            catch (Error ee) {
                if (this.options.contains(Options.PR.DEBUG)) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdis.error.fatal_error", (Object)inpname));
            }
            catch (Exception ee) {
                if (this.options.contains(Options.PR.DEBUG)) {
                    ee.printStackTrace();
                }
                this.error(i18n.getString("jdis.error.fatal_exception", (Object)inpname));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        Main disassembler = new Main(new PrintWriter(new uEscWriter(System.out)), "jdis");
        boolean result = disassembler.disasm(argv);
        System.exit(result ? 0 : 1);
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
    }
}

