/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.TraceUtils;

public class FieldData
extends MemberData {
    protected int name_cpx;
    protected int sig_cpx;
    protected int value_cpx = 0;
    public static final String initialTab = "";

    public FieldData(ClassData cls) {
        this.init(cls);
        this.memberType = "FieldData";
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        boolean handled = true;
        switch (attrtag) {
            case ATT_ConstantValue: {
                if (attrlen != 2) {
                    throw new ClassFormatError("invalid ConstantValue attr length");
                }
                this.value_cpx = in.readUnsignedShort();
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.sig_cpx = in.readUnsignedShort();
        TraceUtils.traceln("      FieldData: name[" + this.name_cpx + "]=" + this.cls.pool.getString(this.name_cpx) + " sig[" + this.sig_cpx + "]=" + this.cls.pool.getString(this.sig_cpx));
        this.readAttributes(in);
    }

    public void print() throws IOException {
        if (this.visibleAnnotations != null) {
            this.out.println();
            for (AnnotationData visad : this.visibleAnnotations) {
                visad.print(this.out, initialTab);
            }
        }
        if (this.invisibleAnnotations != null) {
            this.out.println();
            for (AnnotationData invisad : this.invisibleAnnotations) {
                invisad.print(this.out, initialTab);
            }
        }
        if (this.visibleTypeAnnotations != null) {
            this.out.println();
            for (AnnotationData visad : this.visibleTypeAnnotations) {
                visad.print(this.out, initialTab);
                this.out.println();
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            this.out.println();
            for (AnnotationData invisad : this.invisibleTypeAnnotations) {
                invisad.print(this.out, initialTab);
                this.out.println();
            }
        }
        boolean pr_cpx = this.options.contains(Options.PR.CPX);
        this.out.print(Modifiers.accessString(this.access, Tables.CF_Context.CTX_FIELD));
        if (this.isSynthetic) {
            this.out.print("synthetic ");
        }
        if (this.isDeprecated) {
            this.out.print("deprecated ");
        }
        this.out.print("Field ");
        if (pr_cpx) {
            this.out.print("#" + this.name_cpx + ":#" + this.sig_cpx);
        } else {
            this.out.print(this.cls.pool.getName(this.name_cpx) + ":" + this.cls.pool.getName(this.sig_cpx));
        }
        if (this.value_cpx != 0) {
            this.out.print("\t= ");
            this.cls.pool.PrintConstant(this.cls.out, this.value_cpx);
        }
        if (pr_cpx) {
            this.out.println(";\t // " + this.cls.pool.getName(this.name_cpx) + ":" + this.cls.pool.getName(this.sig_cpx));
        } else {
            this.out.println(";");
        }
    }
}

