/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.FieldData;
import org.openjdk.asmtools.jdis.InnerClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.ModuleData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.TextLines;
import org.openjdk.asmtools.jdis.TraceUtils;

public class ClassData
extends MemberData {
    protected int minor_version;
    protected int major_version;
    protected int this_cpx;
    protected int super_cpx;
    protected int source_cpx = 0;
    protected ConstantPool pool;
    protected int[] interfaces;
    protected ArrayList<FieldData> fields;
    protected ArrayList<MethodData> methods;
    protected ArrayList<InnerClassData> innerClasses;
    protected ArrayList<BootstrapMethodData> bootstrapMethods;
    protected ModuleData moduleData;
    protected PrintWriter out;
    protected String pkgPrefix = "";
    private int pkgPrefixLen = 0;
    private int length;
    private TextLines source = null;
    private static final String initialTab = "";

    public ClassData(PrintWriter out) {
        this.out = out;
        this.init(this);
        this.memberType = "ClassData";
        TraceUtils.traceln("printOptions=" + this.options.toString());
        this.pool = new ConstantPool(this);
    }

    public void read(File in) throws IOException {
        this.read(new DataInputStream(new FileInputStream(in)));
    }

    public void read(String in) throws IOException {
        this.read(new DataInputStream(new FileInputStream(in)));
    }

    protected void readFields(DataInputStream in) throws IOException {
        int nfields = in.readUnsignedShort();
        TraceUtils.traceln("nfields=" + nfields);
        this.fields = new ArrayList(nfields);
        for (int k = 0; k < nfields; ++k) {
            FieldData field = new FieldData(this);
            TraceUtils.traceln("  FieldData: #" + k);
            field.read(in);
            this.fields.add(field);
        }
    }

    protected void readMethods(DataInputStream in) throws IOException {
        int nmethods = in.readUnsignedShort();
        TraceUtils.traceln("nmethods=" + nmethods);
        this.methods = new ArrayList(nmethods);
        for (int k = 0; k < nmethods; ++k) {
            MethodData method = new MethodData(this);
            TraceUtils.traceln("  MethodData: #" + k);
            method.read(in);
            this.methods.add(method);
        }
    }

    protected void readInterfaces(DataInputStream in) throws IOException {
        int numinterfaces = in.readUnsignedShort();
        TraceUtils.traceln("numinterfaces=" + numinterfaces);
        this.interfaces = new int[numinterfaces];
        for (int i = 0; i < numinterfaces; ++i) {
            short intrf_cpx = in.readShort();
            TraceUtils.traceln("  intrf_cpx[" + i + "]=" + intrf_cpx);
            this.interfaces[i] = intrf_cpx;
        }
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, Tables.AttrTag attrtag, int attrlen) throws IOException {
        boolean handled = true;
        switch (attrtag) {
            case ATT_SourceFile: {
                if (attrlen != 2) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.source_cpx = in.readUnsignedShort();
                break;
            }
            case ATT_InnerClasses: {
                int num1 = in.readUnsignedShort();
                if (2 + num1 * 8 != attrlen) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.innerClasses = new ArrayList(num1);
                for (int j = 0; j < num1; ++j) {
                    InnerClassData innerClass = new InnerClassData(this);
                    innerClass.read(in);
                    this.innerClasses.add(innerClass);
                }
                break;
            }
            case ATT_BootstrapMethods: {
                int num2 = in.readUnsignedShort();
                this.bootstrapMethods = new ArrayList(num2);
                for (int j = 0; j < num2; ++j) {
                    BootstrapMethodData bsmData = new BootstrapMethodData(this);
                    bsmData.read(in);
                    this.bootstrapMethods.add(bsmData);
                }
                break;
            }
            case ATT_Module: {
                this.moduleData = new ModuleData(this);
                this.moduleData.read(in);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("wrong magic: " + HexUtils.toHex(magic) + ", expected " + HexUtils.toHex(-889275714));
        }
        this.minor_version = in.readShort();
        this.major_version = in.readShort();
        this.pool.read(in);
        this.access = in.readUnsignedShort();
        this.this_cpx = in.readUnsignedShort();
        this.super_cpx = in.readUnsignedShort();
        TraceUtils.traceln("access=" + this.access + " " + Modifiers.accessString(this.access, Tables.CF_Context.CTX_INNERCLASS) + " this_cpx=" + this.this_cpx + " super_cpx=" + this.super_cpx);
        this.readInterfaces(in);
        this.readFields(in);
        this.readMethods(in);
        this.readAttributes(in);
        TraceUtils.traceln(initialTab);
        TraceUtils.traceln("--------------------------------------------------------------------");
        TraceUtils.traceln(initialTab);
    }

    public String getSrcLine(int lnum) {
        String line;
        if (this.source == null) {
            return null;
        }
        try {
            line = this.source.getLine(lnum);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            line = "Line number " + lnum + " is out of bounds";
        }
        return line;
    }

    private <T extends AnnotationData> void printAnnotations(List<T> annotations) {
        if (annotations != null) {
            for (AnnotationData ad : annotations) {
                ad.print(this.out, initialTab);
                this.out.println();
            }
        }
    }

    public void print() throws IOException {
        int l;
        ConstantPool.Constant this_const;
        String className = initialTab;
        if (this.isModuleUnit()) {
            this.printAnnotations(this.visibleAnnotations);
            this.printAnnotations(this.invisibleAnnotations);
        } else {
            className = this.pool.getClassName(this.this_cpx);
            this.pkgPrefixLen = className.lastIndexOf("/") + 1;
            if (className.endsWith("package-info")) {
                this.printAnnotations(this.visibleAnnotations);
                this.printAnnotations(this.invisibleAnnotations);
                this.printAnnotations(this.visibleTypeAnnotations);
                this.printAnnotations(this.invisibleTypeAnnotations);
                if (this.pkgPrefixLen != 0) {
                    this.pkgPrefix = className.substring(0, this.pkgPrefixLen);
                    this.out.print("package  " + this.pkgPrefix.substring(0, this.pkgPrefixLen - 1) + " ");
                    this.out.print("version " + this.major_version + ":" + this.minor_version + ";");
                }
                this.out.println();
                return;
            }
            if (this.pkgPrefixLen != 0) {
                this.pkgPrefix = className.substring(0, this.pkgPrefixLen);
                this.out.println("package  " + this.pkgPrefix.substring(0, this.pkgPrefixLen - 1) + ";");
                className = this.pool.getShortClassName(this.this_cpx, this.pkgPrefix);
            }
            this.out.println();
            this.printAnnotations(this.visibleAnnotations);
            this.printAnnotations(this.invisibleAnnotations);
            this.printAnnotations(this.visibleTypeAnnotations);
            this.printAnnotations(this.invisibleTypeAnnotations);
            if ((this.access & 0x20) != 0) {
                this.out.print("super ");
                this.access &= 0xFFFFFFDF;
            }
        }
        if ((this.access & 0x400) != 0 && (this.access & 0x200) != 0 && !this.options.contains(Options.PR.CPX) && this.this_cpx != 0 && (this_const = this.pool.getConst(this.this_cpx)) != null && this_const.tag == ConstantPool.TAG.CONSTANT_CLASS) {
            this.out.print(Modifiers.accessString(this.access & 0xFFFFFBFF, Tables.CF_Context.CTX_CLASS));
            if (this.isSynthetic) {
                this.out.print("synthetic ");
            }
            if (this.isDeprecated) {
                this.out.print("deprecated ");
            }
            this.out.print(" " + this.pool.getShortClassName(this.this_cpx, this.pkgPrefix));
        } else if (this.isModuleUnit()) {
            this.out.print(this.moduleData.getModuleHeader());
        } else {
            this.out.print(Modifiers.accessString(this.access, Tables.CF_Context.CTX_CLASS));
            if (this.isSynthetic) {
                this.out.print("synthetic ");
            }
            if (this.isDeprecated) {
                this.out.print("deprecated ");
            }
            if (this.options.contains(Options.PR.CPX)) {
                this.out.print("\t#" + this.this_cpx + "; //");
            }
            this.pool.PrintConstant(this.out, this.this_cpx);
        }
        this.out.println();
        if (!this.isModuleUnit() && !this.pool.getClassName(this.super_cpx).equals("java/lang/Object")) {
            this.out.print("\textends ");
            this.pool.printlnClassId(this.out, this.super_cpx);
            this.out.println();
        }
        if ((l = this.interfaces.length) > 0) {
            for (int k = 0; k < l; ++k) {
                if (k == 0) {
                    this.out.print("\timplements ");
                } else {
                    this.out.print("\t\t ");
                }
                boolean printComma = l > 1 && k < l - 1;
                this.pool.printlnClassId(this.out, this.interfaces[k], printComma);
                this.out.println();
            }
        }
        this.out.println("\tversion " + this.major_version + ":" + this.minor_version);
        this.out.println("{");
        if (this.options.contains(Options.PR.SRC) && this.source_cpx != 0) {
            Iterator<Object> source_name = this.pool.getName(this.source_cpx);
            this.out.println("\t// Compiled from " + (String)((Object)source_name));
            try {
                this.source = new TextLines((String)((Object)source_name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.isModuleUnit()) {
            this.out.println();
        }
        if (this.options.contains(Options.PR.CP)) {
            this.pool.print(this.out);
            this.out.println();
        }
        if (!this.isModuleUnit()) {
            if (this.fields != null && !this.fields.isEmpty()) {
                for (FieldData curf : this.fields) {
                    curf.print();
                }
            }
            if (this.methods != null && !this.methods.isEmpty()) {
                for (MethodData curm : this.methods) {
                    boolean skipBlankLine = false;
                    curm.print(skipBlankLine);
                }
                this.out.println();
            }
            if (this.innerClasses != null && !this.innerClasses.isEmpty()) {
                for (InnerClassData icd : this.innerClasses) {
                    icd.print();
                }
                this.out.println();
            }
            if (this.options.contains(Options.PR.CPX) && this.bootstrapMethods != null && !this.bootstrapMethods.isEmpty()) {
                for (BootstrapMethodData bsmdd : this.bootstrapMethods) {
                    bsmdd.print();
                }
                this.out.println();
            }
            this.out.println("} // end Class " + className);
        } else {
            this.moduleData.print();
            this.out.print("} // end Module ");
            this.out.print(this.moduleData.getModuleName());
            if (this.moduleData.getModuleVersion() != null) {
                this.out.print(" @" + this.moduleData.getModuleVersion());
            }
            this.out.println();
        }
        List<IOException> issues = this.getIssues();
        if (!issues.isEmpty()) {
            throw issues.get(0);
        }
    }

    private boolean isModuleUnit() {
        return this.moduleData != null;
    }

    private List<IOException> getIssues() {
        return this.pool.pool.stream().filter(c -> c != null).filter(c -> c.getIssue() != null).map(c -> c.getIssue()).collect(Collectors.toList());
    }
}

