/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jdis.AnnotElem;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.TraceUtils;

public class AnnotationData {
    private boolean invisible = false;
    private int type_cpx = 0;
    private ArrayList<AnnotElem> array = new ArrayList();
    private ClassData cls;
    protected String visAnnotToken = "@+";
    protected String invAnnotToken = "@-";
    protected String dataName = "AnnotationData";

    public AnnotationData(boolean invisible, ClassData cls) {
        this.cls = cls;
        this.invisible = invisible;
    }

    public void read(DataInputStream in) throws IOException {
        this.type_cpx = in.readShort();
        TraceUtils.traceln("             " + this.dataName + ": name[" + this.type_cpx + "]=" + this.cls.pool.getString(this.type_cpx));
        int elemValueLength = in.readShort();
        TraceUtils.traceln("                 " + this.dataName + ": " + this.cls.pool.getString(this.type_cpx) + "num_elems: " + elemValueLength);
        for (int evc = 0; evc < elemValueLength; ++evc) {
            AnnotElem elem = new AnnotElem(this.cls);
            TraceUtils.traceln("                    " + this.dataName + ": " + this.cls.pool.getString(this.type_cpx) + " reading [" + evc + "]");
            elem.read(in, this.invisible);
            this.array.add(elem);
        }
    }

    public void print(PrintWriter out, String tab) {
        this.printHeader(out, tab);
        this.printBody(out, tab);
    }

    protected void printHeader(PrintWriter out, String tab) {
        if (this.invisible) {
            out.print(tab + this.invAnnotToken);
        } else {
            out.print(tab + this.visAnnotToken);
        }
        String annoName = this.cls.pool.getString(this.type_cpx);
        if (annoName.startsWith("L") && annoName.endsWith(";")) {
            annoName = annoName.substring(1, annoName.length() - 1);
        }
        out.print(annoName);
    }

    protected void printBody(PrintWriter out, String tab) {
        out.print(" { ");
        int i = 0;
        for (AnnotElem elem : this.array) {
            elem.print(out, tab);
            if (i++ >= this.array.size() - 1) continue;
            out.print(", ");
        }
        out.print("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String annoName = this.cls.pool.getString(this.type_cpx);
        if (annoName.startsWith("L") && annoName.endsWith(";")) {
            annoName = annoName.substring(1, annoName.length() - 1);
        }
        if (this.invisible) {
            sb.append(this.invAnnotToken);
        } else {
            sb.append(this.visAnnotToken);
        }
        sb.append(annoName);
        sb.append(" { ");
        int i = 0;
        for (AnnotElem elem : this.array) {
            sb.append(elem.toString());
            if (i++ >= this.array.size() - 1) continue;
            sb.append(", ");
        }
        this._toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void _toString(StringBuilder sb) {
    }
}

