/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdec;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.openjdk.asmtools.jdec.ClassData;
import org.openjdk.asmtools.jdis.uEscWriter;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main {
    String program;
    PrintWriter out;
    boolean DebugFlag = false;
    int printFlags = 0;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Main(PrintWriter out, String program) {
        this.out = out;
        this.program = program;
    }

    public void error(String msg) {
        this.out.println(this.program + ": " + msg);
    }

    public void usage() {
        this.out.println(i18n.getString("jdec.usage"));
        this.out.println(i18n.getString("jdec.opt.g"));
        this.out.println(i18n.getString("jdec.opt.version"));
    }

    public synchronized boolean decode(String[] argv) {
        long tm = System.currentTimeMillis();
        ArrayList<String> vargs = new ArrayList<String>();
        ArrayList<String> vj = new ArrayList<String>();
        boolean nowrite = false;
        boolean addOptions = false;
        int i = 0;
        for (String arg : argv) {
            if (arg.equals("-g")) {
                this.printFlags |= 1;
                vargs.add(arg);
            } else if (arg.equals("-v")) {
                this.DebugFlag = true;
                vargs.add(arg);
                this.out.println("arg[" + i + "]=" + argv[i] + "/verbose");
            } else if (arg.equals("-version")) {
                this.out.println(ProductInfo.FULL_VERSION);
            } else {
                if (arg.startsWith("-")) {
                    this.error(i18n.getString("jdec.error.invalid_flag", (Object)arg));
                    this.usage();
                    return false;
                }
                vargs.add(arg);
                vj.add(arg);
            }
            ++i;
        }
        if (vj.isEmpty()) {
            this.usage();
            return false;
        }
        String[] names = new String[]{};
        for (String inpname : names = vj.toArray(names)) {
            try {
                ClassData cc = new ClassData(inpname, this.printFlags, this.out);
                cc.DebugFlag = this.DebugFlag;
                cc.decodeClass();
                continue;
            }
            catch (FileNotFoundException ee) {
                this.error(i18n.getString("jdec.error.cannot_read", (Object)inpname));
            }
            catch (Error ee) {
                ee.printStackTrace();
                this.error(i18n.getString("jdec.error.fatal_error"));
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.error(i18n.getString("jdec.error.fatal_exception"));
            }
            return false;
        }
        return true;
    }

    public static void main(String[] argv) {
        Main decoder = new Main(new PrintWriter(new uEscWriter(System.out)), "jdec");
        System.exit(decoder.decode(argv) ? 0 : 1);
    }
}

