/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.openjdk.asmtools.jasm.Constants;
import org.openjdk.asmtools.jcoder.ErrorMessage;
import org.openjdk.asmtools.jcoder.Main;
import org.openjdk.asmtools.util.I18NResourceBundle;

public class SourceFile
implements Constants {
    public boolean traceFlag = false;
    public boolean debugInfoFlag = false;
    protected static final int OFFSETINC = 1;
    protected static final int LINEINC = 524288;
    File source;
    InputStream in;
    PrintStream out;
    int pos;
    private int chpos;
    private int pushBack = -1;
    public int nerrors;
    public int nwarnings;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);
    String errorFileName;
    ErrorMessage errors;

    public SourceFile(File source, PrintStream out) throws IOException {
        this.source = source;
        this.in = new BufferedInputStream(new FileInputStream(source));
        this.chpos = 524288;
        this.out = out;
        this.errorFileName = source.getPath();
    }

    public String getSource() {
        return this.source.getPath();
    }

    public void closeInp() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.flushErrors();
    }

    public int read() throws IOException {
        this.pos = this.chpos++;
        int c = this.pushBack;
        if (c == -1) {
            c = this.in.read();
        } else {
            this.pushBack = -1;
        }
        switch (c) {
            case -2: {
                return 92;
            }
            case 92: {
                c = this.in.read();
                if (c != 117) {
                    this.pushBack = c == 92 ? -2 : c;
                    return 92;
                }
                ++this.chpos;
                while ((c = this.in.read()) == 117) {
                    ++this.chpos;
                }
                int d = 0;
                int i = 0;
                while (i < 4) {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            d = (d << 4) + c - 48;
                            break;
                        }
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            d = (d << 4) + 10 + c - 97;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            d = (d << 4) + 10 + c - 65;
                            break;
                        }
                        default: {
                            this.error(this.pos, "invalid.escape.char");
                            this.pushBack = c;
                            return d;
                        }
                    }
                    ++i;
                    ++this.chpos;
                    c = this.in.read();
                }
                this.pushBack = c;
                return d;
            }
            case 10: {
                this.chpos += 524288;
                return 10;
            }
            case 13: {
                c = this.in.read();
                if (c != 10) {
                    this.pushBack = c;
                } else {
                    ++this.chpos;
                }
                this.chpos += 524288;
                return 10;
            }
        }
        return c;
    }

    public int lineNumber(int pos) {
        return pos >>> 19;
    }

    public int lineNumber() {
        return this.pos >>> 19;
    }

    String errorString(String err, Object arg1, Object arg2, Object arg3) {
        String str = null;
        if (!err.startsWith("warn.")) {
            err = "err." + err;
        }
        if ((str = i18n.getString(err)) == null) {
            return "error message '" + err + "' not found";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < str.length()) {
                switch (str.charAt(++i)) {
                    case 's': {
                        String arg = arg1.toString();
                        block8: for (int j = 0; j < arg.length(); ++j) {
                            c = arg.charAt(j);
                            switch (c) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    buf.append(c);
                                    continue block8;
                                }
                                default: {
                                    if (c > ' ' && c <= '\u00ff') {
                                        buf.append(c);
                                        continue block8;
                                    }
                                    buf.append('\\');
                                    buf.append('u');
                                    buf.append(Integer.toString(c, 16));
                                }
                            }
                        }
                        arg1 = arg2;
                        arg2 = arg3;
                        break;
                    }
                    case '%': {
                        buf.append('%');
                        break;
                    }
                    default: {
                        buf.append('?');
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    void insertError(int where, String message) {
        ErrorMessage msg = new ErrorMessage(where, message);
        if (this.errors == null) {
            this.errors = msg;
        } else if (this.errors.where > where) {
            msg.next = this.errors;
            this.errors = msg;
        } else {
            ErrorMessage m = this.errors;
            while (m.next != null && m.next.where <= where) {
                m = m.next;
            }
            msg.next = m.next;
            m.next = msg;
        }
    }

    public void flushErrors() {
        if (this.errors == null) {
            return;
        }
        try {
            FileInputStream in = new FileInputStream(this.errorFileName);
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            ErrorMessage msg = this.errors;
            while (msg != null) {
                int j;
                int off;
                int i;
                int ln = msg.where >>> 19;
                for (i = off = msg.where & 0x7FFFF; i > 0 && data[i - 1] != 10 && data[i - 1] != 13; --i) {
                }
                for (j = off; j < data.length && data[j] != 10 && data[j] != 13; ++j) {
                }
                String prefix = this.errorFileName + ":" + ln + ":";
                this.outputln(prefix + " " + msg.message);
                this.outputln(new String(data, i, j - i));
                char[] strdata = new char[off - i + 1];
                for (j = i; j < off; ++j) {
                    strdata[j - i] = data[j] == 9 ? 9 : 32;
                }
                strdata[off - i] = 94;
                this.outputln(new String(strdata));
                msg = msg.next;
            }
        }
        catch (IOException e) {
            this.outputln("I/O exception");
        }
        this.errors = null;
    }

    public void output(String msg) {
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            this.out.write(msg.charAt(i));
        }
    }

    public void outputln(String msg) {
        this.output(msg);
        this.out.write(10);
    }

    public void error(int where, String err, Object arg1, Object arg2, Object arg3) {
        String msg = this.errorString(err, arg1, arg2, arg3);
        if (err.startsWith("warn.")) {
            ++this.nwarnings;
        } else {
            ++this.nerrors;
        }
        this.traceln("error:" + msg);
        this.insertError(where, msg);
    }

    public final void error(int where, String err, Object arg1, Object arg2) {
        this.error(where, err, arg1, arg2, null);
    }

    public final void error(int where, String err, Object arg1) {
        this.error(where, err, arg1, null, null);
    }

    public final void error(int where, String err) {
        this.error(where, err, null, null, null);
    }

    public final void error(String err) {
        this.error(this.pos, err, null, null, null);
    }

    public final void error(String err, Object arg1) {
        this.error(this.pos, err, arg1, null, null);
    }

    public void trace(String message) {
        if (this.traceFlag) {
            this.output(message);
        }
    }

    public void traceln(String message) {
        if (this.traceFlag) {
            this.outputln(message);
        }
    }
}

