/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jcoder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.asmtools.jcoder.Jcoder;
import org.openjdk.asmtools.jcoder.SourceFile;
import org.openjdk.asmtools.util.I18NResourceBundle;
import org.openjdk.asmtools.util.ProductInfo;

public class Main {
    String program;
    PrintStream out;
    int nerrors = 0;
    public static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Main(PrintStream out, String program) {
        this.out = out;
        this.program = program;
    }

    public void error(String msg) {
        ++this.nerrors;
        this.out.println(this.program + ": " + msg);
    }

    public void usage() {
        this.out.println(i18n.getString("jcoder.usage"));
        this.out.println(i18n.getString("jcoder.opt.nowrite"));
        this.out.println(i18n.getString("jcoder.opt.ignore"));
        this.out.println(i18n.getString("jcoder.opt.d"));
        this.out.println(i18n.getString("jcoder.opt.version"));
    }

    public synchronized boolean compile(String[] argv) {
        boolean warns;
        File destDir = null;
        boolean traceFlag = false;
        boolean debugInfoFlag = false;
        long tm = System.currentTimeMillis();
        ArrayList<String> v = new ArrayList<String>();
        boolean nowrite = false;
        boolean ignore = false;
        int nwarnings = 0;
        HashMap<String, String> macros = new HashMap<String, String>();
        macros.put("VERSION", "3;45");
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("-")) {
                v.add(arg);
                continue;
            }
            if (arg.startsWith("-D")) {
                String macro;
                int argLength = arg.length();
                if (argLength == 2) {
                    this.error(i18n.getString("jcoder.error.D_needs_marco"));
                    return false;
                }
                int index = arg.indexOf(61);
                if (index == -1) {
                    this.error(i18n.getString("jcoder.error.D_needs_marco"));
                    return false;
                }
                String macroId = arg.substring(2, index);
                if (argLength == ++index) {
                    this.error(i18n.getString("jcoder.error.D_needs_marco"));
                    return false;
                }
                if (arg.charAt(index) == '\"') {
                    if (argLength == ++index || arg.charAt(argLength - 1) != '\"') {
                        this.error(i18n.getString("jcoder.error.no_closing_quota"));
                        return false;
                    }
                    macro = arg.substring(index, argLength - 1);
                } else {
                    macro = arg.substring(index, argLength);
                }
                macros.put(macroId, macro);
                continue;
            }
            if (arg.equals("-vv")) {
                debugInfoFlag = true;
                traceFlag = true;
                continue;
            }
            if (arg.equals("-v")) {
                traceFlag = true;
                continue;
            }
            if (arg.equals("-nowrite")) {
                nowrite = true;
                continue;
            }
            if (arg.equals("-ignore")) {
                ignore = true;
                continue;
            }
            if (arg.equals("-d")) {
                if (i + 1 == argv.length) {
                    this.error(i18n.getString("jcoder.error.d_requires_argument"));
                    this.usage();
                    return false;
                }
                if ((destDir = new File(argv[++i])).exists()) continue;
                this.error(i18n.getString("jcoder.error.does_not_exist", (Object)destDir));
                return false;
            }
            if (arg.equals("-version")) {
                this.out.println(ProductInfo.FULL_VERSION);
                continue;
            }
            this.error(i18n.getString("jcoder.error.invalid_option", (Object)arg));
            this.usage();
            return false;
        }
        if (v.isEmpty()) {
            this.usage();
            return false;
        }
        try {
            for (String inpname : v) {
                Jcoder p;
                SourceFile env;
                try {
                    env = new SourceFile(new File(inpname), this.out);
                    env.traceFlag = traceFlag;
                    env.debugInfoFlag = debugInfoFlag;
                    p = new Jcoder(env, macros);
                    p.parseFile();
                    env.traceln("END PARSER");
                    env.closeInp();
                }
                catch (FileNotFoundException ex) {
                    this.error(i18n.getString("jcoder.error.cannot_read", (Object)inpname));
                    continue;
                }
                this.nerrors += env.nerrors;
                nwarnings += env.nwarnings;
                if (nowrite || this.nerrors > 0 & !ignore) continue;
                try {
                    env.traceln("WRITE");
                    p.write(destDir);
                }
                catch (FileNotFoundException ex) {
                    this.error(i18n.getString("jcoder.error.cannot_write", (Object)ex.getMessage()));
                }
            }
        }
        catch (Error ee) {
            ee.printStackTrace();
            this.error(i18n.getString("jcoder.error.fatal_error"));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.error(i18n.getString("jcoder.error.fatal_exception"));
        }
        boolean errs = this.nerrors > 0;
        boolean bl = warns = nwarnings > 0;
        if (!errs && !warns) {
            return true;
        }
        this.out.println(errs ? (this.nerrors > 1 ? this.nerrors + " errors" : "1 error") : "" + (errs && warns ? ", " : "") + (warns ? (nwarnings > 1 ? nwarnings + " warnings" : "1 warning") : ""));
        return !errs;
    }

    public static void main(String[] argv) {
        Main compiler = new Main(System.out, "jcoder");
        System.exit(compiler.compile(argv) ? 0 : 1);
    }
}

