/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;

public class TypeAnnotationUtils {
    private static HashMap<String, PathKind> PathTypeHash = new HashMap(3);
    private static HashMap<String, TargetType> TargetTypeHash;
    private static HashMap<Integer, TargetType> TargetTypeList;

    private static void initPathTypes(PathKind pk) {
        PathTypeHash.put(pk.parseKey, pk);
    }

    public static PathKind pathKind(String parseKey) {
        return PathTypeHash.get(parseKey);
    }

    public static PathKind getPathKind(int i) {
        return PathKind.values()[i];
    }

    private static void initTargetTypes(TargetType tt) {
        TargetTypeList.put(tt.value, tt);
        TargetTypeHash.put(tt.parseKey, tt);
    }

    public static TargetType targetType(String parseKey) {
        return TargetTypeHash.get(parseKey);
    }

    public static TargetType targetTypeEnum(Integer typeCode) {
        return TargetTypeList.get(typeCode);
    }

    public static TargetType getTargetType(int tt_index) {
        if (tt_index < 0 || tt_index > 154) {
            return null;
        }
        return TargetTypeList.get(tt_index);
    }

    public static TargetType getTargetType(String tt) {
        TargetType retval = TargetTypeHash.get(tt);
        if (retval.name().equals("UNUSED")) {
            retval = null;
        }
        return retval;
    }

    static {
        for (PathKind pathKind : PathKind.values()) {
            TypeAnnotationUtils.initPathTypes(pathKind);
        }
        TargetTypeHash = new HashMap(36);
        TargetTypeList = new HashMap(36);
        for (Enum enum_ : TargetType.values()) {
            TypeAnnotationUtils.initTargetTypes((TargetType)enum_);
        }
    }

    public static class TypeAnnotationTargetVisitor {
        public final void visit(TargetType tt) {
            switch (tt) {
                case class_type_param: 
                case meth_type_param: {
                    this.visit_type_param_target(tt);
                    break;
                }
                case class_exts_impls: {
                    this.visit_supertype_target(tt);
                    break;
                }
                case class_type_param_bnds: 
                case meth_type_param_bnds: {
                    this.visit_typeparam_bound_target(tt);
                    break;
                }
                case field: 
                case meth_ret_type: 
                case meth_receiver: {
                    this.visit_empty_target(tt);
                    break;
                }
                case meth_formal_param: {
                    this.visit_methodformalparam_target(tt);
                    break;
                }
                case throws_type: {
                    this.visit_throws_target(tt);
                    break;
                }
                case local_var: 
                case resource_var: {
                    this.visit_localvar_target(tt);
                    break;
                }
                case exception_param: {
                    this.visit_catch_target(tt);
                    break;
                }
                case type_test: 
                case obj_creat: 
                case constr_ref_receiver: 
                case meth_ref_receiver: {
                    this.visit_offset_target(tt);
                    break;
                }
                case cast: 
                case constr_invoc_typearg: 
                case meth_invoc_typearg: 
                case constr_ref_typearg: 
                case meth_ref_typearg: {
                    this.visit_typearg_target(tt);
                }
            }
        }

        public void visit_type_param_target(TargetType tt) {
        }

        public void visit_supertype_target(TargetType tt) {
        }

        public void visit_typeparam_bound_target(TargetType tt) {
        }

        public void visit_empty_target(TargetType tt) {
        }

        public void visit_methodformalparam_target(TargetType tt) {
        }

        public void visit_throws_target(TargetType tt) {
        }

        public void visit_localvar_target(TargetType tt) {
        }

        public void visit_catch_target(TargetType tt) {
        }

        public void visit_offset_target(TargetType tt) {
        }

        public void visit_typearg_target(TargetType tt) {
        }
    }

    public static class typearg_target
    extends TargetInfo {
        int offset;
        int typeIndex;

        public typearg_target(TargetType tt, int ofst, int tindx) {
            super(tt);
            this.offset = ofst;
            this.typeIndex = tindx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
            out.writeByte(this.typeIndex);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.offset);
            out.print(" ");
            out.print(this.typeIndex);
        }

        @Override
        public int getLength() {
            return 3 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = typearg_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("offset: ");
            sb.append(this.offset);
            sb.append('\n');
            sb.append(tabStr);
            sb.append("type_index: ");
            sb.append(this.typeIndex);
            sb.append('\n');
        }
    }

    public static class offset_target
    extends TargetInfo {
        int offset;

        public offset_target(TargetType tt, int ofst) {
            super(tt);
            this.offset = ofst;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.offset);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.offset);
        }

        @Override
        public int getLength() {
            return 2 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = offset_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("offset: ");
            sb.append(this.offset);
            sb.append('\n');
        }
    }

    public static class catch_target
    extends TargetInfo {
        int exception_table_index;

        public catch_target(TargetType tt, int indx) {
            super(tt);
            this.exception_table_index = indx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.exception_table_index);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.exception_table_index);
        }

        @Override
        public int getLength() {
            return 2 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = catch_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("exception_table_index: ");
            sb.append(this.exception_table_index);
            sb.append('\n');
        }
    }

    public static class localvar_target
    extends TargetInfo {
        ArrayList<LocalVar_Entry> table = null;

        public localvar_target(TargetType tt, int size) {
            super(tt);
            this.table = new ArrayList(size);
        }

        public void addEntry(int startPC, int length, int cpx) {
            LocalVar_Entry entry = new LocalVar_Entry(startPC, length, cpx);
            this.table.add(entry);
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.table.size());
            for (LocalVar_Entry entry : this.table) {
                entry.write(out);
            }
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            String innerTab = tab + "          ";
            out.println();
            for (LocalVar_Entry entry : this.table) {
                entry._print(out, innerTab);
            }
            out.print(innerTab);
        }

        @Override
        public int getLength() {
            return 2 + 6 * this.table.size() + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr1 = localvar_target.tabString(tabLevel + 1);
            int i = 1;
            for (LocalVar_Entry entry : this.table) {
                sb.append(tabStr1);
                sb.append("[" + i + "]: ");
                sb.append(entry.toString());
                sb.append('\n');
                ++i;
            }
        }

        public static class LocalVar_Entry {
            public int startPC;
            public int length;
            public int cpx;

            public LocalVar_Entry(int st, int len, int index) {
                this.startPC = st;
                this.length = len;
                this.cpx = index;
            }

            void write(CheckedDataOutputStream out) throws IOException {
                out.writeShort(this.startPC);
                out.writeShort(this.length);
                out.writeShort(this.cpx);
            }

            public void _print(PrintWriter out, String tab) {
                out.print(tab + "{");
                out.print(this.startPC);
                out.print(" ");
                out.print(this.length);
                out.print(" ");
                out.print(this.cpx);
                out.println("}");
            }

            public String toString() {
                return new String("startPC: " + this.startPC + "  length: " + this.length + "  cpx: " + this.cpx);
            }
        }
    }

    public static class throws_target
    extends TargetInfo {
        int type_index;

        public throws_target(TargetType tt, int tindex) {
            super(tt);
            this.type_index = tindex;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.type_index);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.type_index);
        }

        @Override
        public int getLength() {
            return 2 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = throws_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("type_index: ");
            sb.append(this.type_index);
            sb.append('\n');
        }
    }

    public static class methodformalparam_target
    extends TargetInfo {
        int index;

        public methodformalparam_target(TargetType tt, int indx) {
            super(tt);
            this.index = indx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.index);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.index);
        }

        @Override
        public int getLength() {
            return 1 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = methodformalparam_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("index: ");
            sb.append(this.index);
            sb.append('\n');
        }
    }

    public static class empty_target
    extends TargetInfo {
        public empty_target(TargetType tt) {
            super(tt);
        }
    }

    public static class typeparam_bound_target
    extends TargetInfo {
        int pindex;
        int bindex;

        public typeparam_bound_target(TargetType tt, int pindx, int bindx) {
            super(tt);
            this.pindex = pindx;
            this.bindex = bindx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.pindex);
            out.writeByte(this.bindex);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.pindex);
            out.print(" ");
            out.print(this.bindex);
        }

        @Override
        public int getLength() {
            return 2 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = typeparam_bound_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("param_index: ");
            sb.append(this.pindex);
            sb.append('\n');
            sb.append(tabStr);
            sb.append("bound_index: ");
            sb.append(this.bindex);
            sb.append('\n');
        }
    }

    public static class supertype_target
    extends TargetInfo {
        int type_index;

        public supertype_target(TargetType tt, int tindex) {
            super(tt);
            this.type_index = tindex;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.type_index);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.type_index);
        }

        @Override
        public int getLength() {
            return 2 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = supertype_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("type_index: ");
            sb.append(this.type_index);
            sb.append('\n');
        }
    }

    public static class typeparam_target
    extends TargetInfo {
        int pindex;

        public typeparam_target(TargetType tt, int indx) {
            super(tt);
            this.pindex = indx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.pindex);
            super.write(out);
        }

        @Override
        public void _print(PrintWriter out, String tab) {
            out.print(" ");
            out.print(this.pindex);
        }

        @Override
        public int getLength() {
            return 1 + super.getLength();
        }

        @Override
        protected void _toString(StringBuilder sb, int tabLevel) {
            String tabStr = typeparam_target.tabString(tabLevel);
            sb.append(tabStr);
            sb.append("param_index: ");
            sb.append(this.pindex);
            sb.append('\n');
        }
    }

    public static class TargetInfo {
        protected TargetType targettype = null;

        public TargetInfo(TargetType tt) {
            this.targettype = tt;
        }

        public TargetType getTargetType() {
            return this.targettype;
        }

        public void print(PrintWriter out, String tab) {
            out.print(tab + " {");
            this.targettype.print(out);
            this._print(out, tab);
            out.print(tab + "}");
        }

        public void _print(PrintWriter out, String tab) {
        }

        public void write(CheckedDataOutputStream out) throws IOException {
        }

        public int getLength() {
            return 0;
        }

        public String toString() {
            return this.toString(0);
        }

        protected void _toString(StringBuilder sb, int tabLevel) {
        }

        public String toString(int tabLevel) {
            StringBuilder sb = new StringBuilder();
            String tabStr = TargetInfo.tabString(tabLevel);
            sb.append(tabStr);
            sb.append(this.targettype.infoKey() + " \n");
            sb.append(tabStr);
            sb.append((Object)((Object)this.targettype) + " \n");
            this._toString(sb, tabLevel);
            return sb.toString();
        }

        protected static String tabString(int tabLevel) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tabLevel; ++i) {
                sb.append('\t');
            }
            return sb.toString();
        }
    }

    public static enum TargetType {
        class_type_param(0, "CLASS_TYPE_PARAMETER", InfoType.TYPEPARAM, "class type parameter"),
        meth_type_param(1, "METHOD_TYPE_PARAMETER", InfoType.TYPEPARAM, "method type parameter"),
        class_exts_impls(16, "CLASS_EXTENDS", InfoType.SUPERTYPE, "class extends/implements"),
        class_type_param_bnds(17, "CLASS_TYPE_PARAMETER_BOUND", InfoType.TYPEPARAM_BOUND, "class type parameter bounds"),
        meth_type_param_bnds(18, "METHOD_TYPE_PARAMETER_BOUND", InfoType.TYPEPARAM_BOUND, "method type parameter bounds"),
        field(19, "FIELD", InfoType.EMPTY, "field"),
        meth_ret_type(20, "METHOD_RETURN", InfoType.EMPTY, "method return type"),
        meth_receiver(21, "METHOD_RECEIVER", InfoType.EMPTY, "method receiver"),
        meth_formal_param(22, "METHOD_FORMAL_PARAMETER", InfoType.METHODPARAM, "method formal parameter type"),
        throws_type(23, "THROWS", InfoType.EXCEPTION, "exception type in throws"),
        local_var(64, "LOCAL_VARIABLE", InfoType.LOCALVAR, "local variable"),
        resource_var(65, "RESOURCE_VARIABLE", InfoType.LOCALVAR, "resource variable"),
        exception_param(66, "EXCEPTION_PARAM", InfoType.CATCH, "exception parameter"),
        type_test(67, "INSTANCEOF", InfoType.OFFSET, "type test (instanceof)"),
        obj_creat(68, "NEW", InfoType.OFFSET, "object creation (new)"),
        constr_ref_receiver(69, "CONSTRUCTOR_REFERENCE_RECEIVER", InfoType.OFFSET, "constructor reference receiver"),
        meth_ref_receiver(70, "METHOD_REFERENCE_RECEIVER", InfoType.OFFSET, "method reference receiver"),
        cast(71, "CAST", InfoType.TYPEARG, "cast"),
        constr_invoc_typearg(72, "CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT", InfoType.TYPEARG, "type argument in constructor call"),
        meth_invoc_typearg(73, "METHOD_INVOCATION_TYPE_ARGUMENT", InfoType.TYPEARG, "type argument in method call"),
        constr_ref_typearg(74, "CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT", InfoType.TYPEARG, "type argument in constructor reference"),
        meth_ref_typearg(75, "METHOD_REFERENCE_TYPE_ARGUMENT", InfoType.TYPEARG, "type argument in method reference");

        public static final int maxTag = 154;
        public static final int maxLen = 36;
        public final int value;
        private final String parseKey;
        private final InfoType infoKey;
        private final String printval;

        private TargetType(int val, String parse, InfoType info, String print) {
            this.value = val;
            this.parseKey = parse;
            this.infoKey = info;
            this.printval = print;
        }

        public String parseKey() {
            return this.parseKey;
        }

        public String infoKey() {
            return this.infoKey.parseKey();
        }

        public InfoType infoType() {
            return this.infoKey;
        }

        public void print(PrintWriter out) {
            out.print(this.parseKey);
        }

        public String toString() {
            return this.parseKey + " (" + this.infoKey() + ") <" + this.printval + "> [" + Integer.toHexString(this.value) + "]";
        }
    }

    public static enum InfoType {
        TYPEPARAM("TYPEPARAM", "TYPEPARAM"),
        SUPERTYPE("SUPERTYPE", "SUPERTYPE"),
        TYPEPARAM_BOUND("TYPEPARAM_BOUND", "TYPEPARAM_BOUND"),
        EMPTY("EMPTY", "EMPTY"),
        METHODPARAM("METHODPARAM", "METHODPARAM"),
        EXCEPTION("EXCEPTION", "EXCEPTION"),
        LOCALVAR("LOCALVAR", "LOCALVAR"),
        CATCH("CATCH", "CATCH"),
        OFFSET("OFFSET", "OFFSET"),
        TYPEARG("TYPEARG", "TYPEARG");

        private final String parseKey;
        private final String printval;

        private InfoType(String parse, String print) {
            this.parseKey = parse;
            this.printval = print;
        }

        public String parseKey() {
            return this.parseKey;
        }
    }

    public static class TypePathEntry {
        private final PathKind kind;
        private final char index;

        public TypePathEntry(int kind, char index) {
            this.kind = TypeAnnotationUtils.getPathKind(kind);
            this.index = index;
        }

        public PathKind kind() {
            return this.kind;
        }

        public char index() {
            return this.index;
        }

        public String toString() {
            return this.kind.parsekey() + "(" + this.index + ")";
        }
    }

    public static enum PathKind {
        DEEPER_ARRAY(0, "DEEPER_ARRAY", "ARRAY"),
        DEEPER_NESTEDTYPE(1, "DEEPER_NESTEDTYPE", "INNER_TYPE"),
        BOUND_WILDCARDTYPE(2, "BOUND_WILDCARDTYPE", "WILDCARD"),
        ITHARG_PARAMETERTYPE(3, "ITHARG_PARAMETERTYPE", "TYPE_ARGUMENT");

        private final int key;
        private final String type;
        private final String parseKey;
        public static final int maxLen = 3;

        private PathKind(int key, String type, String parseval) {
            this.key = key;
            this.type = type;
            this.parseKey = parseval;
        }

        public int key() {
            return this.key;
        }

        public String parsekey() {
            return this.parseKey;
        }
    }
}

