/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.TypeAnnotationUtils;

public class TypeAnnotationData
extends AnnotationData {
    protected TypeAnnotationUtils.TargetType targetType;
    protected TypeAnnotationUtils.TargetInfo targetInfo;
    protected ArrayList<TypeAnnotationUtils.TypePathEntry> targetPath;

    public TypeAnnotationData(Argument typeCPX, boolean invisible) {
        super(typeCPX, invisible);
    }

    @Override
    public int getLength() {
        return super.getLength() + 2 + this.targetInfo.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        out.writeByte(this.targetType.value);
        this.targetInfo.write(out);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tabLevel) {
        StringBuilder sb = new StringBuilder();
        String tabStr = TypeAnnotationData.tabString(tabLevel);
        sb.append(tabStr + "Target Type: ");
        sb.append(this.targetType.toString());
        sb.append('\n');
        sb.append(tabStr + "Target Info: ");
        sb.append(this.targetInfo.toString(tabLevel));
        sb.append('\n');
        sb.append(tabStr + "Target Path: [");
        boolean first = true;
        for (TypeAnnotationUtils.TypePathEntry tpe : this.targetPath) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(tpe);
        }
        sb.append("]");
        sb.append('\n');
        return sb.toString();
    }

    protected static String tabString(int tabLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tabLevel; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }
}

