/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.Tables;

public class ParserCP
extends ParseBase {
    private ParserCPVisitor pConstVstr = new ParserCPVisitor();

    protected ParserCP(Scanner scanner, Parser parser, Environment env) {
        super.init(scanner, parser, env);
    }

    protected ConstantPool.ConstValue parseConstValue(Tables.ConstType tag) throws IOException, Scanner.SyntaxError {
        return this.pConstVstr.visitExcept(tag);
    }

    protected ConstantPool.ConstValue parseTagConstValue(Tables.ConstType defaultTag) throws Scanner.SyntaxError, IOException {
        return this.parseTagConstValue(defaultTag, null, false);
    }

    private Tables.ConstType scanConstByID(boolean ignoreKeywords) {
        Tables.ConstType tag = null;
        if (!ignoreKeywords) {
            Tables.ConstType tg = Tables.tag(this.scanner.idValue);
            if (tg != null) {
                tag = tg;
            }
            this.debugStr(" *^*^*^*^ [ParserCP.scanConst]: {TAG = " + (tg == null ? "null" : tg.toString()) + " ");
        }
        return tag;
    }

    private Tables.ConstType scanConstPrimVal() throws Scanner.SyntaxError, IOException {
        Tables.ConstType tag = null;
        switch (this.scanner.token) {
            case INTVAL: {
                tag = Tables.ConstType.CONSTANT_INTEGER;
                break;
            }
            case LONGVAL: {
                tag = Tables.ConstType.CONSTANT_LONG;
                break;
            }
            case FLOATVAL: {
                tag = Tables.ConstType.CONSTANT_FLOAT;
                break;
            }
            case DOUBLEVAL: {
                tag = Tables.ConstType.CONSTANT_DOUBLE;
                break;
            }
            case STRINGVAL: 
            case BITS: 
            case IDENT: {
                tag = Tables.ConstType.CONSTANT_STRING;
                break;
            }
            default: {
                System.err.println("NEAR: " + this.scanner.token.printval());
                this.env.error(this.scanner.pos, "value.expected");
                throw new Scanner.SyntaxError();
            }
        }
        return tag;
    }

    private void checkWrongTag(Tables.ConstType tag, Tables.ConstType defaultTag, Tables.ConstType default2Tag) throws Scanner.SyntaxError, IOException {
        if (defaultTag != null && tag != defaultTag) {
            if (default2Tag == null) {
                this.env.error("warn.wrong.tag", (Object)defaultTag.parseKey());
            } else if (tag != default2Tag) {
                this.env.error("warn.wrong.tag2", (Object)defaultTag.parseKey(), (Object)default2Tag.parseKey());
            }
        }
    }

    protected ConstantPool.ConstValue parseTagConstValue(Tables.ConstType defaultTag, Tables.ConstType default2Tag, boolean ignoreKeywords) throws Scanner.SyntaxError, IOException {
        this.debugScan(" *^*^*^*^ [ParserCP.parseTagConstValue]: Begin default_tag:  ignoreKeywords: " + (ignoreKeywords ? "true" : "false"));
        Tables.ConstType tag = this.scanConstByID(ignoreKeywords);
        this.debugStr(" *^*^*^*^ [ParserCP.parseTagConstValue]: {tag = " + (Object)((Object)tag) + ", defaulttag = " + (Object)((Object)defaultTag) + "} ");
        if (tag == null) {
            tag = defaultTag == null ? this.scanConstPrimVal() : defaultTag;
        } else {
            this.checkWrongTag(tag, defaultTag, default2Tag);
            this.scanner.scan();
        }
        return this.parseConstValue(tag);
    }

    protected ConstantPool.ConstCell parseConstRef(Tables.ConstType defaultTag) throws Scanner.SyntaxError, IOException {
        return this.parseConstRef(defaultTag, null, false);
    }

    protected ConstantPool.ConstCell parseConstRef(Tables.ConstType defaultTag, Tables.ConstType default2Tag) throws Scanner.SyntaxError, IOException {
        return this.parseConstRef(defaultTag, default2Tag, false);
    }

    protected ConstantPool.ConstCell parseConstRef(Tables.ConstType defaultTag, Tables.ConstType default2Tag, boolean ignoreKeywords) throws Scanner.SyntaxError, IOException {
        if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            this.scanner.scan();
            return this.parser.pool.getCell(cpx);
        }
        ConstantPool.ConstValue ref = null;
        ref = this.parseTagConstValue(defaultTag, default2Tag, ignoreKeywords);
        return this.parser.pool.FindCell(ref);
    }

    class ParserCPVisitor
    extends ConstantPool.CPTagVisitor<ConstantPool.ConstValue> {
        private IOException IOProb = null;
        private Scanner.SyntaxError SyProb = null;

        public ConstantPool.ConstValue visitExcept(Tables.ConstType tag) throws IOException, Scanner.SyntaxError {
            this.IOProb = null;
            this.SyProb = null;
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitExcept]: ");
            ConstantPool.ConstValue ret = (ConstantPool.ConstValue)this.visit(tag);
            if (this.IOProb != null) {
                throw this.IOProb;
            }
            if (this.SyProb != null) {
                throw this.SyProb;
            }
            return ret;
        }

        @Override
        public ConstantPool.ConstValue visitUTF8(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitUTF8]: ");
            try {
                ParserCP.this.scanner.expect(JasmTokens.Token.STRINGVAL);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            ConstantPool.ConstValue_String obj = new ConstantPool.ConstValue_String(ParserCP.this.scanner.stringValue);
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitInteger(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitInteger]: ");
            int v = 0;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.inBits = true;
                }
                v = ParserCP.this.scanner.intValue * ParserCP.this.scanner.sign;
                ParserCP.this.scanner.expect(JasmTokens.Token.INTVAL);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            ConstantPool.ConstValue_Integer obj = new ConstantPool.ConstValue_Integer(tag, new Integer(v));
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitLong(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitLong]: ");
            ConstantPool.ConstValue_Long obj = null;
            try {
                long v;
                if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.inBits = true;
                }
                switch (ParserCP.this.scanner.token) {
                    case INTVAL: {
                        v = ParserCP.this.scanner.intValue;
                        break;
                    }
                    case LONGVAL: {
                        v = ParserCP.this.scanner.longValue;
                        break;
                    }
                    default: {
                        ParserCP.this.env.error(ParserCP.this.scanner.prevPos, "token.expected", (Object)"Integer");
                        throw new Scanner.SyntaxError();
                    }
                }
                obj = new ConstantPool.ConstValue_Long(tag, new Long(v * (long)ParserCP.this.scanner.sign));
                ParserCP.this.scanner.scan();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            catch (Scanner.SyntaxError e) {
                this.SyProb = e;
            }
            return obj;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstantPool.ConstValue visitFloat(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitFloat]: ");
            ConstantPool.ConstValue_Integer obj = null;
            try {
                int v;
                block14: {
                    float f;
                    ParserCP.this.scanner.inBits = false;
                    if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                        ParserCP.this.scanner.scan();
                        ParserCP.this.scanner.inBits = true;
                    }
                    switch (ParserCP.this.scanner.token) {
                        case INTVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.intValue;
                                break block14;
                            } else {
                                f = ParserCP.this.scanner.intValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            f = ParserCP.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            f = (float)ParserCP.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            f = Float.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            f = Float.NaN;
                            break;
                        }
                        default: {
                            ParserCP.this.env.traceln("token=" + (Object)((Object)ParserCP.this.scanner.token));
                            ParserCP.this.env.error(ParserCP.this.scanner.pos, "token.expected", (Object)"<Float>");
                            throw new Scanner.SyntaxError();
                        }
                    }
                    v = Float.floatToIntBits(f);
                }
                if (ParserCP.this.scanner.sign == -1) {
                    v ^= Integer.MIN_VALUE;
                }
                obj = new ConstantPool.ConstValue_Integer(tag, new Integer(v));
                ParserCP.this.scanner.scan();
                return obj;
            }
            catch (IOException e) {
                this.IOProb = e;
                return obj;
            }
            catch (Scanner.SyntaxError e) {
                this.SyProb = e;
            }
            return obj;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstantPool.ConstValue visitDouble(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitDouble]: ");
            ConstantPool.ConstValue_Long obj = null;
            try {
                long v;
                block17: {
                    double d;
                    if (ParserCP.this.scanner.token == JasmTokens.Token.BITS) {
                        ParserCP.this.scanner.scan();
                        ParserCP.this.scanner.inBits = true;
                    }
                    switch (ParserCP.this.scanner.token) {
                        case INTVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.intValue;
                                break block17;
                            } else {
                                d = ParserCP.this.scanner.intValue;
                                break;
                            }
                        }
                        case LONGVAL: {
                            if (ParserCP.this.scanner.inBits) {
                                v = ParserCP.this.scanner.longValue;
                                break block17;
                            } else {
                                d = ParserCP.this.scanner.longValue;
                                break;
                            }
                        }
                        case FLOATVAL: {
                            d = ParserCP.this.scanner.floatValue;
                            break;
                        }
                        case DOUBLEVAL: {
                            d = ParserCP.this.scanner.doubleValue;
                            break;
                        }
                        case INF: {
                            d = Double.POSITIVE_INFINITY;
                            break;
                        }
                        case NAN: {
                            d = Double.NaN;
                            break;
                        }
                        default: {
                            ParserCP.this.env.error(ParserCP.this.scanner.pos, "token.expected", (Object)"Double");
                            throw new Scanner.SyntaxError();
                        }
                    }
                    v = Double.doubleToLongBits(d);
                }
                if (ParserCP.this.scanner.sign == -1) {
                    v ^= Long.MIN_VALUE;
                }
                obj = new ConstantPool.ConstValue_Long(tag, new Long(v));
                ParserCP.this.scanner.scan();
                return obj;
            }
            catch (IOException e) {
                this.IOProb = e;
                return obj;
            }
            catch (Scanner.SyntaxError e) {
                this.SyProb = e;
            }
            return obj;
        }

        private ConstantPool.ConstCell visitName(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitName]: ");
            ConstantPool.ConstCell obj = null;
            try {
                obj = ParserCP.this.parser.parseName();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitMethodtype(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitMethodtype]: ");
            ConstantPool.ConstValue_Cell obj = null;
            ConstantPool.ConstCell cell = this.visitName(tag);
            if (this.IOProb == null) {
                obj = new ConstantPool.ConstValue_Cell(tag, cell);
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitString(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitString]: ");
            ConstantPool.ConstValue_Cell obj = null;
            ConstantPool.ConstCell cell = this.visitName(tag);
            if (this.IOProb == null) {
                obj = new ConstantPool.ConstValue_Cell(tag, cell);
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitClass(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitClass]: ");
            ConstantPool.ConstValue_Cell obj = null;
            try {
                ConstantPool.ConstCell cell = ParserCP.this.parser.parseClassName(true);
                obj = new ConstantPool.ConstValue_Cell(tag, cell);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitMethodhandle(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitMethodHandle]: ");
            ConstantPool.ConstValue_Pair obj = null;
            try {
                ConstantPool.ConstCell refCell;
                ConstantPool.ConstCell subtagCell;
                if (ParserCP.this.scanner.token == JasmTokens.Token.INTVAL) {
                    Tables.SubTag subtag = Tables.subtag(ParserCP.this.scanner.intValue);
                    subtagCell = new ConstantPool.ConstCell(subtag.value());
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token != JasmTokens.Token.CPINDEX) {
                        ParserCP.this.env.traceln("token=" + (Object)((Object)ParserCP.this.scanner.token));
                        ParserCP.this.env.error(ParserCP.this.scanner.pos, "token.expected", (Object)"<CPINDEX>");
                        throw new Scanner.SyntaxError();
                    }
                    int cpx = ParserCP.this.scanner.intValue;
                    refCell = ParserCP.this.parser.pool.getCell(cpx);
                    ParserCP.this.scanner.scan();
                } else {
                    Tables.SubTag subtag = ParserCP.this.parser.parseSubtag();
                    subtagCell = new ConstantPool.ConstCell(subtag.value());
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    refCell = ParserCP.this.parser.parseMethodHandle(subtag);
                }
                obj = new ConstantPool.ConstValue_Pair(tag, subtagCell, refCell);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        private ConstantPool.ConstValue_Pair visitMember(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitMember]: ");
            ConstantPool.ConstValue_Pair obj = null;
            try {
                ConstantPool.ConstCell NapeCell;
                ConstantPool.ConstCell NameCell;
                ConstantPool.ConstCell ClassCell;
                JasmTokens.Token prevtoken = ParserCP.this.scanner.token;
                ConstantPool.ConstCell firstName = ParserCP.this.parser.parseClassName(false);
                if (ParserCP.this.scanner.token == JasmTokens.Token.FIELD) {
                    ParserCP.this.scanner.scan();
                    ClassCell = prevtoken == JasmTokens.Token.CPINDEX ? firstName : ParserCP.this.parser.pool.FindCell(Tables.ConstType.CONSTANT_CLASS, firstName);
                    NameCell = ParserCP.this.parser.parseName();
                } else {
                    ClassCell = ParserCP.this.parser.cd.me;
                    NameCell = firstName;
                }
                if (ParserCP.this.scanner.token == JasmTokens.Token.COLON) {
                    ParserCP.this.scanner.scan();
                    NapeCell = ParserCP.this.parser.pool.FindCell(Tables.ConstType.CONSTANT_NAMEANDTYPE, NameCell, ParserCP.this.parser.parseName());
                } else {
                    NapeCell = NameCell;
                }
                obj = new ConstantPool.ConstValue_Pair(tag, ClassCell, NapeCell);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue visitField(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitField]: ");
            return this.visitMember(tag);
        }

        @Override
        public ConstantPool.ConstValue visitMethod(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitMethod]: ");
            return this.visitMember(tag);
        }

        @Override
        public ConstantPool.ConstValue visitInterfacemethod(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitInterfacemethod]: ");
            return this.visitMember(tag);
        }

        @Override
        public ConstantPool.ConstValue visitNameandtype(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitNameandtype]: ");
            ConstantPool.ConstValue_Pair obj = null;
            try {
                ConstantPool.ConstCell NameCell = ParserCP.this.parser.parseName();
                ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                ConstantPool.ConstCell TypeCell = ParserCP.this.parser.parseName();
                obj = new ConstantPool.ConstValue_Pair(tag, NameCell, TypeCell);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue_IndyPair visitInvokedynamic(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitInvokeDynamic]: ");
            ConstantPool.ConstValue_IndyPair obj = null;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.INTVAL) {
                    int bsmIndex = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token != JasmTokens.Token.CPINDEX) {
                        ParserCP.this.env.traceln("token=" + (Object)((Object)ParserCP.this.scanner.token));
                        ParserCP.this.env.error(ParserCP.this.scanner.pos, "token.expected", (Object)"<CPINDEX>");
                        throw new Scanner.SyntaxError();
                    }
                    int cpx = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    BootstrapMethodData bsmData = new BootstrapMethodData(bsmIndex);
                    obj = new ConstantPool.ConstValue_IndyPair(bsmData, ParserCP.this.parser.pool.getCell(cpx));
                } else {
                    ConstantPool.ConstCell MHCell = ParserCP.this.parser.pool.FindCell(ParserCP.this.parseConstValue(Tables.ConstType.CONSTANT_METHODHANDLE));
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    ConstantPool.ConstCell NapeCell = ParserCP.this.parser.pool.FindCell(ParserCP.this.parseConstValue(Tables.ConstType.CONSTANT_NAMEANDTYPE));
                    ArrayList<ConstantPool.ConstCell> bsm_args = new ArrayList<ConstantPool.ConstCell>(256);
                    boolean sep = false;
                    while (ParserCP.this.scanner.token != JasmTokens.Token.SEMICOLON) {
                        if (sep) {
                            ParserCP.this.scanner.expect(JasmTokens.Token.COMMA);
                        }
                        bsm_args.add(ParserCP.this.parseConstRef(null));
                        ParserCP.this.scanner.idValue = null;
                        sep = true;
                    }
                    BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
                    ParserCP.this.parser.cd.addBootstrapMethod(bsmData);
                    obj = new ConstantPool.ConstValue_IndyPair(bsmData, NapeCell);
                }
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }

        @Override
        public ConstantPool.ConstValue_CondyPair visitDynamic(Tables.ConstType tag) {
            ParserCP.this.debugStr("------- [ParserCPVisitor.visitDynamic]: ");
            ConstantPool.ConstValue_CondyPair obj = null;
            try {
                if (ParserCP.this.scanner.token == JasmTokens.Token.INTVAL) {
                    int bsmIndex = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    if (ParserCP.this.scanner.token != JasmTokens.Token.CPINDEX) {
                        ParserCP.this.env.traceln("token=" + (Object)((Object)ParserCP.this.scanner.token));
                        ParserCP.this.env.error(ParserCP.this.scanner.pos, "token.expected", (Object)"<CPINDEX>");
                        throw new Scanner.SyntaxError();
                    }
                    int cpx = ParserCP.this.scanner.intValue;
                    ParserCP.this.scanner.scan();
                    BootstrapMethodData bsmData = new BootstrapMethodData(bsmIndex);
                    obj = new ConstantPool.ConstValue_CondyPair(bsmData, ParserCP.this.parser.pool.getCell(cpx));
                } else {
                    ConstantPool.ConstCell MHCell = ParserCP.this.parser.pool.FindCell(ParserCP.this.parseConstValue(Tables.ConstType.CONSTANT_METHODHANDLE));
                    ParserCP.this.scanner.expect(JasmTokens.Token.COLON);
                    ConstantPool.ConstCell NapeCell = ParserCP.this.parser.pool.FindCell(ParserCP.this.parseConstValue(Tables.ConstType.CONSTANT_NAMEANDTYPE));
                    ArrayList<ConstantPool.ConstCell> bsm_args = new ArrayList<ConstantPool.ConstCell>(256);
                    while (ParserCP.this.scanner.token != JasmTokens.Token.SEMICOLON) {
                        if (ParserCP.this.scanner.token == JasmTokens.Token.COMMA) {
                            ParserCP.this.scanner.scan();
                        }
                        bsm_args.add(ParserCP.this.parseConstRef(null));
                    }
                    BootstrapMethodData bsmData = new BootstrapMethodData(MHCell, bsm_args);
                    ParserCP.this.parser.cd.addBootstrapMethod(bsmData);
                    obj = new ConstantPool.ConstValue_CondyPair(bsmData, NapeCell);
                }
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return obj;
        }
    }
}

