/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.DefaultAnnotationAttr;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.ParseBase;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jasm.TypeAnnotationData;
import org.openjdk.asmtools.jasm.TypeAnnotationUtils;

public class ParserAnnotation
extends ParseBase {
    private static TTVis ttVisitor;

    protected ParserAnnotation(Scanner scanner, Parser parser, Environment env) {
        super.init(scanner, parser, env);
        ttVisitor = new TTVis();
        ttVisitor.init(env, scanner);
    }

    protected void scanParamName(int totalParams, int paramNum, MethodData curMethod) throws IOException {
        this.debugScan(" - - - > [ParserAnnotation.scanParamName]: Begin ");
        this.scanner.scan();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        ConstantPool.ConstCell nameCell = null;
        if (this.scanner.token == JasmTokens.Token.IDENT || this.scanner.checkTokenIdent()) {
            nameCell = this.parser.parseName();
        } else if (this.scanner.token == JasmTokens.Token.CPINDEX) {
            int cpx = this.scanner.intValue;
            nameCell = this.parser.pool.getCell(cpx);
            ConstantPool.ConstValue nameCellValue = nameCell.ref;
            if (!(nameCellValue instanceof ConstantPool.ConstValue_String)) {
                this.env.error(this.scanner.pos, "paramname.constnum.invaltype", (Object)cpx);
                throw new Scanner.SyntaxError();
            }
        } else {
            this.env.error(this.scanner.pos, "paramname.token.unexpected", (Object)this.scanner.stringValue);
            throw new Scanner.SyntaxError();
        }
        int mod = this.parser.scanModifiers();
        this.scanner.expect(JasmTokens.Token.RBRACE);
        curMethod.addMethodParameter(totalParams, paramNum, nameCell, mod);
        this.debugScan(" - - - > [ParserAnnotation.scanParamName]: End ");
    }

    protected ArrayList<AnnotationData> scanAnnotations() throws IOException {
        ArrayList<AnnotationData> annttns = new ArrayList<AnnotationData>();
        while (this.scanner.token == JasmTokens.Token.ANNOTATION) {
            if (this.isAnnotationToken(this.scanner.stringValue)) {
                annttns.add(this.parseAnnotation());
                continue;
            }
            if (this.isTypeAnnotationToken(this.scanner.stringValue)) {
                annttns.add(this.parseTypeAnnotation());
                continue;
            }
            return null;
        }
        if (annttns.size() > 0) {
            return annttns;
        }
        return null;
    }

    protected boolean isAnnotation(String str) {
        return str.startsWith("@");
    }

    protected boolean isAnnotationToken(String str) {
        return str.startsWith("@+") || str.startsWith("@-");
    }

    protected boolean isTypeAnnotationToken(String str) {
        return str.startsWith("@T+") || str.startsWith("@T-");
    }

    protected boolean isInvisibleAnnotToken(String str) {
        return str.endsWith("-");
    }

    protected DefaultAnnotationAttr parseDefaultAnnotation() throws Scanner.SyntaxError, IOException {
        this.scanner.scan();
        DefaultAnnotationAttr attr = null;
        Data value = null;
        this.scanner.expect(JasmTokens.Token.LBRACE);
        if (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            value = this.scanAnnotationData("default");
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        attr = new DefaultAnnotationAttr(this.parser.cd, Tables.AttrTag.ATT_AnnotationDefault.parsekey(), value);
        return attr;
    }

    protected void parseParamAnnots(int _totalParams, MethodData curMethod) throws Scanner.SyntaxError, IOException {
        this.debugScan(" - - - > [ParserAnnotation.parseParamAnnots]: Begin, totalParams =  " + _totalParams + " ");
        int totalParams = _totalParams - 1;
        TreeMap<Integer, ArrayList<AnnotationData>> pAnnots = new TreeMap<Integer, ArrayList<AnnotationData>>();
        while (this.scanner.token == JasmTokens.Token.INTVAL) {
            int paramNum = this.scanner.intValue;
            Integer iParamNum = paramNum;
            if (paramNum < 0 || paramNum >= totalParams) {
                this.env.error(this.scanner.pos, "invalid.paramnum", (Object)paramNum);
            }
            if (pAnnots.get(iParamNum) != null) {
                this.env.error(this.scanner.pos, "duplicate.paramnum", (Object)paramNum);
            }
            this.scanner.scan();
            this.scanner.expect(JasmTokens.Token.COLON);
            if (this.scanner.token == JasmTokens.Token.PARAM_NAME) {
                this.scanParamName(_totalParams, iParamNum, curMethod);
            }
            if (this.scanner.token != JasmTokens.Token.ANNOTATION) continue;
            ArrayList<AnnotationData> pAnnot = this.scanAnnotations();
            pAnnots.put(iParamNum, pAnnot);
            for (AnnotationData data : pAnnot) {
                curMethod.addParamAnnotation(totalParams, paramNum, data);
            }
        }
    }

    private AnnotationData parseTypeAnnotation() throws Scanner.SyntaxError, IOException {
        boolean invisible = this.isInvisibleAnnotToken(this.scanner.stringValue);
        this.scanner.scan();
        this.debugScan("     [ParserAnnotation.parseTypeAnnotation]: id = " + this.scanner.stringValue + " ");
        String annoName = "L" + this.scanner.stringValue + ";";
        TypeAnnotationData anno = new TypeAnnotationData(this.parser.pool.FindCellAsciz(annoName), invisible);
        this.scanner.scan();
        this.debugScan("     [ParserAnnotation.parseTypeAnnotation]:new type annotation: " + annoName + " ");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this._scanAnnotation(anno);
        this._scanTypeTarget(anno);
        this._scanTargetPath(anno);
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return anno;
    }

    private AnnotationData parseAnnotation() throws Scanner.SyntaxError, IOException {
        this.debugScan(" - - - > [ParserAnnotation.parseAnnotation]: Begin ");
        boolean invisible = this.isInvisibleAnnotToken(this.scanner.stringValue);
        this.scanner.scan();
        String annoName = "L" + this.scanner.stringValue + ";";
        AnnotationData anno = new AnnotationData(this.parser.pool.FindCellAsciz(annoName), invisible);
        this.scanner.scan();
        this.debugScan("[ParserAnnotation.parseAnnotation]: new annotation: " + annoName);
        this._scanAnnotation(anno);
        return anno;
    }

    private void _scanAnnotation(AnnotationData annotData) throws Scanner.SyntaxError, IOException {
        this.debugScan(" - - - > [ParserAnnotation._scanAnnotation]: Begin");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            ConstantPool.ConstCell nameCell = this.parser.parseName();
            this.scanner.expect(JasmTokens.Token.ASSIGN);
            ConstantPool.ConstValue cellref = nameCell.ref;
            if (cellref.tag != Tables.ConstType.CONSTANT_UTF8) {
                throw new Scanner.SyntaxError();
            }
            String name = ((ConstantPool.ConstValue_String)cellref)._toString();
            this.debugScan(" - - - > [ParserAnnotation._scanAnnotation]: Annot - Field Name: " + name);
            Data data = this.scanAnnotationData(name);
            annotData.add(new AnnotationData.ElemValuePair(nameCell, data));
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
    }

    private void _scanTypeTarget(TypeAnnotationData annotData) throws Scanner.SyntaxError, IOException {
        this.debugScan("     [ParserAnnotation._scanTypeTarget]: Begin ");
        this.scanner.expect(JasmTokens.Token.LBRACE);
        this.scanner.expect(JasmTokens.Token.IDENT);
        this.debugScan("     [ParserAnnotation._scanTypeTarget]: TargetType: " + this.scanner.idValue);
        TypeAnnotationUtils.TargetType tt = TypeAnnotationUtils.getTargetType(this.scanner.idValue);
        if (tt == null) {
            this.env.error(this.scanner.pos, "incorrect.typeannot.target", (Object)this.scanner.idValue);
            throw new Scanner.SyntaxError();
        }
        this.debugScan("     [ParserAnnotation._scanTypeTarget]: Got TargetType: " + (Object)((Object)tt));
        if (ttVisitor.scanner == null) {
            ttVisitor.scanner = this.scanner;
        }
        ttVisitor.visitExcept(tt);
        annotData.targetInfo = ttVisitor.getTargetInfo();
        annotData.targetType = tt;
        this.debugScan("     [ParserAnnotation._scanTypeTarget]: Got TargetInfo: " + annotData.targetInfo);
        this.scanner.expect(JasmTokens.Token.RBRACE);
    }

    private void _scanTargetPath(TypeAnnotationData annotData) throws Scanner.SyntaxError, IOException {
        ArrayList targPath = new ArrayList();
        this.scanner.expect(JasmTokens.Token.LBRACE);
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            TypeAnnotationUtils.TypePathEntry tpe = this._scanTypePathEntry();
            this.scanner.scan();
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        annotData.targetPath = targPath;
    }

    private TypeAnnotationUtils.TypePathEntry _scanTypePathEntry() throws Scanner.SyntaxError, IOException {
        TypeAnnotationUtils.TypePathEntry tpe;
        if (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token == JasmTokens.Token.STRINGVAL) {
            String pathEntryKey = this.scanner.stringValue;
            TypeAnnotationUtils.PathKind pk = TypeAnnotationUtils.pathKind(pathEntryKey);
            if (pk == null) {
                this.env.error(this.scanner.pos, "incorrect.typeannot.pathentry", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            if (pk == TypeAnnotationUtils.PathKind.ITHARG_PARAMETERTYPE) {
                this.scanner.expect(JasmTokens.Token.LPAREN);
                int index = 0;
                if (this.scanner.token == JasmTokens.Token.EOF || this.scanner.token != JasmTokens.Token.INTVAL) {
                    this.env.error(this.scanner.pos, "incorrect.typeannot.pathentry.argindex", (Object)this.scanner.token);
                    throw new Scanner.SyntaxError();
                }
                index = this.scanner.intValue;
                this.scanner.expect(JasmTokens.Token.RPAREN);
                tpe = new TypeAnnotationUtils.TypePathEntry(pk.key(), (char)index);
            } else {
                tpe = new TypeAnnotationUtils.TypePathEntry(pk.key(), '\u0000');
            }
        } else {
            this.env.error(this.scanner.pos, "incorrect.typeannot.pathentry", (Object)this.scanner.token);
            throw new Scanner.SyntaxError();
        }
        return tpe;
    }

    private ArrayElemValue scanAnnotationArray(String name) throws IOException {
        this.scanner.scan();
        ArrayElemValue arrayElem = new ArrayElemValue();
        while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
            Data data = this.scanAnnotationData(name + " {}");
            arrayElem.add(data);
            if (this.scanner.token != JasmTokens.Token.COMMA) continue;
            this.scanner.scan();
        }
        this.scanner.expect(JasmTokens.Token.RBRACE);
        return arrayElem;
    }

    private Data scanAnnotationClass(String name) throws IOException {
        Data constVal = null;
        this.scanner.scan();
        switch (this.scanner.token) {
            case IDENT: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Constant Class Field: " + name + " = " + this.scanner.stringValue);
                String desc = this.parser.encodeClassString(this.scanner.stringValue);
                constVal = new ConstElemValue('c', this.parser.pool.FindCellAsciz(desc));
                this.scanner.scan();
                break;
            }
            case CPINDEX: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Constant Class Field: " + name + " = " + this.scanner.stringValue);
                Integer ConstNmCPX = new Integer(this.scanner.stringValue);
                constVal = new ClassElemValue(this.parser.pool.getCell(ConstNmCPX));
                this.scanner.scan();
                break;
            }
            default: {
                this.env.error(this.scanner.pos, "incorrect.annot.class", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
        }
        return constVal;
    }

    private EnumElemValue scanAnnotationEnum(String name) throws IOException {
        this.scanner.scan();
        EnumElemValue enumval = null;
        block0 : switch (this.scanner.token) {
            case IDENT: {
                String enumClassName = this.scanner.stringValue;
                this.scanner.scan();
                switch (this.scanner.token) {
                    case IDENT: {
                        String enumTypeName = this.scanner.stringValue;
                        this.env.traceln("[AnnotationParser.scanAnnotationEnum]:: Constant Enum Field: " + name + " = " + enumClassName + " " + enumTypeName);
                        String encodedClass = this.parser.encodeClassString(enumClassName);
                        ConstElemValue classConst = new ConstElemValue('s', this.parser.pool.FindCellAsciz(encodedClass));
                        ConstElemValue typeConst = new ConstElemValue('s', this.parser.pool.FindCellAsciz(enumTypeName));
                        enumval = new EnumElemValue(classConst.indx, typeConst.indx);
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.enum", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            case CPINDEX: {
                Integer typeNmCPX = new Integer(this.scanner.stringValue);
                this.scanner.scan();
                switch (this.scanner.token) {
                    case CPINDEX: {
                        Integer ConstNmCPX = new Integer(this.scanner.stringValue);
                        this.env.traceln("[AnnotationParser.scanAnnotationEnum]:: Enumeration Field: " + name + " = #" + typeNmCPX + " #" + ConstNmCPX);
                        enumval = new EnumElemValue(this.parser.pool.getCell(typeNmCPX), this.parser.pool.getCell(ConstNmCPX));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.enum.cpx");
                throw new Scanner.SyntaxError();
            }
        }
        return enumval;
    }

    private Data scanAnnotationData(String name) throws IOException {
        Data data = null;
        switch (this.scanner.token) {
            case INTVAL: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Integer Field: " + name + " = " + this.scanner.intValue);
                data = new ConstElemValue('I', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, new Integer(this.scanner.intValue)));
                this.scanner.scan();
                break;
            }
            case DOUBLEVAL: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Double Field: " + name + " = " + this.scanner.doubleValue);
                double dval = new Double(this.scanner.doubleValue);
                long ivdal = Double.doubleToLongBits(dval);
                Long val = new Long(ivdal);
                data = new ConstElemValue('D', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_DOUBLE, val));
                this.scanner.scan();
                break;
            }
            case FLOATVAL: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Float Field: " + name + " = " + this.scanner.floatValue);
                float fval = new Float(this.scanner.floatValue).floatValue();
                int ifval = Float.floatToIntBits(fval);
                Integer val1 = new Integer(ifval);
                data = new ConstElemValue('F', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_FLOAT, val1));
                this.scanner.scan();
                break;
            }
            case LONGVAL: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Long Field: " + name + " = " + this.scanner.longValue);
                data = new ConstElemValue('J', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_LONG, new Long(this.scanner.longValue)));
                this.scanner.scan();
                break;
            }
            case STRINGVAL: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: String Field: " + name + " = " + this.scanner.stringValue);
                data = new ConstElemValue('s', this.parser.pool.FindCellAsciz(this.scanner.stringValue));
                this.scanner.scan();
                break;
            }
            case CLASS: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Class) keyword: " + this.scanner.stringValue);
                data = this.scanAnnotationClass(name);
                break;
            }
            case ENUM: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Enum) keyword: " + this.scanner.stringValue);
                data = this.scanAnnotationEnum(name);
                break;
            }
            case IDENT: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: JASM Keyword: (annotation field name: " + name + ") keyword: " + this.scanner.stringValue);
                data = this.scanAnnotationIdent(this.scanner.stringValue, name);
                break;
            }
            case ANNOTATION: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Annotation Field: " + name + " = " + this.scanner.stringValue);
                data = new AnnotationElemValue(this.parseAnnotation());
                break;
            }
            case LBRACE: {
                this.env.traceln("[AnnotationParser.scanAnnotationData]:: Annotation Array Field: " + name);
                data = this.scanAnnotationArray(name);
                break;
            }
            default: {
                this.env.error(this.scanner.pos, "incorrect.annot.token", (Object)this.scanner.token);
                throw new Scanner.SyntaxError();
            }
        }
        return data;
    }

    private Data scanAnnotationIdent(String ident, String name) throws IOException {
        ConstElemValue data = null;
        Tables.BasicType type = Tables.basictype(ident);
        block0 : switch (type) {
            case T_BOOLEAN: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.env.traceln("Boolean Field: " + name + " = " + this.scanner.intValue);
                        Integer val = new Integer(this.scanner.intValue);
                        if (val > 1 || val < 0) {
                            this.env.traceln("Warning: Boolean Field: " + name + " value is not 0 or 1, value = " + this.scanner.intValue);
                        }
                        data = new ConstElemValue('Z', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, val));
                        this.scanner.scan();
                        break block0;
                    }
                    case IDENT: {
                        int val1 = 0;
                        switch (this.scanner.stringValue) {
                            case "true": {
                                val1 = 1;
                                break;
                            }
                            case "false": {
                                val1 = 0;
                                break;
                            }
                            default: {
                                throw new IOException("Incorrect Annotation (boolean), expected true/false), got \"" + this.scanner.stringValue + "\".");
                            }
                        }
                        this.env.traceln("Boolean Field: " + name + " = " + this.scanner.stringValue);
                        data = new ConstElemValue('Z', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, new Integer(val1)));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.bool", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            case T_BYTE: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.env.traceln("Byte Field: " + name + " = " + this.scanner.intValue);
                        Integer val = new Integer(this.scanner.intValue);
                        if (val > 255) {
                            this.env.traceln("Warning: Byte Field: " + name + " value is greater than 0xFF, value = " + this.scanner.intValue);
                        }
                        data = new ConstElemValue('B', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, val));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.byte", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            case T_CHAR: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.env.traceln("Char Field: " + name + " = " + this.scanner.intValue);
                        Integer val = new Integer(this.scanner.intValue);
                        data = new ConstElemValue('C', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, val));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.char", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            case T_SHORT: {
                this.scanner.scan();
                switch (this.scanner.token) {
                    case INTVAL: {
                        this.env.traceln("Short Field: " + name + " = " + this.scanner.intValue);
                        Integer val = new Integer(this.scanner.intValue);
                        if (val > 65535) {
                            this.env.traceln("Warning: Short Field: " + name + " value is greater than 0xFFFF, value = " + this.scanner.intValue);
                        }
                        data = new ConstElemValue('S', this.parser.pool.FindCell(Tables.ConstType.CONSTANT_INTEGER, val));
                        this.scanner.scan();
                        break block0;
                    }
                }
                this.env.error(this.scanner.pos, "incorrect.annot.short", (Object)this.scanner.stringValue);
                throw new Scanner.SyntaxError();
            }
            default: {
                this.env.error(this.scanner.pos, "incorrect.annot.keyword", (Object)ident);
                throw new Scanner.SyntaxError();
            }
        }
        return data;
    }

    private static class TTVis
    extends TypeAnnotationUtils.TypeAnnotationTargetVisitor {
        private TypeAnnotationUtils.TargetInfo ti;
        private IOException IOProb;
        private Scanner.SyntaxError SyProb;
        private Scanner scanner;
        private Environment env;

        public TTVis() {
            this.reset();
        }

        public void init(Environment en, Scanner scn) {
            if (this.scanner == null) {
                this.scanner = scn;
            }
            if (this.env == null) {
                this.env = en;
            }
        }

        public final void reset() {
            this.ti = null;
            this.IOProb = null;
            this.SyProb = null;
        }

        public void visitExcept(TypeAnnotationUtils.TargetType tt) throws IOException, Scanner.SyntaxError {
            this.IOProb = null;
            this.SyProb = null;
            this.ti = null;
            this.visit(tt);
            if (this.IOProb != null) {
                throw this.IOProb;
            }
            if (this.SyProb != null) {
                throw this.SyProb;
            }
        }

        public TypeAnnotationUtils.TargetInfo getTargetInfo() {
            return this.ti;
        }

        private int scanIntVal(TypeAnnotationUtils.TargetType tt) {
            int ret = -1;
            if (this.scanner.token == JasmTokens.Token.INTVAL) {
                ret = this.scanner.intValue;
                try {
                    this.scanner.scan();
                }
                catch (IOException e) {
                    this.IOProb = e;
                }
                catch (Scanner.SyntaxError e) {
                    this.SyProb = e;
                }
            } else {
                this.env.error(this.scanner.pos, "incorrect.typeannot.targtype.int", (Object)tt.parseKey(), (Object)this.scanner.token);
                this.SyProb = new Scanner.SyntaxError();
            }
            return ret;
        }

        private String scanStringVal(TypeAnnotationUtils.TargetType tt) {
            String ret = "";
            if (this.scanner.token == JasmTokens.Token.STRINGVAL) {
                ret = this.scanner.stringValue;
                try {
                    this.scanner.scan();
                }
                catch (IOException e) {
                    this.IOProb = e;
                }
                catch (Scanner.SyntaxError e) {
                    this.SyProb = e;
                }
            } else {
                this.env.error(this.scanner.pos, "incorrect.typeannot.targtype.string", (Object)tt.parseKey(), (Object)this.scanner.token);
                this.SyProb = new Scanner.SyntaxError();
            }
            return ret;
        }

        private void scanBrace(boolean left) {
            try {
                this.scanner.expect(left ? JasmTokens.Token.LBRACE : JasmTokens.Token.RBRACE);
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            catch (Scanner.SyntaxError e) {
                this.SyProb = e;
            }
        }

        private boolean error() {
            return this.IOProb != null || this.SyProb != null;
        }

        @Override
        public void visit_type_param_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("Type Param Target: ");
            int byteval = this.scanIntVal(tt);
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.typeparam_target(tt, byteval);
            }
        }

        @Override
        public void visit_supertype_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("SuperType Target: ");
            int shortval = this.scanIntVal(tt);
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.supertype_target(tt, shortval);
            }
        }

        @Override
        public void visit_typeparam_bound_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("TypeParam Bound Target: ");
            int byteval1 = this.scanIntVal(tt);
            if (this.error()) {
                return;
            }
            int byteval2 = this.scanIntVal(tt);
            if (this.error()) {
                return;
            }
            this.ti = new TypeAnnotationUtils.typeparam_bound_target(tt, byteval1, byteval2);
        }

        @Override
        public void visit_empty_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("Empty Target: ");
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.empty_target(tt);
            }
        }

        @Override
        public void visit_methodformalparam_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("MethodParam Target: ");
            int byteval = this.scanIntVal(tt);
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.methodformalparam_target(tt, byteval);
            }
        }

        @Override
        public void visit_throws_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("Throws Target: ");
            int shortval = this.scanIntVal(tt);
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.throws_target(tt, shortval);
            }
        }

        @Override
        public void visit_localvar_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("LocalVar Target: ");
            TypeAnnotationUtils.localvar_target locvartab = new TypeAnnotationUtils.localvar_target(tt, 0);
            this.ti = locvartab;
            while (this.scanner.token != JasmTokens.Token.EOF && this.scanner.token != JasmTokens.Token.RBRACE) {
                this.scanBrace(true);
                if (this.error()) {
                    return;
                }
                int shortval1 = this.scanIntVal(tt);
                if (this.error()) {
                    return;
                }
                int shortval2 = this.scanIntVal(tt);
                if (this.error()) {
                    return;
                }
                int shortval3 = this.scanIntVal(tt);
                locvartab.addEntry(shortval1, shortval2, shortval3);
                this.scanBrace(false);
                if (!this.error()) continue;
                return;
            }
        }

        @Override
        public void visit_catch_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("Catch Target: ");
            int shortval = this.scanIntVal(tt);
            this.ti = new TypeAnnotationUtils.catch_target(tt, shortval);
        }

        @Override
        public void visit_offset_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("Offset Target: ");
            int shortval = this.scanIntVal(tt);
            if (!this.error()) {
                this.ti = new TypeAnnotationUtils.offset_target(tt, shortval);
            }
        }

        @Override
        public void visit_typearg_target(TypeAnnotationUtils.TargetType tt) {
            this.env.traceln("TypeArg Target: ");
            int shortval = this.scanIntVal(tt);
            if (this.error()) {
                return;
            }
            int byteval = this.scanIntVal(tt);
            if (this.error()) {
                return;
            }
            this.ti = new TypeAnnotationUtils.typearg_target(tt, shortval, byteval);
        }
    }

    class EnumElemValue
    implements Data {
        ConstantPool.ConstCell type;
        ConstantPool.ConstCell value;

        public EnumElemValue(ConstantPool.ConstCell type, ConstantPool.ConstCell value) {
            this.type = type;
            this.value = value;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(101);
            this.type.write(out);
            this.value.write(out);
        }

        @Override
        public int getLength() {
            return 5;
        }
    }

    class ConstElemValue
    implements Data {
        char tag;
        ConstantPool.ConstCell indx;

        public ConstElemValue(char tag, ConstantPool.ConstCell indx) {
            this.tag = tag;
            this.indx = indx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(this.tag);
            this.indx.write(out);
        }

        @Override
        public int getLength() {
            return 3;
        }
    }

    class ArrayElemValue
    implements Data {
        ArrayList<Data> elemValues = new ArrayList();
        int arrayLength = 0;

        void add(Data elemValue) {
            this.elemValues.add(elemValue);
            this.arrayLength += elemValue.getLength();
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(91);
            out.writeShort(this.elemValues.size());
            for (Data eval : this.elemValues) {
                eval.write(out);
            }
        }

        @Override
        public int getLength() {
            return 3 + this.arrayLength;
        }
    }

    class ClassElemValue
    implements Data {
        ConstantPool.ConstCell indx;

        public ClassElemValue(ConstantPool.ConstCell indx) {
            this.indx = indx;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(99);
            this.indx.write(out);
        }

        @Override
        public int getLength() {
            return 3;
        }
    }

    class AnnotationElemValue
    implements Data {
        AnnotationData annotation;

        public AnnotationElemValue(AnnotationData annotation) {
            this.annotation = annotation;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeByte(64);
            this.annotation.write(out);
        }

        @Override
        public int getLength() {
            return 1 + this.annotation.getLength();
        }
    }
}

