/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.stream.Collectors;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.RuntimeConstants;
import org.openjdk.asmtools.jasm.Scanner;
import org.openjdk.asmtools.jasm.Tables;

public class Modifiers {
    private static Modifiers ref;
    public static final int MM_ATTR = 196608;
    public static final int MM_ACCESS = 7;
    public static final int MM_INTRF = 206343;
    public static final int MM_CLASS = 246839;
    public static final int MM_FIELD = 217311;
    public static final int MM_I_METHOD = 5323;
    public static final int MM_A_METHOD = 197639;
    public static final int MM_N_METHOD = 202887;
    public static final int MM_METHOD = 204287;
    public static final int MM_INNERCLASS = 226879;
    public static final int MM_REQUIRES = 36912;
    public static final int MM_EXPORTS = 36864;

    private Modifiers() {
    }

    public static boolean validRequires(int mod) {
        return (mod & 0xFFFF6FCF) == 0;
    }

    public static boolean validExports(int mod) {
        return (mod & 0xFFFF6FFF) == 0;
    }

    public static boolean validInnerClass(int mod) {
        return (mod & 0xFFFC89C0) == 0;
    }

    public static boolean validField(int mod) {
        return (mod & 0xFFFCAF20) == 0;
    }

    public static boolean validMethod(int mod) {
        return (mod & 0xFFFCE200) == 0;
    }

    public static boolean validInterface(int mod) {
        return (mod & 0xFFFCD9F8) == 0;
    }

    public static int getInvalidModifiers4Interface(int mod) {
        return mod & 0xFFFCD9F8;
    }

    public static boolean validClass(int mod) {
        return (mod & 0xFFFC3BC8) == 0;
    }

    public static int getInvalidModifiers4Class(int mod) {
        return mod & 0xFFFC3BC8;
    }

    public static boolean validAbstractMethod(int mod) {
        return (mod & 0xFFFCFBF8) == 0;
    }

    public static boolean validInitMethod(int mod) {
        return (mod & 0xFFFCE778) == 0;
    }

    public static boolean validInterfaceMethod(int mod, ClassData cd) {
        return (mod & 0xFFFFEB34) == 0 && (cd.cfv.major_version() >= 52 || Modifiers.isPublic(mod) && Modifiers.isAbstract(mod) && !Modifiers.isStatic(mod));
    }

    public static boolean validInterfaceField(int mod) {
        return mod == 25;
    }

    public static boolean isPublic(int mod) {
        return (mod & 1) != 0;
    }

    public static boolean isPrivate(int mod) {
        return (mod & 2) != 0;
    }

    public static boolean isProtected(int mod) {
        return (mod & 4) != 0;
    }

    public static boolean isInterface(int mod) {
        return (mod & 0x200) != 0;
    }

    public static boolean isAbstract(int mod) {
        return (mod & 0x400) != 0;
    }

    public static boolean isFinal(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isStatic(int mod) {
        return (mod & 8) != 0;
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    public static boolean isDeprecated(int mod) {
        return (mod & 0x20000) != 0;
    }

    public static boolean isTransient(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isAnnotation(int mod) {
        return (mod & 0x2000) != 0;
    }

    public static boolean isNative(int mod) {
        return (mod & 0x100) != 0;
    }

    public static boolean isStrict(int mod) {
        return (mod & 0x800) != 0;
    }

    public static boolean isEnum(int mod) {
        return (mod & 0x4000) != 0;
    }

    public static boolean isSuper(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isModule(int mod) {
        return (mod & 0x8000) != 0;
    }

    public static boolean isMandated(int mod) {
        return (mod & 0x8000) != 0;
    }

    public static boolean isSynchronized(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean isBridge(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isVolatile(int mod) {
        return (mod & 0x40) != 0;
    }

    public static boolean isVarArgs(int mod) {
        return (mod & 0x80) != 0;
    }

    public static boolean isSyntheticPseudoMod(int mod) {
        return (mod & 0x10000) != 0;
    }

    public static boolean isDeprecatedPseudoMod(int mod) {
        return (mod & 0x20000) != 0;
    }

    public static boolean hasPseudoMod(int mod) {
        return Modifiers.isSyntheticPseudoMod(mod) || Modifiers.isDeprecatedPseudoMod(mod);
    }

    public static boolean isTransitive(int mod) {
        return (mod & 0x10) != 0;
    }

    public static boolean isStaticPhase(int mod) {
        return (mod & 0x20) != 0;
    }

    public static boolean validAccess(int mod) {
        boolean retval = true;
        switch (mod & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    public static boolean both(int mod, int flagA, int flagB) {
        return (mod & (flagA | flagB)) == (flagA | flagB);
    }

    private static String getNames(int bits) {
        return RuntimeConstants.ACC_NAMES.entrySet().stream().filter(e -> ((Integer)e.getKey() & bits) != 0 && !((String)e.getValue()).isEmpty()).map(s -> (String)s.getValue()).collect(Collectors.joining(", "));
    }

    public static void checkClassModifiers(Environment env, int mod, Scanner scanner) {
        if (Modifiers.isInterface(mod)) {
            if (Modifiers.isEnum(mod)) {
                env.error(scanner.pos, "warn.invalid.modifier.class.intenum");
            } else if (!Modifiers.validInterface(mod)) {
                String names = Modifiers.getNames(Modifiers.getInvalidModifiers4Interface(mod));
                env.error(scanner.pos, "warn.invalid.modifier.int", (Object)(names.isEmpty() ? "." : " - " + names));
            }
            if (!Modifiers.isAbstract(mod)) {
                env.error(scanner.pos, "warn.invalid.modifier.int.abs");
            }
        } else {
            if (scanner.token != JasmTokens.Token.CLASS && !Modifiers.isEnum(mod) && scanner.token != JasmTokens.Token.ANNOTATION) {
                env.error(scanner.pos, "warn.missing.modifier.class");
            }
            if (!Modifiers.validClass(mod)) {
                String names = Modifiers.getNames(Modifiers.getInvalidModifiers4Class(mod));
                env.error(scanner.pos, "warn.invalid.modifier.class", (Object)(names.isEmpty() ? "." : " - " + names));
            }
            if (Modifiers.isAbstract(mod) && Modifiers.isFinal(mod)) {
                env.error(scanner.pos, "warn.invalid.modifier.class.finabs");
            }
        }
    }

    public static void checkFieldModifiers(ClassData cd, int mod, int pos) {
        Environment env = cd.env;
        if (cd.isInterface()) {
            if (!Modifiers.validInterfaceField(mod)) {
                env.error(pos, "warn.invalid.modifier.intfield");
            }
        } else {
            if (!Modifiers.validField(mod)) {
                env.error(pos, "warn.invalid.modifier.field");
            }
            if (Modifiers.both(mod, 16, 64)) {
                env.error(pos, "warn.invalid.modifier.fiva");
            }
            if (!Modifiers.validAccess(mod)) {
                env.error(pos, "warn.invalid.modifier.acc");
            }
        }
    }

    public static void checkMethodModifiers(ClassData cd, int mod, int pos, boolean is_init, boolean is_clinit) {
        Environment env = cd.env;
        if (!is_clinit) {
            if (cd.isInterface()) {
                if (is_init) {
                    env.error(pos, "warn.init.in_int");
                } else if (!Modifiers.validInterfaceMethod(mod, cd)) {
                    int badflags = mod & 0xFFFFEB34;
                    env.error(pos, "warn.invalid.modifier.intmth", (Object)(Modifiers.toString(badflags, Tables.CF_Context.CTX_METHOD) + "   *****" + Modifiers.toString(mod, Tables.CF_Context.CTX_METHOD) + "*****"));
                }
            } else {
                if (is_init && !Modifiers.validInitMethod(mod)) {
                    int badflags = mod & 0xFFFCE778;
                    env.error(pos, "warn.invalid.modifier.init", (Object)(Modifiers.toString(badflags, Tables.CF_Context.CTX_METHOD) + "   *****" + Modifiers.toString(mod, Tables.CF_Context.CTX_METHOD) + "*****"));
                } else if (Modifiers.isAbstract(mod)) {
                    if (!Modifiers.validAbstractMethod(mod)) {
                        int badflags = mod & 0xFFFCFBF8;
                        env.error(pos, "warn.invalid.modifier.abst", (Object)(Modifiers.toString(badflags, Tables.CF_Context.CTX_METHOD) + "   *****" + Modifiers.toString(mod, Tables.CF_Context.CTX_METHOD) + "*****"));
                    }
                } else if (!Modifiers.validMethod(mod)) {
                    env.error(pos, "warn.invalid.modifier.mth");
                }
                if (!Modifiers.validAccess(mod)) {
                    env.error(pos, "warn.invalid.modifier.acc");
                }
            }
        }
    }

    public static void checkInnerClassModifiers(ClassData cd, int mod, int pos) {
        Environment env = cd.env;
        if (!Modifiers.validInnerClass(mod)) {
            int badflags = mod & 0xFFFC89C0;
            env.error(pos, "warn.invalid.modifier.innerclass", (Object)(Modifiers.toString(badflags, Tables.CF_Context.CTX_INNERCLASS) + "   *****" + Modifiers.toString(mod, Tables.CF_Context.CTX_INNERCLASS) + "*****"));
        }
    }

    private static StringBuffer _accessString(int mod, Tables.CF_Context context) {
        StringBuffer sb = new StringBuffer();
        if (context == Tables.CF_Context.CTX_CLASS && Modifiers.isModule(mod)) {
            sb.append(JasmTokens.Token.MODULE.parsekey() + " ");
        }
        if (Modifiers.isPublic(mod)) {
            sb.append(JasmTokens.Token.PUBLIC.parsekey() + " ");
        }
        if (Modifiers.isPrivate(mod)) {
            sb.append(JasmTokens.Token.PRIVATE.parsekey() + " ");
        }
        if (Modifiers.isProtected(mod)) {
            sb.append(JasmTokens.Token.PROTECTED.parsekey() + " ");
        }
        if (Modifiers.isStatic(mod)) {
            sb.append(JasmTokens.Token.STATIC.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_METHOD && Modifiers.isFinal(mod)) {
            sb.append(JasmTokens.Token.FINAL.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_FIELD && Modifiers.isTransient(mod)) {
            sb.append(JasmTokens.Token.TRANSIENT.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_CLASS && Modifiers.isSuper(mod)) {
            sb.append(JasmTokens.Token.SUPER.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_METHOD && Modifiers.isSynchronized(mod)) {
            sb.append(JasmTokens.Token.SYNCHRONIZED.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_METHOD) {
            if (Modifiers.isBridge(mod)) {
                sb.append(JasmTokens.Token.BRIDGE.parsekey() + " ");
            }
            if (Modifiers.isVarArgs(mod)) {
                sb.append(JasmTokens.Token.VARARGS.parsekey() + " ");
            }
            if (Modifiers.isNative(mod)) {
                sb.append(JasmTokens.Token.NATIVE.parsekey() + " ");
            }
        }
        if (Modifiers.isAbstract(mod) && (context != Tables.CF_Context.CTX_CLASS || !Modifiers.isInterface(mod))) {
            sb.append(JasmTokens.Token.ABSTRACT.parsekey() + " ");
        }
        if ((context == Tables.CF_Context.CTX_CLASS || context == Tables.CF_Context.CTX_INNERCLASS || context == Tables.CF_Context.CTX_FIELD) && Modifiers.isFinal(mod)) {
            sb.append(JasmTokens.Token.FINAL.parsekey() + " ");
        }
        if ((context == Tables.CF_Context.CTX_CLASS || context == Tables.CF_Context.CTX_INNERCLASS) && Modifiers.isInterface(mod)) {
            if (Modifiers.isAnnotation(mod)) {
                sb.append(JasmTokens.Token.ANNOTATION_ACCESS.parsekey() + " ");
            }
            sb.append(JasmTokens.Token.INTERFACE.parsekey() + " ");
        }
        if (Modifiers.isStrict(mod)) {
            sb.append(JasmTokens.Token.STRICT.parsekey() + " ");
        }
        if (Modifiers.isSynthetic(mod)) {
            sb.append(JasmTokens.Token.SYNTHETIC.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_FIELD && Modifiers.isVolatile(mod)) {
            sb.append(JasmTokens.Token.VOLATILE.parsekey() + " ");
        }
        if (Modifiers.isEnum(mod)) {
            sb.append(JasmTokens.Token.ENUM.parsekey() + " ");
        }
        if (context == Tables.CF_Context.CTX_METHOD && Modifiers.isMandated(mod)) {
            sb.append(JasmTokens.Token.MANDATED.parsekey() + " ");
        }
        return sb;
    }

    public static String toString(int mod, Tables.CF_Context context) {
        StringBuffer sb = Modifiers._accessString(mod, context);
        if (Modifiers.isSyntheticPseudoMod(mod)) {
            sb.append("Synthetic(Pseudo) ");
        }
        if (Modifiers.isDeprecatedPseudoMod(mod)) {
            sb.append("Deprecated(Pseudo) ");
        }
        return sb.toString();
    }

    public static String moduleFlags(int flags) {
        return "";
    }

    public static String accessString(int mod, Tables.CF_Context context) {
        return context == Tables.CF_Context.CTX_MODULE ? Modifiers.moduleFlags(mod) : Modifiers._accessString(mod, context).toString();
    }
}

